/***********************************************************************
*FILE: ConfigDataClientHandler.h
*SW-COMPONENT: Internet
*DESCRIPTION: Header to ConfigMgmtClientHandler.c
*COPYRIGHT: Ã© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
***********************************************************************/

#ifndef CONFIG_MGMT_CLIENT_HANDLER_H
#define CONFIG_MGMT_CLIENT_HANDLER_H
#include <gio/gio.h>
#include <glib.h>

 /******************************************************************
 * Function:     vConfigMgmtProxyCallBack
 * Description:  Proxy Call back for Config management
 * Parameters:   source_object, res, user_data
 * Return:       void
 ******************************************************************/
 void vConfigMgmtProxyCallBack( GObject*      source_object,
                                GAsyncResult* res,
                                gpointer      user_data );

 /****************************************************************************
 * Function:    config_mgmt_service_appeared
 * Description: Service appeared call back of config management
 * Parameters:  connection , service name , owner name, userdata
 * Returns:     void
 *****************************************************************************/
 void
 config_mgmt_service_appeared ( GDBusConnection* connection,
                               const gchar*      name,
                               const gchar*      owner_name,
                               gpointer          user_data );


/******************************************************************
 * Function:    vSetPublicItemCallBack
 * Description: Call back for SetPublicConfigItem result
 * Parameters:  GObject*, GAsyncResult, user_data
 * Returns:     void
 *******************************************************************/
 void vSetPublicItemCallBack( GObject*      pObject,
                              GAsyncResult* result,
                              gpointer      user_data );
	
/******************************************************************
 * Function:    vGetPublicItemCallBack
 * Description: Call back for GetPublicConfigItem result
 * Parameters:  GObject*, GAsyncResult, user_data
 * Returns:     void
 *******************************************************************/
 void vGetPublicItemCallBack( GObject*      pObject,
                              GAsyncResult* result,
                              gpointer      user_data );

/***************************************************************
 * Function:    vCleanUpConfigMgmtService
 * Description: Performs the clean up for Configuration
                Management service
 * Parameters:  void
 * Returns:     void
 ***************************************************************/
 void vCleanUpConfigMgmtService();

#endif
