#ifndef CONFIG_CLIENT_BUS_MAP
#define CONFIG_CLIENT_BUS_MAP

#include "ConfigMgmtClientInterface.h"

#ifdef __cplusplus
extern "C"
{
#endif
 /*************************************************************************
 * Function:    AddConfigClientBusPair
 * Description: Maps the client bus with its registered config item
 * Parameters:  item name, bus name, item type
 * Returns:     void
 **************************************************************************/
 void AddConfigClientBusPair( char*           itemName,
                              char*           dbusName,
                              ConfigItemType  itemType);

 /*************************************************************************
 * Function:    RemoveConfigClientBusPair
 * Description: Removes the client bus mapping with
                its unregistered config item
 * Parameters:  item name, bus name, item type
 * Returns:     void
 **************************************************************************/
 void RemoveConfigClientBusPair( char*           itemName,
                                 char*           dbusName,
                                 ConfigItemType  itemType );

 /****************************************************************************
 * Function:    FindClientBusName
 * Description: Provides the client dbus name for the
                requested config item
 * Parameters:  item name, item type
 * Returns:     char*->dbus name if present, else NULL
 ****************************************************************************/
 char* FindClientBusName( char*          itemName,
                          ConfigItemType itemType );
#ifdef __cplusplus
}
#endif

#endif
