/******************************************************************
*FILE: ap-cm-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to
*             gateway config manager interfaces
*COPYRIGHT: Â© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_CONFIG_MANAGER_ENUMS__
#define __AP_CONFIG_MANAGER_ENUMS__

/**
 * ApConfigRegStatus:
 * @AP_CONFIG_REG_STATUS_SUCCESS:               Successfuly registered / 
                                                unregistered for requested /
												config item          
 * @AP_CONFIG_REG_STATUS_FAILED:                Failed to register /
                                                unregister for requested /
												config item 
 * @AP_CONFIG_REG_STATUS_UNKNOWN_ITEM:          Requested config item is unknown 
 * @AP_CONFIG_REG_STATUS_ALREADY_REGISTERED:    App already registered for /
                                                requested config item
 * @AP_CONFIG_REG_STATUS_ALREADY_UNREGISTERED:  App already unregistered for /
                                                requested config item
 * @AP_CONFIG_REG_STATUS_INVALID_INPUT:         Input args validation error 
 * @AP_CONFIG_REG_STATUS_INTERNAL_ERROR:        Internal or unknown error at AGW
 *
 * Status of register / unregister to public / private config items
 *
 * Since: 1.0
 */
typedef enum
{
  AP_CONFIG_REG_STATUS_SUCCESS = 0,
  AP_CONFIG_REG_STATUS_FAILED,
  AP_CONFIG_REG_STATUS_UNKNOWN_ITEM,
  AP_CONFIG_REG_STATUS_ALREADY_REGISTERED,
  AP_CONFIG_REG_STATUS_ALREADY_UNREGISTERED,
  AP_CONFIG_REG_STATUS_INVALID_INPUT,
  AP_CONFIG_REG_STATUS_INTERNAL_ERROR
} ApConfigRegStatus;


/**
 * ApConfigDataActionStatus
 * @AP_CONFIG_ACTION_STATUS_SUCCESS:           Config GET / SET / UPDATE success    
 * @AP_CONFIG_ACTION_STATUS_FAILED:            Config GET / SET / UPDATE failed
 * @AP_CONFIG_ACTION_STATUS_UNKNOWN_ITEM:      Requested config item is unknown 
 * @AP_CONFIG_ACTION_STATUS_PERMISSION_ERROR:  No permission to GET /
                                               SET requested item 
 * @AP_CONFIG_ACTION_STATUS_INVALID_INPUT:     Invalid configuration value
 * @AP_CONFIG_ACTION_STATUS_INVALID_SIGNATURE: Invalid signature   
 * @AP_CONFIG_ACTION_STATUS_INTERNAL_ERROR:    Internal or unknown error at AGW
 *
 * Status of config data actions like GET / SET / UPDATE of config items
 *
 * Since: 1.0
 */
 typedef enum
 {
     AP_CONFIG_ACTION_STATUS_SUCCESS = 0,
     AP_CONFIG_ACTION_STATUS_FAILED,	 
     AP_CONFIG_ACTION_STATUS_UNKNOWN_ITEM,
     AP_CONFIG_ACTION_STATUS_PERMISSION_ERROR,
     AP_CONFIG_ACTION_STATUS_INVALID_INPUT,
     AP_CONFIG_ACTION_STATUS_INVALID_SIGNATURE,
     AP_CONFIG_ACTION_STATUS_INTERNAL_ERROR
 }ApConfigDataActionStatus;

/**
 * ApConfigDataFormat
 * @AP_CONFIG_DATA_FORMAT_DEFAULT: Config data in default format /
                                   (a(ss) format)
 * @AP_CONFIG_DATA_FORMAT_XML:     Config data in XML format
 *
 * The configuration data formats
 *
 * Since 1.0
 */
 typedef enum
 {
     AP_CONFIG_DATA_FORMAT_DEFAULT = 0,
     AP_CONFIG_DATA_FORMAT_XML = 1
 }ApConfigDataFormat;

#endif /* __AP_CONFIG_MANAGER_ENUMS__ */
