/***********************************************************************
*FILE: ConfigMgmtDBusHandler.h
*SW-COMPONENT: Internet
*DESCRIPTION: Header for ConfigMgmtDBusHandler.c
*COPYRIGHT: Ã© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
***********************************************************************/

#ifndef CONFIG_MGMT_DBUS_HANDLER_H
#define CONFIG_MGMT_DBUS_HANDLER_H
#include "automotiveproxy_config_mgmt_gen.h"
#include "ConfigMgmtClientInterface.h"

/*********************************************************
 * Function:    handle_register_public_item
 * Description: Registers for the requested 
                public config item 
 * Parameters:  proxyObj, invocation, itemName, 
                format, dbusName, user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_register_public_item( ConfigurationManagement* proxyObj,
                                      GDBusMethodInvocation*   invocation,
                                      gchar*                   itemName,
                                      guint                    format,
                                      gchar*                   dbusName,
                                      gpointer                 userData );

/*********************************************************
 * Function:    handle_register_private_item
 * Description: Registers for the requested
                private config item
 * Parameters:  proxyObj, invocation, itemName,
                dbusName, format, user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_register_private_item( ConfigurationManagement* proxyObj,
                                       GDBusMethodInvocation*   invocation,
                                       gchar*                   itemName,
                                       gchar*                   dbusName,
                                       guint                    format,
                                       gpointer                 userData );

/*********************************************************
 * Function:    handle_unregister_public_item
 * Description: unregisters the requested
                public config item
 * Parameters:  proxyObj, invocation, itemName,
                dbusName, user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_unregister_public_item(  ConfigurationManagement* proxyObj,
                                         GDBusMethodInvocation*   invocation,
                                         gchar*                   itemName,
                                         gchar*                   dbusName,
                                         gpointer                 userData );

/*********************************************************
 * Function:    handle_unregister_private_item
 * Description: unregisters the requested
                private config item
 * Parameters:  proxyObj, invocation, itemName,
                dbusName, user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_unregister_private_item( ConfigurationManagement* proxyObj,
                                         GDBusMethodInvocation *invocation,
                                         gchar*   itemName,
                                         gchar*   dbusName,
                                         gpointer userData );

/*********************************************************
 * Function:    handle_set_public_item
 * Description: Sets the public config item 
 * Parameters:  proxyObj, invocation, itemName,
                item, user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_set_public_item( ConfigurationManagement* proxyObj,
                                 GDBusMethodInvocation*   invocation,
                                 gchar*                   itemName,
                                 GVariant*                item,
                                 gpointer                 userData );


/*********************************************************
 * Function:    handle_get_public_item
 * Description: Gets the public config item
 * Parameters:  proxyObj, invocation, itemName,
                user_data
 * Returns:     gboolean
 *********************************************************/
gboolean handle_get_public_item( ConfigurationManagement* proxyObj,
                                 GDBusMethodInvocation*   invocation,
                                 gchar*                   itemName,
                                 gpointer                 userData );

 /*******************************************************************************
 * Function:    bHandleRegisterConfigRequest
 * Description: Handles the Registration request for config items
 * Parameters:  proxyObj, invocation, itemName,
                dbusName, format, user_data, itemType
 * Returns:     gboolean
 ******************************************************************************/
 gboolean bHandleRegisterConfigRequest( ConfigurationManagement* proxyObj,
                                        GDBusMethodInvocation*   invocation,
                                        gchar*                   itemName,
                                        gchar*                   dbusName,
                                        guint                    format,
                                        gpointer                 user_data,
                                        ConfigItemType           itemType );

 /****************************************************************************
 * Function:    bHandleUnregisterConfigRequest
 * Description: Handles the config unregistration request
 * Parameters:  proxyObj, invocation, itemName,
                dbusName, user_data, itemType
 * Returns:     gboolean
 ****************************************************************************/
 gboolean bHandleUnregisterConfigRequest( ConfigurationManagement* proxyObj,
                                          GDBusMethodInvocation*   invocation,
                                          gchar*                   itemName,
                                          gchar*                   dbusName,
                                          gpointer                 user_data,
                                          ConfigItemType           itemType  );

 /*************************************************************************
 * Function:    initializeConfigMgmt
 * Descriprion: Initializes the gateway config manager interface
 * Parameters:  void
 * Returns:     gboolean
 ************************************************************************/
 gboolean initializeConfigMgmt();

 /*************************************************************************
 * Function:    uninitializeConfigMgmt
 * Descriprion: uninitializes the gateway config management interface
 * Parameters:  void
 * Returns:     void
 ************************************************************************/
 void uninitializeConfigMgmt();

#endif
