/***********************************************************************
*FILE: ConfigDataDBusHandler.h
*SW-COMPONENT: Internet
*DESCRIPTION: Header for ConfigDataDBusHandler.c
*COPYRIGHT: Ã© 2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
***********************************************************************/
#ifndef CONFIG_DATA_DBUS_HANDLER_H
#define CONFIG_DATA_DBUS_HANDLER_H

#include "automotiveproxy_config_data_gen.h"

/***********************************************************************
 * Function:    handle_set_private_item,
 * Description: Sets the private configuration item
 * Parameters:  proxyObj, invocation, itemName,
                item, user_data
 * Returns:     gboolean
 ***********************************************************************/
gboolean handle_set_private_item( ConfigData*            proxyObj,
                                  GDBusMethodInvocation* invocation,
                                  gchar*                 itemName,
                                  GVariant*              item,
                                  gpointer               userData);

/***********************************************************************
 * Function:    handle_get_private_item,
 * Description: Gets the private configuration item
 * Parameters:  proxyObj, invocation, itemName, user_data
 * Returns:     gboolean
***********************************************************************/
gboolean handle_get_private_item( ConfigData*            proxyObj,
                                  GDBusMethodInvocation* invocation,
                                  gchar*                 itemName,
                                  gpointer               userData );

/***********************************************************************
 * Function:    handle_exchange_descmo
 * Description: Handles private config set / get in XML format
 * Parameters:  proxyObj, invocation, itemName, 
                itemXML, signatureXML, user_data
 * Returns:     gboolean
***********************************************************************/
gboolean handle_exchange_descmo(  ConfigData*            proxyObj,
                                  GDBusMethodInvocation* invocation,
                                  gchar*                 itemName,
                                  gchar*                 itemXML,
                                  gchar*                 signatureXML,
                                  gpointer               userData );

/***********************************************************************
 * Function:    handle_update_public_config_item
 * Description: Handles update of public config items
 * Parameters:  proxyObj, invocation, itemName,
                itemData, updateType, userData
 * Returns:     gboolean
 ***********************************************************************/
gboolean handle_update_public_config_item( ConfigData*            proxyObj,
                                           GDBusMethodInvocation* invocation,
                                           gchar*                 itemName,
                                           GVariant*              itemData,
                                           guint32                updateType,
                                           gpointer               userData );

/***********************************************************************
 * Function:    initializeConfigData
 * Descriprion: Initializes the gateway config manager interface
 * Parameters:  void
 * Returns:     gboolean
 ************************************************************************/
gboolean initializeConfigData();

/*************************************************************************
 * Function:    uninitializeConfigData
 * Descriprion: uninitializes the gateway config manager interface
 * Parameters:  void
 * Returns:     void
 ************************************************************************/
void uninitializeConfigData();

#endif

