/*!
*******************************************************************************
* @file             : DBusToBTProxyWrapper.h
*******************************************************************************
*  - PROJECT:       : fc_genericproxy
*  - SW-COMPONENT   : Gateway - Phone
*  - DESCRIPTION    : C Wrapper for DBus and BT client handler
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|----------------------
* 06.12.2016|  RHK6KOR      |   1.0.0  | Initial version     
******************************************************************************/

#ifndef _BTDBUS_WRAPPER_H_
#define _BTDBUS_WRAPPER_H_

#include <stdbool.h>

//BT D-Bus WRAPPERS
#ifdef __cplusplus
extern "C"
{
#endif

/**
@brief     Wrapper function to get BT services
@param     void
@return    bool
*/
bool bGetServicesMethod();

/**
 @brief     Wrapper function to  get sources
 @param     void
 @return    bool
 */
bool bGetSources();

/**
 @brief  function to export bluetooth service methods & signals
 @param  void
 @return void
*/
void vExportAGWBluetoothInterface();

/**
 @brief  function to unexport bluetooth interface
 @param  void
 @return void
*/
void vUnexportAGWBluetoothInterface();

#ifdef __cplusplus
}
#endif //__cplusplus
#endif //_BTDBUS_WRAPPER_H_
