/******************************************************************************
*
* FILE:          AudioManager_ClientInterface.h
* SW-COMPONENT:  Audio Manager
* PROJECT:       Automotive Gateway
* DESCRIPTION:   Client interface for AudioManager
******************************************************************************/
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#ifndef AUDIO_MANAGER_CLIENT_INTERFACE_H_
#define AUDIO_MANAGER_CLIENT_INTERFACE_H_

#ifdef __cplusplus
#include "FC_Gateway_AudioRouteHandler.h"
#endif

#include "ap-audio-manager-enums.h"
#include <stdbool.h>
#include <stdint.h>
#include <gio/gio.h>

#ifdef __cplusplus
extern "C"
{
#endif

/**
@brief     Wrapper function for AudioReleaseRequest.
@param     void
@return    bool
*/
bool bReleaseAudioRoute(int srcNum);

/**
@brief     Wrapper function for AudioRouteRequest.
@param     void
@return    bool
*/
bool bRequestAudioRoute(int srcNum, bool *srcStatus);

/**
@brief     Wrapper function for MuteState.
@param     void
@return    bool
*/
bool bRequestMuteState(int arg_Source,bool muteState);

/**
@brief     Wrapper function for SourceAvailability.
@param     void
@return    bool
*/
bool bRequestSourceAvailability();

/**
@brief     Wrapper function for bRequest_SetSourceAvailability.
@param     void
@return    int, bool
*/
bool bRequestSetSourceAvailability(int arg_Source,bool arg_Availability);

/**
@brief     Wrapper function for bRequest_SourceActivityResult.
@param     guchar, int
@return    bool
*/
bool bRequestSourceActivityResult(guchar arg_Source,unsigned int arg_Status);

/**
@brief     send the source activity signal.
@param     int ,ApAudioSourceStatus
@return    gboolean
*/
gboolean bSendSourceActivity(int iSrcNum, ApAudioSourceStatus eStatus);

/**
@brief     send on-allocate signal.
@param     guchar, GVariant*
@return    gboolean
*/
gboolean bSendOnAllocate(guchar iSrcNum, GVariant* varAlsa);

/**
@brief     send de-allocate signal.
@param     int
@return    gboolean
*/
gboolean bSendDeallocate(int iSrcNum);

/**
@brief     send mutestate signal.
@param     int
@return    gboolean
*/
gboolean bSendMuteState(int iSrcNum, ApAudioMuteStatus enMuteState);


#ifdef __cplusplus
}
#endif //__cplusplus

#ifdef __cplusplus

/**
@brief     Gets instance of Audio manager
@param     procgenericgateway_tclMainApp
@return    fc_gateway_tclAudioRouteHandler* 
*/

fc_gateway_tclAudioRouteHandler*
poGetAudioManagerInstance(procgenericgateway_tclMainApp* poMainAppl);

#endif
#endif //AUDIO_MANAGER_CLIENT_INTERFACE_H_
#endif