/*!
*************************************************************************************
* @file             : Timer_Gateway.h
*************************************************************************************
*  - PROJECT:       : Automotive Gateway
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Single Timer loop framework of gateway
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------------
* 14.07.2017 | IPD5KOR(RBEI/ECO2) | 1.0.0 | methods for periodic call back handling
*
**************************************************************************************/

#include <glib.h>


#define MAX_NUMBER_OF_EVENTS 200
#define MIN_INTERVAL  500
#define MAX_EVENT_NAME_LENGTH 100


typedef gboolean (*EventCB)(gpointer);

typedef struct  {
    gchar event_name[MAX_EVENT_NAME_LENGTH] ;
    long int lastExecutedTime ;
    long int interval ;
    EventCB call_back;
}Gateway_Event;

void vStartTimer();
void vStopTimer();
#ifdef __cplusplus
extern "C" { 
#endif
gboolean registerPeriodicEvent(const gchar* name,
                               long int interval,
                               EventCB callback);

gboolean unregisterPeriodicEvent(const gchar* event_name);

void deleteEvent(int eventId);
#ifdef __cplusplus
}
#endif
gboolean runTimer(gpointer data);
long int getCurrentTime();
void findOptimumTimerFreq();
void* restartTimer(void* arg);
void resetLET();
