/*!
*******************************************************************************
* @file             : LCMDBusHandler.h
*******************************************************************************
*  - PROJECT:       : LCM DBus handler method
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : LCM handler methods for automotive API's
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 09.01.2017 | RHK6KOR(RBEI/ECO2) | 0.1.0 | methods for LCM D-Bus Server handler
******************************************************************************/
#ifndef _GATEWAY_LCM_DBUS_HANDLER_H
#define _GATEWAY_LCM_DBUS_HANDLER_H

//system includes
#include <string.h>
#include <stdlib.h>
#include <dirent.h>
#include <systemd/sd-daemon.h>
#include <errno.h>
#include <stdbool.h>
#include <stdio.h> //memset

//project includes
#include "LifeCycleManager_generated.h"
#include "AutomDBusServer.h"
#include "ap-lifecycle-manager-enums.h"

#define ENABLE_SYSTEMD_NOTIFY_FOR_CONTAINER 0
#define UNUSED(x) (void)(x)

//defines
#define DEFAULT_LCM_TIMEOUT       9000        /* Milli seconds*/
#define DEFAULT_DBUS_TIMEOUT      (6 * 1000)  /* Milli seconds*/

#define LCM_CLIENT_RESPONSE_TIME_OUT 7000

#define GATEWAY_SYSTEM_BUS_NAME    "com.bosch.AutomotiveProxy.LifeCycleConsumer"
#define GATEWAY_SYSTEMBUS_OBJ_PATH "/org/genivi/NodeStateManager/LifeCycleConsumer/agw"
#define LCM_BUS_NAME               "org.genivi.NodeStateManager"
#define LCM_OBJECT_PATH            "/org/genivi/NodeStateManager/Consumer"
#define LCM_IFACE_NAME             "org.genivi.NodeStateManager.Consumer"

#define PROC_DIR_PATH             "/proc"

#define NSM_SHUTDOWNTYPE_NOT      0x00000000U                  
#define NSM_SHUTDOWNTYPE_NORMAL   0x00000001U    
#define NSM_SHUTDOWNTYPE_FAST     0x00000002U    
#define NSM_SHUTDOWNTYPE_RUNUP    0x80000000U    


typedef enum
{
	kReady = 0,
	kWatchDog
} watchdogType;

struct ShutdownClient
{
  gchar            *sender_name;
  ApLifeCycleManagerMode  shutdown_mode;
  guint32          request_id;
  bool             is_registered;
  bool             bReponseRcvd;
};

typedef struct ShutdownClient ShutdownClient;



/******************************************************************************
 * Function:    handle_register
 * Description: Handles LCM register method
 * Parameters:  object, invocation, arg_credentials and request_mode
 * Return:      bool
 *****************************************************************************/

gboolean handle_register(LifeCycleManager* object,
                GDBusMethodInvocation *invocation,
				GVariant *arg_credentials,
				guint arg_request_mode
				);

/******************************************************************************
 * Function:    handle_lifecycle_request_complete
 * Description: Handle life cycle complete reponse from client
 * Parameters:  object, invocation, arg_request_id
 * Return:      bool
 *****************************************************************************/
gboolean handle_lifecycle_request_complete(LifeCycleManager* object,
                GDBusMethodInvocation *invocation,
                guint arg_request_id
                );

				
/******************************************************************************
 * Function:    new_shutdown_client
 * Description: creates a new shutdown client
 * Parameters: sender name, ApLifeCycleManagerMode,bEmitSignal
 * Return:      ShutdownClient*
 *****************************************************************************/
ShutdownClient* new_shutdown_client(gchar* sender_name,
                                    ApLifeCycleManagerMode shutdown_mode,
                                    bool bEmitSignal);

/******************************************************************************
 * Function:    do_init_shutdown_client_hash_table
 * Description: Inits the hash table for shutdown clients/
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
void do_init_shutdown_client_hash_table(void);

/******************************************************************************
 * Function:    destroy_shutdown_client
 * Description: Destroys the shutdown client
 * Parameters:  ShutdownClient
 * Return:      void
 *****************************************************************************/
void destroy_shutdown_client(ShutdownClient* l_ShutdownClient);


/******************************************************************************
 * Function:    destroy_shutdown_client_hash_table
 * Description: Destroys the shutdown clients hash table.
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
void destroy_shutdown_client_hash_table(void);

/******************************************************************************
 * Function:    lifeCycleRequestTimeoutCallback
 * Description: Callback to send reponse to LCM as acknowlegement that
 *              system system is recieved and is consumed
 * Parameters:  gpointer data
 * Return:      gboolean
 *****************************************************************************/
gboolean lifeCycleRequestTimeoutCallback(gpointer data);

/******************************************************************************
 * Function:    bRegisterCallbackForLCMInterface
 * Description: Regsiter callback method for
 *              AGW object and interface exported to LCM
 * Parameters:  void
 * Return:      bool
 *****************************************************************************/
bool bRegisterCallbackForLCMInterface(void);

/******************************************************************************
 * Function:    bRegisterForSystemStatesWithLcm
 * Description: Register with LCM to get system states update
 * Parameters:  void
 * Return:      bool
 *****************************************************************************/
bool bRegisterForSystemStatesWithLcm(void);

/******************************************************************************
 * Function:    iGetLCMState
 * Description: function to get LCM state
 * Parameters:  void
 * Return:      guint32
 *****************************************************************************/
guint32 iGetLCMState();
#endif //_GATEWAY_LCM_DBUS_HANDLER_H