/*!
*******************************************************************************
* @file             : GatewayLCMClient.h
*******************************************************************************
*  - PROJECT:       : Automotive Gateway
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : D-Bus server for LCM Clients (container/domain) 
*  - COPYRIGHT      : &copy; 2017 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date      | Name          |  Version | Modification
* -----------|---------------|--------------------------|-----------------------
* 09.01.2017 | RHK6KOR(RBEI/ECO2) | 0.1.0 | methods for Gateway LCM API to cont.
******************************************************************************/
#ifndef _AUTOMOTIVE_GATEEWAY_LCM_SERVER_H
#define _AUTOMOTIVE_GATEEWAY_LCM_SERVER_H

#include <gio/gio.h>
#include <stdbool.h>
#include "LifeCycleManager_generated.h"
#include "LCMDBusHandler.h"

/******************************************************************************
 * Function:    bDoLCMDBusServerSetup
 * Description: Starts the Automotive LCM server
 * Parameters:  GDBusConnection*
 * Return:      void
 *****************************************************************************/
 bool      bDoLCMDBusServerSetup(GDBusConnection *pConnection);

 /******************************************************************************
 * Function:    vDoLCMDBusServerTearDown
 * Description: Stops the Automotive LCM server
 * Parameters:  void
 * Return:      void
 *****************************************************************************/
 void      vDoLCMDBusServerTearDown();
 
 /******************************************************************************
 * Function:    poGetLCMServerProxy()
 * Description: Gets the LCM serverProxyObject
 * Parameters:  void
 * Return:      LifeCycleManager*
 *****************************************************************************/
LifeCycleManager* poGetLCMServerProxy();

#endif //_AUTOMOTIVE_GATEEWAY_LCM_SERVER_H