/*!
*******************************************************************************
* @file             : ReadConfig.h
*******************************************************************************
*  - PROJECT:       : Automotive D-Bus server
*  - SW-COMPONENT   : Gateway
*  - DESCRIPTION    : Implemenatation to read AGW configuration file
*  - COPYRIGHT      : &copy; 2015 Robert Bosch Engineering & Business Solutions
*  - Documents      : Give link of relevant documents
*  - HISTORY
*
*  Date     | Name          |  Version | Modification
* ----------|---------------|--------------------------|-----------------------
* 05.16.2017 | sxn5kor(RBEI/ECO2) | 1.0.0 | read AGW configuration file
******************************************************************************/
#ifndef _READ_CONFIG_H
#define _READ_CONFIG_H
#include <stdbool.h>

typedef enum
{
    DBUS_TYPE_SESSION,
    DBUS_TYPE_TCPIP,
    DBUS_TYPE_IDDBUS
} dbusType;

bool loadConfig();

guchar readBusConfig();

gint readWaitParam();

char* readPrivateBusAddress();

gint readIncomingLimit();

void unloadConfig();

gboolean readGLogSettings();

#ifdef ENABLE_CGROUP_IMPL
void read_memory_threshold();
void* monitor_event(void* var);
#endif //ENABLE_CGROUP_IMPL

#ifdef ENABLE_FOR_CGROUP_TESTING
void memHog();
#endif //ENABLE_FOR_CGROUP_TESTING

#endif //_READ_CONFIG_H
