/*!
*******************************************************************************
* \file               procgenericgateway_tclService.cpp
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Gateway for Generic Internet Component.
DESCRIPTION:    CCA Application PROCGENERICGATEWAY.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                 | Modifications
19.01.2016 | rhk6kor                | Initial Version
\endverbatim
*******************************************************************************/

/******************************************************************************
| includes:
|---------------------------------------------------------------------------*/

#include "procgenericgateway_tclService.h"

//!Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "procgenericgateway_tclMainApp.h"

//Dlt
#include "dlt/dlt.h"
DLT_IMPORT_CONTEXT(AGW_framework);

#define GATEWAY_SERVICE_FI_MAJOR_VERSION        (tU16)1
#define GATEWAY_SERVICE_FI_MINOR_VERSION        (tU16)0
#define GATEWAY_SERVICE_FI_PATCH_VERSION        (tU16)0

/******************************************************************************
* FUNCTION : procgenericgateway_tclService::procgenericgateway_tclService
******************************************************************************/
procgenericgateway_tclService::procgenericgateway_tclService(
        procgenericgateway_tclMainApp* poMainAppl)
    : ahl_tclBaseOneThreadService(
          /* Main Appl Pointer*/   (ahl_tclBaseOneThreadApp*)poMainAppl,
          /* ID of offered Service*/ CCA_C_U16_SRV_GENERIC_PROXY,
          /* MajorVersion of offered Service*/ GATEWAY_SERVICE_FI_MAJOR_VERSION,
          /* MinorVersion of offered Service*/ GATEWAY_SERVICE_FI_MINOR_VERSION,
          /* PatchVersion of offered Service*/ GATEWAY_SERVICE_FI_PATCH_VERSION),
      m_poMainAppl(poMainAppl)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Constructor procgenericgateway_tclService() entered"));
    NORMAL_M_ASSERT(OSAL_NULL != poMainAppl);
} // end of procgenericgateway_tclService()

/******************************************************************************
* FUNCTION : procgenericgateway_tclService::~procgenericgateway_tclService
*****************************************************************************/
procgenericgateway_tclService::~procgenericgateway_tclService(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~procgenericgateway_tclService() entered"));
    m_poMainAppl = OSAL_NULL;
} // end of ~procgenericgateway_tclService()

/******************************************************************************
** FUNCTION:  t_Bool procgenericgateway_tclService::bInitialize();
******************************************************************************/
t_Bool procgenericgateway_tclService::bInitialize()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::bInitialize entered \n"));

    t_Bool bInit = true;

    return bInit;
}//! end of bInitialize()

/******************************************************************************
** FUNCTION:  t_Bool procgenericgateway_tclService::bUnInitialize();
******************************************************************************/
t_Bool procgenericgateway_tclService::bUnInitialize()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::bUnInitialize entered \n"));

    t_Bool bUnInit = true;

    return bUnInit;
}//! end of bUnInitialize()

/******************************************************************************
** FUNCTION:  t_Void procgenericgateway_tclService::vLoadSettings()
******************************************************************************/
t_Void procgenericgateway_tclService::vLoadSettings()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::vLoadSettings entered "));
}

/******************************************************************************
** FUNCTION:  t_Void procgenericgateway_tclService::vSaveSettings()
******************************************************************************/
t_Void procgenericgateway_tclService::vSaveSettings()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::vSaveSettings entered "));
}

/******************************************************************************
* \FUNCTION   : tVoid procgenericgateway_tclService::vOnServiceAvailable()
******************************************************************************/
tVoid procgenericgateway_tclService::vOnServiceAvailable(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::vOnServiceAvailable entered "));

} //!end of vOnServiceAvailable()

/******************************************************************************
* \FUNCTION   : tVoid procgenericgateway_tclService::vOnServiceUnavailable()
******************************************************************************/
tVoid procgenericgateway_tclService::vOnServiceUnavailable(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclService::vOnServiceUnavailable entered"));

    //!Add your code here

} //!end of vOnServiceUnavailable()

/******************************************************************************
* FUNCTION : tBool procgenericgateway_tclService::bStatusMessageFactory
******************************************************************************/
tBool 
procgenericgateway_tclService::bStatusMessageFactory(
        tU16 u16FunctionId,
        amt_tclServiceData& roOutMsg,
        amt_tclServiceData* poInMsg)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "bStatusMessageFactory() entered. FID = "),
            DLT_INT( u16FunctionId));

    tBool bSuccess = TRUE;
    return bSuccess;
} /* end of bStatusMessageFactory()*/

/******************************************************************************
*FUNCTION : tVoid procgenericgateway_tclService::vProcessTimer(tU16 u16TimerId)
******************************************************************************/
tVoid procgenericgateway_tclService::vProcessTimer(tU16 u16TimerId)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "vProcessTimer() entered. TimerID = "),DLT_INT( u16TimerId));

    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING("vProcessTimer() left"));
} //! end of vProcessTimer()


/******************************************************************************
*FUNCTION: tVoid procgenericgateway_tclService::vOnLoopbackService(amt_tclSer..
******************************************************************************/
/*virtual*/
tVoid 
procgenericgateway_tclService::vOnLoopback(tU16 u16ServiceID,
                                           amt_tclServiceData *poMessage)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "vOnLoopback() entered with service Id = "),
            DLT_INT( u16ServiceID));
}

/******************************************************************************
* FUNCTION:  tBool procgenericgateway_tclService::bUpdateClients
******************************************************************************/
tBool procgenericgateway_tclService::bUpdateClients(tCU16 cu16FunID)
{
    return true;
}
