/*!
*******************************************************************************
* \file               procgenericgateway_tclMainApp.cpp
*******************************************************************************
\verbatim
PROJECT:         G3G
SW-COMPONENT:   Gateway for Generic Internet Component.
DESCRIPTION:    CCA Application PROCGENERICGATEWAY.
COPYRIGHT:       &copy; RBEI
HISTORY:
Date       |  Author                          | Modifications
23.11.2015 |  rhk6kor                         | Initial Version
\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#include <unistd.h>
#include <gio/gio.h>
#include <malloc.h>

//@todo - Issue - std ambiguous usage should be removed
#include "procgenericgateway_tclMainApp.h"
#include "procgenericgateway_tclService.h"

//#include "asf/core/ApplicationLauncher.h"

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "AudioManager_ClientInterface.h"
#include "TextToSpeech_ClientInterface.h"
#include "Phone_ClientInterface.h"
#include "FC_Gateway_MediaPlayerClientHandler.h"
#include "FC_Gateway_BluetoothClientHandler.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "Tuner_PSAClientInterface.h"
#include "GenericGateway.h"
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "Tuner_GenericClientInterface.h"
#endif //#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
#include "FC_Gateway_ConfigurationClientHandler.h"
#include "FC_Gateway_SensorClientHandler.h"
#include "FC_Gateway_EcoScoreClientHandler.h"
#include "FC_Gateway_cfcVehicleClientHandler.h"
#include "AutomotiveGateway.h"
#include "FC_Gateway_SpmClientHandler.h"

#if ENABLE_CSM_IN_GATEWAY
#include "Vehicledata_ClientInterface.h"
#endif //ENABLE_CSM_IN_GATEWAY

#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"


#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_DATAPOOL
#define DP_S_IMPORT_INTERFACE_BASE
#include "dp_if.h"
#endif

#ifdef __cplusplus
extern "C"
{
#endif
#include "AutomDBusServer.h"
#ifdef __cplusplus
}
#endif

//Dlt
#include "dlt/dlt.h"

#include <pthread.h>

//#define WAIT_TIME_SEC 10

pthread_mutex_t mutex;
pthread_cond_t cond;
bool bLCMStateUpdated = false;

#define DLT_APPID_IDC_GATEWAY "GTA0"
//Dlt Context
DLT_DECLARE_CONTEXT(AGW_framework);
DLT_DECLARE_CONTEXT(AGW_Phone); //Phone

static GMainLoop *loop = NULL;

GMainLoop* getMainLoop()
{
    return loop;
}



/******************************************************************************
| defines
|----------------------------------------------------------------------------*/
/*****************************************************************************/

/******************************************************************************
| INITIALIZATION OF STATIC MEMBER VARIABLES
|----------------------------------------------------------------------------*/
procgenericgateway_tclMainApp* 
procgenericgateway_tclMainApp::m_poMainAppInstance = NULL;

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
fc_gateway_tclAudioRouteHandler* 
procgenericgateway_tclMainApp::m_poAudioRouteHandler = NULL;

FC_Gateway_TunerClientHandler*
procgenericgateway_tclMainApp::m_poTunerClientHandler = NULL;

FC_Gateway_TunerMasterClientHandler*
procgenericgateway_tclMainApp::m_poTunerMasterClientHandler = NULL;

FC_Gateway_TunerDABClientHandler*
procgenericgateway_tclMainApp::m_poTunerDABClientHandler = NULL;
#endif

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

fc_gateway_tcl_phoneclienthandler* 
procgenericgateway_tclMainApp::m_poPhoneClientHandler = NULL;

fc_gateway_tcl_phonebookclienthandler* 
procgenericgateway_tclMainApp::m_poPhoneBookClientHandler = NULL;

FC_Gateway_TTSClientHandler*
procgenericgateway_tclMainApp::m_poTTSClientHandler = NULL;

fc_gateway_tcl_messageclienthandler*
procgenericgateway_tclMainApp::m_poMessageClientHandler = NULL;

FC_Gateway_MediaPlayerClientHandler*
procgenericgateway_tclMainApp::m_poMediaPlayerClientHandler = NULL;

fc_gateway_tcl_bluetoothclienthandler*
procgenericgateway_tclMainApp::m_pofc_gateway_tcl_bluetoothclienthandler=NULL;

#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
cea_FC_Gateway_TunerClientHandler*
procgenericgateway_tclMainApp::m_pocea_TunerClientHandler = NULL;

#if ENABLE_CSM_IN_GATEWAY
FC_Gateway_VehicleDataClientHandler*
procgenericgateway_tclMainApp::m_poVehicleDataClientHandler = NULL;
#endif //ENABLE_CSM_IN_GATEWAY
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
FC_Gateway_ConfigurationClientHandler *
procgenericgateway_tclMainApp::m_poFC_Gateway_ConfigurationClientHandler = NULL;

fc_gateway_tcl_sensorclienthandler*
procgenericgateway_tclMainApp::m_poSensorclienthandler = NULL;

FC_Gateway_SpmClientHandler*
procgenericgateway_tclMainApp::m_poFC_Gateway_SpmClientHandler = NULL;

FC_Gateway_EcoScoreClientHandler* 
procgenericgateway_tclMainApp::m_poFC_Gateway_EcoScoreClientHandler = NULL;

FC_Gateway_cfcVehicleClientHandler*
procgenericgateway_tclMainApp::m_poFC_Gateway_cfcVehicleDataClientHandler = NULL;

FC_Gateway_SpmClientHandler* 
procgenericgateway_tclMainApp::m_poSpmClientHandler = NULL;

#if ENABLE_CSM_IN_GATEWAY
FC_Gateway_Vehicle_CSMClientHandler* 
procgenericgateway_tclMainApp::m_poVehicleCSMClientHandler = NULL;
#endif //ENABLE_CSM_IN_GATEWAY

#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI


/******************************************************************************
| METHODS
|----------------------------------------------------------------------------*/

/******************************************************************************
| Initialization of static variables.
|----------------------------------------------------------------------------*/

/******************************************************************************
**FUNCTION   : procgenericgateway_tclMainApp::procgenericgateway_tclMainApp()
******************************************************************************/
procgenericgateway_tclMainApp::procgenericgateway_tclMainApp()
    : ahl_tclBaseOneThreadApp(CCA_C_U16_APP_GENERIC_PROXY),
      m_poService(OSAL_NULL)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Constructor procgenericgateway_tclMainApp() entered"));
    procgenericgateway_tclMainApp::m_poMainAppInstance = this;
    m_poService = new procgenericgateway_tclService(this);
    m_poLauncher = NULL;

    //TR_TTFIS_CLIMATECTRL is a temporary trace channel until we get one.   
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Constructor procgenericgateway_tclMainApp() left"));

}  //!end of procgenericgateway_tclMainApp()

/******************************************************************************
* FUNCTION   : procgenericgateway_tclMainApp::vTraceCallbackFunction
* DESCRIPTION: Callback function for TTFIS command channel of __APP_NAME__
* PARAMETER  : [IN] puchData = buffer with trace input data
* RETURNVALUE: None
******************************************************************************/
//tVoid
//procgenericgateway_tclMainApp::vTraceCallbackFunction(const tUChar* puchData)
//{
//    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
//                "procgenericgateway_tclMainApp::vTraceCallbackFunction() "
//                "entered"));

//    if(NULL!=m_poProcgenericgateway_Trace)
//    {
//        m_poProcgenericgateway_Trace->vHandleTraceMsg(puchData);
//    }
//    else
//    {
//        DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
//                    "bad m_poProcgenericgateway_Trace to handle"
//                    "trace message."));
//    }

//    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
//                "procgenericgateway_tclMainApp::vTraceCallbackFunction left"));
//}

/******************************************************************************
* \FUNCTION   : procgenericgateway_tclMainApp::~procgenericgateway_tclMainApp()
******************************************************************************/
procgenericgateway_tclMainApp::~procgenericgateway_tclMainApp()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~procgenericgateway_tclMainApp() entered"));

    vUnplugTrace(TR_TTFIS_CLIMATECTRL);

    /* Moving deletion of launcher to vOnApplicationClose
   if(NULL != m_poLauncher)
   {
     delete m_poLauncher;
     m_poLauncher = NULL;
   }   */
    malloc_trim(0);
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "Destructor ~procgenericgateway_tclMainApp() left"));

}  //!end of ~procgenericgateway_tclMainApp()

/******************************************************************************
      * \FUNCTION   : tBool procgenericgateway_tclMainApp::bOnInit()
******************************************************************************/
tBool procgenericgateway_tclMainApp::bOnInit()
{

    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::bOnInit() entered"));

    vStartAutomServer();

    if(m_poService!= NULL)
    {
        m_poService->bInitialize();
    }
    else
    {
        DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
                    "bad m_poService to start service"));
        return FALSE;
    }
	 return TRUE;
} //!  end of bOnInit()

/******************************************************************************
* \FUNCTION   : tBool procgenericgateway_tclMainApp::bCreateClientHandlers()
******************************************************************************/
tBool procgenericgateway_tclMainApp::bCreateClientHandlers()
{
    tBool bSuccess = TRUE;
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(__FUNCTION__));

#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    if(m_poAudioRouteHandler == NULL)
    {
        m_poAudioRouteHandler = poGetAudioManagerInstance(this);

        if (NULL == m_poAudioRouteHandler)
        {
            bSuccess = FALSE;
        }
    }
	
    // bcp9kor: Please dont move the order(DLT registration).
    if(m_poTunerClientHandler == NULL)
    {
        m_poTunerClientHandler = poGetTunerInstance(this);
        if (NULL == m_poTunerClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poTunerMasterClientHandler == NULL)
    {
        m_poTunerMasterClientHandler = poGetTunerMasterInstance(this);
        if (NULL == m_poTunerMasterClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poTunerDABClientHandler == NULL)
    {
        m_poTunerDABClientHandler = poGetTunerDABInstance(this);
        if (NULL == m_poTunerDABClientHandler)
        {
            bSuccess = FALSE;
        }
    }
    if(m_poPhoneClientHandler == NULL)
    {
        DLT_REGISTER_CONTEXT(AGW_Phone,"GWPH","Phonecontext for DLT Logging");
        m_poPhoneClientHandler = get_PhoneClientHandlerInstance(this);

        if (NULL == m_poPhoneClientHandler)
        {
            DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
                        "m_poPhoneClientHandler NULL"));
            bSuccess = FALSE;
        }
    }

    if(m_poTTSClientHandler == NULL)
    {
        m_poTTSClientHandler = poGetTTSInstance(this);

        if (NULL == m_poTTSClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poMessageClientHandler == NULL)
    {
        m_poMessageClientHandler = get_MessageClientHandlerInstance(this);
        if (NULL == m_poMessageClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poMediaPlayerClientHandler == NULL)
    {
        m_poMediaPlayerClientHandler =
                FC_Gateway_MediaPlayerClientHandler::getInstance(this);

        if (NULL == m_poMediaPlayerClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poPhoneBookClientHandler == NULL)
    {
        m_poPhoneBookClientHandler = get_PhonebookClientHandlerInstance(this);
        if (NULL == m_poPhoneBookClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_pofc_gateway_tcl_bluetoothclienthandler == NULL)
    {
        m_pofc_gateway_tcl_bluetoothclienthandler =
                fc_gateway_tcl_bluetoothclienthandler::getInstance(this);

        if(NULL == m_pofc_gateway_tcl_bluetoothclienthandler)
        {
            bSuccess = FALSE;
        }
    }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    if(m_pocea_TunerClientHandler == NULL)
    {
        m_pocea_TunerClientHandler = poGetCEATunerInstance(this);
        if (NULL == m_pocea_TunerClientHandler)
        {
            bSuccess = FALSE;
        }
    }
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
    if(m_poFC_Gateway_ConfigurationClientHandler == NULL)
    {
        m_poFC_Gateway_ConfigurationClientHandler =
                FC_Gateway_ConfigurationClientHandler ::getInstance(this);

        if(NULL == m_poFC_Gateway_ConfigurationClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poSensorclienthandler == NULL)
    {
        m_poSensorclienthandler =
                fc_gateway_tcl_sensorclienthandler::getInstance(this);

        if (NULL == m_poSensorclienthandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poFC_Gateway_SpmClientHandler == NULL)
    {
        m_poFC_Gateway_SpmClientHandler =
                FC_Gateway_SpmClientHandler::getInstance(this);

        if (NULL == m_poFC_Gateway_SpmClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poFC_Gateway_EcoScoreClientHandler == NULL)
    {
        m_poFC_Gateway_EcoScoreClientHandler =
                FC_Gateway_EcoScoreClientHandler::getInstance(this);
        if(NULL == m_poFC_Gateway_EcoScoreClientHandler)
        {
            bSuccess = FALSE;
        }
    }

    if(m_poFC_Gateway_cfcVehicleDataClientHandler == NULL)
    {
        m_poFC_Gateway_cfcVehicleDataClientHandler =
                FC_Gateway_cfcVehicleClientHandler::getInstance(this);
        if(NULL == m_poFC_Gateway_cfcVehicleDataClientHandler)
        {
            bSuccess = FALSE;
        }
    }
#if ENABLE_CSM_IN_GATEWAY
    if(m_poVehicleCSMClientHandler == NULL)
    {
        m_poVehicleCSMClientHandler = poGetCSMClientHandlerInstance(this);
        if(NULL == m_poVehicleCSMClientHandler)
        {
            bSuccess = FALSE;
        }
    }
#endif //ENABLE_CSM_IN_GATEWAY

    if(m_poSpmClientHandler == NULL)
    {
        m_poSpmClientHandler = FC_Gateway_SpmClientHandler::getInstance(this);
        if(NULL == m_poSpmClientHandler)
        {
            bSuccess = FALSE;
        }
    }
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#if ENABLE_CSM_IN_GATEWAY
    if(m_poVehicleDataClientHandler == NULL)
    {
        m_poVehicleDataClientHandler =
                FC_Gateway_VehicleDataClientHandler::getInstance(this);

        if (NULL == m_poVehicleDataClientHandler)
        {
            DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
                        "m_poVehicleDataClientHandler() FAILED"));
            bSuccess = FALSE;
        }
    }
#endif //ENABLE_CSM_IN_GATEWAY
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC


    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::bCreateClientHandlers() left"));
    return bSuccess;
}

/******************************************************************************
* \FUNCTION   : tBool procgenericgateway_tclMainApp::bDeleteClientHandlers()
******************************************************************************/
void procgenericgateway_tclMainApp::vDeleteClientHandlers()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(__FUNCTION__));


#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    if( OSAL_NULL != m_poAudioRouteHandler)
    {
        OSAL_DELETE m_poAudioRouteHandler;
        m_poAudioRouteHandler = OSAL_NULL;
    }


    if( OSAL_NULL != m_poPhoneClientHandler)
    {
        OSAL_DELETE m_poPhoneClientHandler; //OSAL_DELETE
        m_poPhoneClientHandler = OSAL_NULL;
    }

    if( OSAL_NULL != m_poTTSClientHandler)
    {
        OSAL_DELETE m_poTTSClientHandler; //OSAL_DELETE
        m_poTTSClientHandler = OSAL_NULL;
    }

    if( OSAL_NULL != m_poMediaPlayerClientHandler)
    {
        OSAL_DELETE m_poMediaPlayerClientHandler; //OSAL_DELETE
        m_poMediaPlayerClientHandler = OSAL_NULL;
    }

    if( OSAL_NULL != m_poPhoneBookClientHandler)
    {
        OSAL_DELETE m_poPhoneBookClientHandler; //OSAL_DELETE
        m_poPhoneBookClientHandler = OSAL_NULL;
    }

    if(OSAL_NULL!=m_pofc_gateway_tcl_bluetoothclienthandler)
    {
        OSAL_DELETE m_pofc_gateway_tcl_bluetoothclienthandler; //OSAL_DELETE
        m_pofc_gateway_tcl_bluetoothclienthandler = OSAL_NULL;
    }

    if( OSAL_NULL != m_poTunerMasterClientHandler)
    {
        OSAL_DELETE m_poTunerMasterClientHandler; //OSAL_DELETE
        m_poTunerMasterClientHandler = OSAL_NULL;
    }

    if( OSAL_NULL != m_poTunerDABClientHandler)
    {
        OSAL_DELETE m_poTunerDABClientHandler; //OSAL_DELETE
        m_poTunerDABClientHandler = OSAL_NULL;
    }

    //bcp9kor: Please donot move the order (DLT unregister is done here).
    if( OSAL_NULL != m_poTunerClientHandler)
    {
        OSAL_DELETE m_poTunerClientHandler; //OSAL_DELETE
        m_poTunerClientHandler = OSAL_NULL;
    }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
    if( OSAL_NULL != m_poSensorclienthandler)
    {
        OSAL_DELETE m_poSensorclienthandler;
        m_poSensorclienthandler = OSAL_NULL;
    }

    if(OSAL_NULL!=m_poFC_Gateway_SpmClientHandler)
    {
        OSAL_DELETE m_poFC_Gateway_SpmClientHandler; //OSAL_DELETE
        m_poFC_Gateway_SpmClientHandler = OSAL_NULL;
    }

    if(OSAL_NULL!=m_poFC_Gateway_EcoScoreClientHandler)
    {
        OSAL_DELETE m_poFC_Gateway_EcoScoreClientHandler; //OSAL_DELETE
        m_poFC_Gateway_EcoScoreClientHandler = OSAL_NULL;
    }

    if(OSAL_NULL != m_poFC_Gateway_cfcVehicleDataClientHandler)
    {
        OSAL_DELETE m_poFC_Gateway_cfcVehicleDataClientHandler; //OSAL_DELETE
        m_poFC_Gateway_cfcVehicleDataClientHandler = OSAL_NULL;
    }

    if(OSAL_NULL != m_poSpmClientHandler)
    {
        OSAL_DELETE m_poSpmClientHandler; //OSAL_DELETE
        m_poSpmClientHandler = OSAL_NULL;
    }

    if(OSAL_NULL!=m_poFC_Gateway_ConfigurationClientHandler)
    {
        OSAL_DELETE m_poFC_Gateway_ConfigurationClientHandler; //OSAL_DELETE
        m_poFC_Gateway_ConfigurationClientHandler = OSAL_NULL;
    }
#if ENABLE_CSM_IN_GATEWAY
    if(OSAL_NULL!=m_poVehicleCSMClientHandler)
    {
        OSAL_DELETE m_poVehicleCSMClientHandler; //OSAL_DELETE
        m_poVehicleCSMClientHandler = OSAL_NULL;
    }
#endif //ENABLE_CSM_IN_GATEWAY

#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    if( OSAL_NULL != m_pocea_TunerClientHandler)
    {
        OSAL_DELETE m_pocea_TunerClientHandler; //OSAL_DELETE
        m_pocea_TunerClientHandler = OSAL_NULL;
    }
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC   
#if ENABLE_CSM_IN_GATEWAY
    if( OSAL_NULL != m_poVehicleDataClientHandler)
    {
 
        OSAL_DELETE m_poVehicleDataClientHandler; //OSAL_DELETE
        m_poVehicleDataClientHandler = OSAL_NULL;
    }
#endif //ENABLE_CSM_IN_GATEWAY
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

}
/******************************************************************************
** FUNCTION   : tVoid procgenericgateway_tclMainApp::vOnApplicationClose()
******************************************************************************/
tVoid procgenericgateway_tclMainApp::vOnApplicationClose()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnApplicationClose()"\
                "entered"));

	vStopAutomServer();
    vCloseDbusConnection();
    if(NULL != m_poLauncher)
    {
        DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                    "Deleting launcher instance"));
        delete m_poLauncher;
        m_poLauncher = NULL;
    }

    if (OSAL_NULL != m_poService)
    {
        m_poService->bUnInitialize();
        delete m_poService;
        m_poService = NULL;
    }
    
    vDeleteClientHandlers();
    m_poMainAppInstance = NULL;

    ahl_tclBaseOneThreadApp::vOnApplicationClose();

    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnApplicationClose() left"));
    DLT_UNREGISTER_CONTEXT(AGW_Phone);
    DLT_UNREGISTER_CONTEXT(AGW_framework);
    DLT_UNREGISTER_APP();

}  //!  end of vOnApplicationClose()

/******************************************************************************
** FUNCTION   : tVoid procgenericgateway_tclMainApp::vOnLoadSettings()
******************************************************************************/
tVoid procgenericgateway_tclMainApp::vOnLoadSettings()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnLoadSettings() entered"));

    if (m_poLauncher == NULL)
    {
        DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                    "Creating launcher instance"));
        m_poLauncher = new ::asf::core::ApplicationLauncher;

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
        //launcher.launch (::genericgateway::executeGenericGateway);
        if(NULL != m_poLauncher)
        {
            DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                        "Launching for PSA RCC"));
            m_poLauncher->launch (::genericgateway::executeGenericGateway);
        }
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
        if(NULL != m_poLauncher)
        {
            DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                        "Launching for AIVI"));
            m_poLauncher->launch (::automotivegateway::executeAutomotiveGateway);
        }
        //launcher.launch (::automotivegateway::executeAutomotiveGateway);
#endif

    }

    bCreateClientHandlers();
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnLoadSettings() left"));
}   //!  end of vOnLoadSettings()

/******************************************************************************
* \FUNCTION   : tVoid procgenericgateway_tclMainApp::vOnSaveSettings()
******************************************************************************/
tVoid procgenericgateway_tclMainApp::vOnSaveSettings()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnSaveSettings() entered"));

    

    if (OSAL_NULL != m_poService)
    {
#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
        // Clear vehicledata buffers during shutdwon
        vClearVehicleDataBuffers();
#endif
        m_poService->vSaveSettings();
    }

    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::vOnSaveSettings() left"));
}  //!  end of vOnSaveSettings()


tVoid procgenericgateway_tclMainApp::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{
     DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING("Enter "),DLT_STRING(__FUNCTION__));

    if (_tclLoadPair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
    {
        DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                    "On start-up sending state change response"));

        vAppStateChanged (u32AppState, 0);
    }
    else if (_tclSavePair.bIfPairIncluded(u32OldAppState, u32AppState) == TRUE)
    {

        DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                    "On shutdown sending state change response"));
        if(NSM_SHUTDOWNTYPE_NOT == iGetLCMState())
        {
            DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                        "Not registered with LCM, no additional time is required"));
            vAppStateChanged (u32AppState, 0);
        }
        else{
            DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                        "Registered with LCM, additional time is required"));
            vAppStateChanged (u32AppState, 15000);
        }
    }

    ahl_tclBaseOneThreadApp::vOnNewAppState(u32OldAppState, u32AppState);
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING("Exit "),DLT_STRING(__FUNCTION__));

}

/******************************************************************************
** FUNCTION   : tVoid procgenericgateway_tclMainApp::vOnTimer(tU16 u16TimerId)
******************************************************************************/
tVoid procgenericgateway_tclMainApp::vOnTimer(tU16 u16TimerId)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "vOnTimer(): entered for TimerID "),DLT_INT( u16TimerId));

    DLT_LOG(AGW_framework,DLT_LOG_INFO,
            DLT_STRING("vOnTimer() left"));

}   //!   end of vOnTimer()

/******************************************************************************
** FUNCTION:  tVoid procgenericgateway_tclMainApp::vHandleTraceCmd
******************************************************************************/
/*static*/
tVoid procgenericgateway_tclMainApp::vHandleTraceCmd(tU8 const* const
                                                     cpu8Buffer)
{
    UNUSED(cpu8Buffer);
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING("vHandleTraceCmd() entered"));

    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING("vHandleTraceCmd() left"));

}

/***************************************************************************
** FUNCTION   : t_Void procgenericgateway_tclMainApp::vSignalHandler()
***************************************************************************/
t_Void procgenericgateway_tclMainApp::vSignalHandler(t_S32 s32SigNum, 
                                                     siginfo_t *pSiginfo,
                                                     t_Void *pContext)
{
    UNUSED(pSiginfo);
    UNUSED(pContext);
    DLT_LOG(AGW_framework,DLT_LOG_INFO,
            DLT_STRING("procgenericgateway_tclMainApp::"
                       "vSignalHandler:: Received signal  "),
            DLT_INT(s32SigNum));
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetInstance()
***************************************************************************/
procgenericgateway_tclMainApp* procgenericgateway_tclMainApp::poGetInstance()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetInstance"));
    return m_poMainAppInstance;
}
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetAudioRouteHandler()
***************************************************************************/
fc_gateway_tclAudioRouteHandler* 
procgenericgateway_tclMainApp::poGetAudioRouteHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetAudioRouteHandler"));
    NORMAL_M_ASSERT(NULL != m_poAudioRouteHandler);
    return m_poAudioRouteHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetPhoneClientHandler()
***************************************************************************/
fc_gateway_tcl_phoneclienthandler* 
procgenericgateway_tclMainApp::poGetPhoneClientHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetPhoneClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poPhoneClientHandler);
    return m_poPhoneClientHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetPhoneBookClientHandler()
***************************************************************************/
fc_gateway_tcl_phonebookclienthandler*
procgenericgateway_tclMainApp::poGetPhoneBookClientHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetPhoneBookClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poPhoneBookClientHandler);
    return m_poPhoneBookClientHandler;
}
/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetTTSClientHandler()
***************************************************************************/

FC_Gateway_TTSClientHandler*
procgenericgateway_tclMainApp::poGetTTSClientHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetTTSClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poTTSClientHandler);
    return m_poTTSClientHandler;
}

FC_Gateway_MediaPlayerClientHandler*
procgenericgateway_tclMainApp::poGetMediaPlayerClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetMediaPlayerClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poMediaPlayerClientHandler);
    return m_poMediaPlayerClientHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetBluetoothClientHandler()
***************************************************************************/
fc_gateway_tcl_bluetoothclienthandler*
procgenericgateway_tclMainApp::poGetBluetoothClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::"
                "m_pofc_gateway_tcl_bluetoothclienthandler"));
    NORMAL_M_ASSERT(NULL != m_pofc_gateway_tcl_bluetoothclienthandler);
    return m_pofc_gateway_tcl_bluetoothclienthandler;
}

fc_gateway_tcl_messageclienthandler*
procgenericgateway_tclMainApp::poGetMessageClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetMessageClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poMessageClientHandler);
    return m_poMessageClientHandler;
}

FC_Gateway_TunerMasterClientHandler*
procgenericgateway_tclMainApp::poGetTunerMasterClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,
            DLT_STRING(
                "procgenericgateway_tclMainApp::poGetTunerMasterClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poTunerMasterClientHandler);
    return m_poTunerMasterClientHandler;
}

FC_Gateway_TunerDABClientHandler*
procgenericgateway_tclMainApp::poGetTunerDABClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetTunerDABClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poTunerDABClientHandler);
    return m_poTunerDABClientHandler;
}

FC_Gateway_TunerClientHandler*
procgenericgateway_tclMainApp::poGetTunerClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetTunerClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poTunerClientHandler);
    return m_poTunerClientHandler;
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetcfcVehicleDataHandler()
***************************************************************************/
FC_Gateway_cfcVehicleClientHandler* 
procgenericgateway_tclMainApp::poGetcfcVehicleDataHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,
            DLT_STRING("procgenericgateway_tclMainApp"
                       "::m_poFC_Gateway_cfcVehicleDataClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poFC_Gateway_cfcVehicleDataClientHandler);
    return m_poFC_Gateway_cfcVehicleDataClientHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetSpmDataHandler()
***************************************************************************/
FC_Gateway_SpmClientHandler*
procgenericgateway_tclMainApp::poGetSpmDataHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::m_poSpmClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poSpmClientHandler);
    return m_poSpmClientHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetSensorClientHandler()
***************************************************************************/
fc_gateway_tcl_sensorclienthandler*
procgenericgateway_tclMainApp::poGetSensorClientHandler()
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetSensorClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poSensorclienthandler);
    return m_poSensorclienthandler;
}

FC_Gateway_EcoScoreClientHandler*
procgenericgateway_tclMainApp::poGetEcoScoreClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetEcoScoreClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poFC_Gateway_EcoScoreClientHandler);
    return m_poFC_Gateway_EcoScoreClientHandler;
}

/***************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::poGetConfigurationClientHandler()
***************************************************************************/
FC_Gateway_ConfigurationClientHandler* 
procgenericgateway_tclMainApp::poGetConfigurationClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetConfigurationClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poFC_Gateway_ConfigurationClientHandler);
    return m_poFC_Gateway_ConfigurationClientHandler;
}

#if ENABLE_CSM_IN_GATEWAY
FC_Gateway_Vehicle_CSMClientHandler*
procgenericgateway_tclMainApp::poGetVehicleDataCSMClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::"\
                "poGetVehicleDataCSMClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poVehicleCSMClientHandler);
    return m_poVehicleCSMClientHandler;
}
#endif //ENABLE_CSM_IN_GATEWAY

#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#if ENABLE_CSM_IN_GATEWAY
FC_Gateway_VehicleDataClientHandler*
procgenericgateway_tclMainApp::poGetVehicleDataClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::"\
                "poGetVehicleDataClientHandler"));
    NORMAL_M_ASSERT(NULL != m_poVehicleDataClientHandler);
    return m_poVehicleDataClientHandler;
}
#endif //ENABLE_CSM_IN_GATEWAY
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

cea_FC_Gateway_TunerClientHandler*
procgenericgateway_tclMainApp::poGetCEATunerClientHandler(tVoid)
{
    DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                "procgenericgateway_tclMainApp::poGetCEATunerClientHandler"));
    NORMAL_M_ASSERT(NULL != m_pocea_TunerClientHandler);
    return m_pocea_TunerClientHandler;
}
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_BUILD_AS_PROCESS

#define EVENT_SHUTDOWN_NAME "SHUTDOWN_FC_GATEWAY"
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
extern "C" OSAL_DECL tS32 vStartApp(tS32 cPar, tString aPar[])
{
    UNUSED(cPar);
    UNUSED(aPar);
    t_Bool bRetVal = OSAL_OK;
    OSAL_tEventHandle  hEvShutdown = 0;
    OSAL_tEventMask    hEvRequest  = 0x00000001;

    DLT_REGISTER_APP(DLT_APPID_IDC_GATEWAY,"DLT Logging in gateway");
    DLT_REGISTER_CONTEXT(AGW_framework,"GWFW","Gateway framework "
                         "context for DLT Logging");
    //ET_TRACE_OPEN;

    scd_init();

    if (OSAL_s32EventCreate(EVENT_SHUTDOWN_NAME, &hEvShutdown) == OSAL_ERROR)
    {
        DLT_LOG(AGW_framework,DLT_LOG_ERROR,
                DLT_STRING("procgenericgateway_tclMainApp:"
                           " Creation of SPM shutdown event failed!!!"));
        NORMAL_M_ASSERT_ALWAYS();
    }
    DLT_LOG(AGW_framework,DLT_LOG_ERROR,
            DLT_STRING("procgenericgateway_tclMainApp::"
                       "vStartApp() OSAL_s32EventCreate"));

    OSAL_tProcessID pId = OSAL_ProcessWhoAmI();
    DLT_LOG(AGW_framework, DLT_LOG_INFO,DLT_STRING("FC_GATEWAY PID:"),
            DLT_INT(pId));

#ifdef VARIANT_S_FTR_ENABLE_PROCSTART_DATAPOOL
    DP_vCreateDatapool();
#endif

    procgenericgateway_tclMainApp
            *pGatewayApp = new procgenericgateway_tclMainApp;

    if (pGatewayApp != OSAL_NULL)
    {
        /* For now, we shall use the ID of generic proxy to talk with CCX. */
        if (!pGatewayApp->bInitInstance(0, CCA_C_U16_APP_GENERIC_PROXY))
        {
            DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
                        "procgenericgateway_tclMainApp: bInitInstance failed"));
        }
        else
        {
            DLT_LOG(AGW_framework,DLT_LOG_INFO,DLT_STRING(
                        "procgenericgateway_tclMainApp:bInitInstance success"));
        }
    }

    loop = g_main_loop_new (NULL, FALSE);
    g_main_loop_run (loop);

    // Wait for Shutdown-Signal
    if (OSAL_s32EventWait(hEvShutdown, hEvRequest, OSAL_EN_EVENTMASK_OR,
                          OSAL_C_TIMEOUT_FOREVER, &hEvRequest)!= OSAL_OK)
    {
        DLT_LOG(AGW_framework,DLT_LOG_ERROR,DLT_STRING(
                    "procgenericgateway_tclMainApp(): Failed to wait for event!"));
    }
    if (pGatewayApp != OSAL_NULL) //leak here.
    {
        pGatewayApp->vDeinitInstance();
        delete pGatewayApp;
        pGatewayApp = NULL;
    }
    DLT_LOG(AGW_framework,DLT_LOG_INFO,
            DLT_STRING("procgenericgateway_tclMainApp: Exiting..."));
    OSAL_s32EventClose(hEvShutdown);
    OSAL_s32EventDelete(EVENT_SHUTDOWN_NAME);
    return bRetVal;
}


#endif
