/*!
*******************************************************************************
* \file               procgenericgateway_tclMainApp.h
*******************************************************************************
\verbatim
PROJECT:        G3G
SW-COMPONENT:   Gateway for Generic Internet Component.
DESCRIPTION:    CCA Application PROCGENERICGATEWAY.
COPYRIGHT:      &copy; RBEI
HISTORY:
Date       | Author                   | Modifications
23.11.2015 | rhk6kor                   | Initial Version

\endverbatim
******************************************************************************/

#ifndef _PROCGENERICGATEWAY_TCLMAINAPP_H_
#define _PROCGENERICGATEWAY_TCLMAINAPP_H_

/******************************************************************************
| includes:
|----------------------------------------------------------------------------*/
#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"
#include "midw_fi_if.h"
#include "BaseTypes.h"

#include "asf/core/ApplicationLauncher.h"
#include <signal.h>


#if ENABLE_CSM_IN_GATEWAY
#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#include "cea_FC_Gateway_VehicleDataClientHandler.h"
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#endif //ENABLE_CSM_IN_GATEWAY

/******************************************************************************
| defines
|----------------------------------------------------------------------------*/
#define RELEASE_MEM_OSAL(VAR)      \
    if (OSAL_NULL != VAR)           \
{                               \
    OSAL_DELETE VAR;             \
    VAR = OSAL_NULL;             \
    }

/*****************************************************************************/
/*                                                                           */
/* DEFINES                                                                   */
/*                                                                           */
/*****************************************************************************/

#define VARIANT_S_FTR_ENABLE_TRACE_CMD_DIRECT

#ifdef SYSTEM_S_USE_BPSTL
extern tBool __DELETEME__;
#endif
/*!
* \class definition
*/
class ahl_tclBaseOneThreadApp;
class procgenericgateway_tclService;
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
class fc_gateway_tclAudioRouteHandler;
class fc_gateway_tcl_phoneclienthandler;
class FC_Gateway_TTSClientHandler;
class fc_gateway_tcl_messageclienthandler;
class FC_Gateway_MediaPlayerClientHandler;
class fc_gateway_tcl_phonebookclienthandler;
class fc_gateway_tcl_bluetoothclienthandler;

class FC_Gateway_TunerMasterClientHandler;
class FC_Gateway_TunerDABClientHandler;
class FC_Gateway_TunerClientHandler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
class FC_Gateway_ConfigurationClientHandler;
class fc_gateway_tcl_sensorclienthandler;
class FC_Gateway_SpmClientHandler;
class FC_Gateway_EcoScoreClientHandler;
class FC_Gateway_cfcVehicleClientHandler;
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#if ENABLE_CSM_IN_GATEWAY

#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
class FC_Gateway_VehicleDataClientHandler;
#endif // VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#if VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
class FC_Gateway_Vehicle_CSMClientHandler;
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#endif //ENABLE_CSM_IN_GATEWAY


#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
class cea_FC_Gateway_TunerClientHandler;
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#define UNUSED(x) (void)(x)

class procgenericgateway_tclMainApp : public ahl_tclBaseOneThreadApp
{
public:

/******************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::procgenericgateway_tclMainApp()
*******************************************************************************
* \fn     procgenericgateway_tclMainApp::procgenericgateway_tclMainApp()
* \brief  Constructor.
*         Component object is created as Singleton in method theServer().
* \param   None.
* \retval  None.
******************************************************************************/
    procgenericgateway_tclMainApp(tVoid);

/******************************************************************************
** FUNCTION   : procgenericgateway_tclMainApp::~procgenericgateway_tclMainApp()
*******************************************************************************
* \fn      procgenericgateway_tclMainApp::~procgenericgateway_tclMainApp()
* \brief    Destructor.
         Invalidate static self reference.
* \param    None.
* \retval   None.
******************************************************************************/
    virtual ~procgenericgateway_tclMainApp(tVoid);

/******************************************************************************
** FUNCTION   :tBool procgenericgateway_tclMainApp::bOnInit() 
*******************************************************************************
* \fn       tBool procgenericgateway_tclMainApp::bOnInit()
* \brief    This function is called by the CCA framework before starting any
*           CCA message related communication action. As default this
*           function always returns TRUE. The user has to implement all his
*           local application initialization (create client and service
*           handler, create worker threads, allocate application memory,...).
*           If returns TRUE, initialization was successfully performed
*           and framework will register application, else, a reset of the
*           system is forced immediately.
*           This function is the counterpart of vOnApplicationClose().
* \param    None.
* \retval   TRUE  = Application successfully initialized.
*           FALSE = Application NOT successfully initialized.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
******************************************************************************/
    virtual tBool bOnInit(tVoid);

/******************************************************************************
** FUNCTION   :tVoid procgenericgateway_tclMainApp::vOnApplicationClose()
*******************************************************************************
* \fn       tVoid procgenericgateway_tclMainApp::vOnApplicationClose()*/
    /*!
* \brief    This function is called by the CCA framework to indicate the
*           imminent shutdown of the application. The user has to implement
*           the de-initialization of all his local application data (destroy
*           client and service handler, destroy worker threads, free
*           application memory, ... ). After this function call the
*           destructor of this application will be called.
*           This function is the counterpart of bOnInit().
* \param    None.
* \retval   None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
******************************************************************************/
    virtual tVoid vOnApplicationClose(tVoid);

/******************************************************************************
** FUNCTION   :tVoid procgenericgateway_tclMainApp::vOnLoadSettings()
*******************************************************************************
* \fn        tVoid procgenericgateway_tclMainApp::vOnLoadSettings()
* \brief     This function is called by the CCA framework to trigger the
            loading of last mode settings. The user has to load the
            previously stored last mode settings from persistent memory.
* \param     None.
* \retval    None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
******************************************************************************/
    virtual tVoid vOnLoadSettings(tVoid);

/******************************************************************************
** FUNCTION   : tVoid procgenericgateway_tclMainApp::   vOnSaveSettings()
*******************************************************************************
* \fn        tVoid procgenericgateway_tclMainApp::   vOnSaveSettings()
* \brief     This function is called by the CCA framework to trigger the
*            storage of last mode settings. The user has to store the last
*            mode settings to persistent memory.
* \param     None.
* \retval    None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
******************************************************************************/
    virtual tVoid vOnSaveSettings(tVoid);

/******************************************************************************
** FUNCTION   : tVoid procgenericgateway_tclMainApp::vOnTimer(tU16 u16TimerId)
*******************************************************************************
* \fn        tVoid procgenericgateway_tclMainApp::vOnTimer(tU16 u16TimerId)
* \brief     This function is called by the CCA framework on the expiration
*            of a previously started timer via function bStartTimer(). The
*            expired timer is forwarded to the respective service or
*            client handlers via a call of vProcessTimer().
*            The function is called from this applications context and
*            therefore no interthread programming rules must be considered
*            and the application methods and/or member variables can be
*            accessed without using the static self reference
*            'm_poMainAppInstance'.
* \param     [IN] u16TimerId = Identifier of the expired timer.
* \retval     None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
******************************************************************************/
    virtual tVoid vOnTimer(tU16 nTimerId);

/******************************************************************************
* FUNCTION: tVoid procgenericgateway_tclMainApp::vOnLoopback(tU16 u16ServiceID,
                                                 amt_tclServiceData* poMessage)
*******************************************************************************
* \fn       tVoid procgenericgateway_tclMainApp::vOnLoopback(tU16 u16ServiceID,
                                                 amt_tclServiceData* poMessage)
* \brief    This function is called by the CCA framework if a message was
*           sent from one if these applications services or from a
*           callback-handler of this application (so called self or loopback
*           messages). The message can be forwarded to the respective service
*           via a call of vOnLoopbackService(). If there is no service
*           registered for this message then the user has the option to
*           directly evaluate the message in the default block of this
*           methods switch-clause.
* \param    [IN] u16ServiceID = Identifier of the service from where the
*           message was sent.
*           [IN] poMessage = Message object.
* \retval   None.
*******************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
******************************************************************************/

    using ahl_tclBaseOneThreadApp::vOnLoopback;
    tVoid vOnLoopback(tU16 u16ServiceID, amt_tclBaseMessage* poMessage)
    {
        UNUSED(u16ServiceID);
        UNUSED(poMessage);
    }

/*************************************************************************
*
* FUNCTION: tVoid ahl_tclBaseOneThreadApp::vOnNewAppState (tU32 u32OldAppState, tU32 u32AppState)
*
* DESCRIPTION: * is call from SPM to inform this application about new power states
*              * changes the state of the application
*              * sends ServiceAvailability state to all notified Objects
*              * changes state of downloadservice(-object)
*
* PARAMETER: tU32 u32OldAppState (actual state),
*            tU32 u32AppState (state to change to)
*
* RETURNVALUE: void
*
**************************************************************************/
    virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);

/***************************************************************************
** FUNCTION   : t_Void procgenericgateway_tclMainApp::vSignalHandler()
***************************************************************************/
    /* !
* \fn       t_Void vSignalHandler(t_S32 s32SigNum, siginfo_t *pSiginfo,
                                  t_Void *pContext)
* \brief    Method to Handle the signals sent to SPI Process/ threads created 
            by our process
* \param    s32SigNum : [IN] Signal ID/Number
* \param    pSiginfo  : [IN] Siginfo structure, which provides the details of 
                             the signal
* \param    pContext  : [IN] context ptr
* \retval   None.
**************************************************************************/
    static t_Void vSignalHandler(t_S32 s32SigNum, siginfo_t *pSiginfo,
                                 t_Void *pContext);


    static procgenericgateway_tclMainApp* poGetInstance(tVoid);



#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
/******************************************************************************
** FUNCTION   : poGetcfcVehicleDataHandler()
*******************************************************************************
* \brief    Get instance of Vehicle data client handler
* \param    None.
* \retval   FC_Gateway_cfcVehicleClientHandler (client handler instance)
******************************************************************************/	
    static FC_Gateway_cfcVehicleClientHandler* poGetcfcVehicleDataHandler(tVoid);
 /******************************************************************************
** FUNCTION   : poGetSpmDataHandler()
*******************************************************************************
* \brief    Get instance of SPM client handler
* \param    None.
* \retval   FC_Gateway_SpmClientHandler (client handler instance)
******************************************************************************/	
    static FC_Gateway_SpmClientHandler* poGetSpmDataHandler(tVoid);

    /******************************************************************************
** FUNCTION   : poGetSensorClientHandler()
*******************************************************************************
* \brief    Get instance of Sensor client handler
* \param    None.
* \retval   fc_gateway_tcl_sensorclienthandler (client handler instance)
******************************************************************************/
    static fc_gateway_tcl_sensorclienthandler* poGetSensorClientHandler(tVoid);

#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI


#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    /******************************************************************************
    ** FUNCTION   : poGetMessageClientHandler()
    *******************************************************************************
    * \brief    Get instance of Message client handler
    * \param    None.
    * \retval   fc_gateway_tcl_messageclienthandler (client handler instance)
    ******************************************************************************/
    static fc_gateway_tcl_messageclienthandler*
        poGetMessageClientHandler(tVoid);

    /******************************************************************************
    ** FUNCTION   : poGetMediaPlayerClientHandler()
    *******************************************************************************
    * \brief    Get instance of MediaPlayer client handler
    * \param    None.
    * \retval   FC_Gateway_MediaPlayerClientHandler (client handler instance)
    ******************************************************************************/
        static FC_Gateway_MediaPlayerClientHandler*
        poGetMediaPlayerClientHandler(tVoid);

    /******************************************************************************
    ** FUNCTION   : poGetPhoneBookClientHandler()
    *******************************************************************************
    * \brief    Get instance of Phone book client handler
    * \param    None.
    * \retval   fc_gateway_tcl_phonebookclienthandler (client handler instance)
    ******************************************************************************/
        static fc_gateway_tcl_phonebookclienthandler*
        poGetPhoneBookClientHandler(tVoid);

    /******************************************************************************
    ** FUNCTION   : poGetBluetoothClientHandler()
    *******************************************************************************
    * \brief    Get instance of Bluetooth client handler
    * \param    None.
    * \retval   fc_gateway_tcl_bluetoothclienthandler (client handler instance)
    ******************************************************************************/
        static fc_gateway_tcl_bluetoothclienthandler*
        poGetBluetoothClientHandler(tVoid);

/******************************************************************************
** FUNCTION   : poGetAudioRouteHandler()
*******************************************************************************
* \brief    Get instance of Audio client handler
* \param    None.
* \retval   fc_gateway_tclAudioRouteHandler (client handler instance)
******************************************************************************/
static fc_gateway_tclAudioRouteHandler* poGetAudioRouteHandler(tVoid);

/******************************************************************************
** FUNCTION   : poGetPhoneClientHandler()
*******************************************************************************
* \brief    Get instance of Phone client handler
* \param    None.
* \retval   fc_gateway_tcl_phoneclienthandler (client handler instance)
******************************************************************************/
    static fc_gateway_tcl_phoneclienthandler* poGetPhoneClientHandler(tVoid);

/******************************************************************************
** FUNCTION   : poGetTTSClientHandler()
*******************************************************************************
* \brief    Get instance of TextToSpeech client handler
* \param    None.
* \retval   FC_Gateway_TTSClientHandler (client handler instance)
******************************************************************************/
    static FC_Gateway_TTSClientHandler* poGetTTSClientHandler(tVoid);





/******************************************************************************
** FUNCTION   : poGetTunerClientHandler()
*******************************************************************************
* \brief    Get instance of Tuner client handler
* \param    None.
* \retval   FC_Gateway_TunerClientHandler (client handler instance)
******************************************************************************/
    static FC_Gateway_TunerClientHandler* poGetTunerClientHandler(tVoid);
	
/******************************************************************************
 ** FUNCTION   : poGetTunerMasterClientHandler()
 *******************************************************************************
 * \brief    Get instance of Tuner Master client handler
 * \param    None.
 * \retval   FC_Gateway_TunerMasterClientHandler (client handler instance)
 ******************************************************************************/
    static FC_Gateway_TunerMasterClientHandler*
    poGetTunerMasterClientHandler(tVoid);

/******************************************************************************
 ** FUNCTION   : poGetTunerDABClientHandler()
 *******************************************************************************
 * \brief    Get instance of DAB Tuner client handler
 * \param    None.
 * \retval   FC_Gateway_TunerDABClientHandler (client handler instance)
 ******************************************************************************/
    static FC_Gateway_TunerDABClientHandler* poGetTunerDABClientHandler(tVoid);
#endif

#if ENABLE_CSM_IN_GATEWAY	
#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC	
/******************************************************************************
** FUNCTION   : poGetVehicleDataClientHandler()
*******************************************************************************
* \brief    Get instance of Vehicle Data client handler
* \param    None.
* \retval   FC_Gateway_VehicleDataClientHandler (client handler instance)
******************************************************************************/
    static FC_Gateway_VehicleDataClientHandler*
    poGetVehicleDataClientHandler(tVoid);
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
#if VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
    /***************************************************************************
    ** FUNCTION   : poGetVehicleDataCSMClientHandler()
    ****************************************************************************
    * \brief    Get instance of Vehicle Data client handler CCA client handler
    * \param    None.
    * \retval   FC_Gateway_Vehicle_CSMClientHandler (client handler instance)
    ***************************************************************************/
    static FC_Gateway_Vehicle_CSMClientHandler*
    poGetVehicleDataCSMClientHandler(tVoid);
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#endif //ENABLE_CSM_IN_GATEWAY

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
/******************************************************************************
** FUNCTION   : poGetCEATunerClientHandler()
*******************************************************************************
* \brief    Get instance of Tuner client handler
* \param    None.
* \retval   cea_FC_Gateway_TunerClientHandler (client handler instance)
******************************************************************************/
    static cea_FC_Gateway_TunerClientHandler* poGetCEATunerClientHandler(tVoid);
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI	
/******************************************************************************
** FUNCTION   : poGetConfigurationClientHandler()
*******************************************************************************
* \brief    Get instance of car configuaration client handler
* \param    None.
* \retval   FC_Gateway_ConfigurationClientHandler (client handler instance)
******************************************************************************/
    static FC_Gateway_ConfigurationClientHandler*
    poGetConfigurationClientHandler(tVoid);

/******************************************************************************
** FUNCTION   : poGetEcoScoreClientHandler()
*******************************************************************************
* \brief    Get instance of ecoscore client handler
* \param    None.
* \retval   FC_Gateway_EcoScoreClientHandler (client handler instance)
******************************************************************************/
    static FC_Gateway_EcoScoreClientHandler*  poGetEcoScoreClientHandler(tVoid);
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

protected:

/***************************************************************************
* FUNCTION: tVoid procgenericgateway_tclMainApp::vHandleTraceCmd
***************************************************************************/
    /*!
* \brief   Trace Command interface handler.
* \param   [cpu8Buffer] (->I) Pointer to the Trace command buffer
* \retval  NONE
**************************************************************************/
    static tVoid vHandleTraceCmd(tU8 const* const cpu8Buffer);

private:

    static tVoid vHandleTraceMessage(const tUChar* puchData);
    
	 tBool bCreateClientHandlers();
	 
     void vDeleteClientHandlers();

/**************************************************************************
* Assignment Operator, will not be implemented.
* Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
* 'procgenericgateway_tclMainApp' which has no assignment operator.
* NOTE:
* This is a technique to disable the assignment operator for this class.
* So if an attempt for the assignment is made linker complains.
**************************************************************************/
    procgenericgateway_tclMainApp&
    operator=(const procgenericgateway_tclMainApp
              &oprocgenericgateway_tclMainApp);

    /**************************************************************************
//!Copy Constructor, will not be implemented.
//!Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
//!'procgenericgateway_tclMainApp' which has no copy constructor.
//!NOTE:
//! This is a technique to disable the copy constructor for this class.
//!So if an attempt for the copy constructor is made linker complains.
**************************************************************************/
    procgenericgateway_tclMainApp(const procgenericgateway_tclMainApp
                                  &oprocgenericgateway_tclMainApp);

/**************************************************************************
* TTFIS callback register mechanism.
**************************************************************************/

    /*!
* Pointer to Trace Command handler.
*/
    //TraceStreamable* m_poTraceStreamer;

    /*!
* spi_tclService member variable
*/
    procgenericgateway_tclService* m_poService;

public:
    tVoid vTracePlugIn(tVoid);
    tVoid vTraceUnplug(tVoid);

    static tVoid vHandleTraceMsg(const tUChar* puchData);

    static procgenericgateway_tclMainApp* m_poMainAppInstance;
#ifndef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    static fc_gateway_tclAudioRouteHandler* m_poAudioRouteHandler;


    static fc_gateway_tcl_phoneclienthandler* m_poPhoneClientHandler;

    static FC_Gateway_TTSClientHandler* m_poTTSClientHandler;

    static FC_Gateway_MediaPlayerClientHandler* m_poMediaPlayerClientHandler;

    static fc_gateway_tcl_phonebookclienthandler* m_poPhoneBookClientHandler;

    static fc_gateway_tcl_bluetoothclienthandler*
    m_pofc_gateway_tcl_bluetoothclienthandler;

    static fc_gateway_tcl_messageclienthandler* m_poMessageClientHandler;

    static FC_Gateway_TunerMasterClientHandler* m_poTunerMasterClientHandler;

    static FC_Gateway_TunerDABClientHandler* m_poTunerDABClientHandler;

    static FC_Gateway_TunerClientHandler* m_poTunerClientHandler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC
    static cea_FC_Gateway_TunerClientHandler* m_pocea_TunerClientHandler;
#endif //#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
    static fc_gateway_tcl_sensorclienthandler* m_poSensorclienthandler;

    static FC_Gateway_SpmClientHandler* m_poFC_Gateway_SpmClientHandler;

    static FC_Gateway_EcoScoreClientHandler*
    m_poFC_Gateway_EcoScoreClientHandler;

    static FC_Gateway_cfcVehicleClientHandler*
    m_poFC_Gateway_cfcVehicleDataClientHandler;

    static FC_Gateway_SpmClientHandler* m_poSpmClientHandler;
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#if ENABLE_CSM_IN_GATEWAY

#if VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC   
    static FC_Gateway_VehicleDataClientHandler* m_poVehicleDataClientHandler;
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_PSARCC

#if VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI
    static FC_Gateway_Vehicle_CSMClientHandler* m_poVehicleCSMClientHandler;
#endif //VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI

#endif //ENABLE_CSM_IN_GATEWAY


#ifdef VARIANT_S_FTR_ENABLE_FEAT_GW_RNAIVI	
    static FC_Gateway_ConfigurationClientHandler*
    m_poFC_Gateway_ConfigurationClientHandler;
#endif

    ::asf::core::ApplicationLauncher* m_poLauncher;

}; 

#endif /* _PROCGENERICGATEWAY_TCLMAINAPP_H_*/




