/******************************************************************
*FILE: ap-tuner-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the error enums related to
*             com.bosch.AutomotiveProxy.Tuner interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_TUNER_ERROR_H
#define AP_TUNER_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_TUNER_ERROR:
 *
 * Error domain for #APTunerError.
 *
 * Since: 0.1.0
 */
#define AP_TUNER_ERROR ap_tuner_error_quark ()
GQuark ap_tuner_error_quark (void);

/**
 * APTunerError:
 * @AP_TUNER_ERROR_UNKOWN: Unrecognised error.
 * @AP_TUNER_ERROR_BAD_PARAMS: Invalid input parameters.
 * @AP_TUNER_ERROR_FUNC_NOT_SUPPORTED: The function is not supported
                                       for given band.
 * @AP_TUNER_ERROR_INTERNAL_ENGINE_ERR: Internal error in tuner component.
 *
 * Errors from operations on tuner control and tuner info manager.
 *
 * Since: 0.1.0
 */

typedef enum
{
    AP_TUNER_ERROR_UNKOWN,
    AP_TUNER_ERROR_BAD_PARAMS,
    AP_TUNER_ERROR_FUNC_NOT_SUPPORTED,
    AP_TUNER_ERROR_INTERNAL_ENGINE_ERR
} APTunerError;

G_END_DECLS

#endif /* !AP_TUNER_ERROR_H */
