/******************************************************************
*FILE: ap-tuner-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for Tuner.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-tuner-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.TunerError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_TUNER_ERROR_UNKOWN,
        ERROR_PREFIX "Unknown"
    },
    {
        AP_TUNER_ERROR_BAD_PARAMS,
        ERROR_PREFIX "InvalidParameterValue"
    },
    {
        AP_TUNER_ERROR_FUNC_NOT_SUPPORTED,
        ERROR_PREFIX "FunctionNotSupported"
    },
    {
        AP_TUNER_ERROR_INTERNAL_ENGINE_ERR,
        ERROR_PREFIX "InternalEngineError"
    },
};


GQuark
ap_tuner_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-tuner-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
