/******************************************************************
*FILE: ap-tuner-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to
*             com.bosch.AutomotiveProxy.Tuner interface.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_TUNER_ENUMS__
#define __AP_TUNER_ENUMS__

/**
 * ApTunerDirection:
 * @AP_TUNER_DIRECTION_DOWN: Seek or tune in decremental direction.
 * @AP_TUNER_DIRECTION_UP:  Seek or tune in incremental direction.
 *
 * Represents the direction of seek or tune.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_TUNER_DIRECTION_DOWN,
  AP_TUNER_DIRECTION_UP
} ApTunerDirection;


/**
 * ApTunerBand:
 * @AP_TUNER_BAND_AM:  Represents AM tuner band  
 * @AP_TUNER_BAND_FM:  Represents FM tuner band
 * @AP_TUNER_BAND_SW:  Represents SW tuner band
 * @AP_TUNER_BAND_LW:  Represents LW tuner band
 * @AP_TUNER_BAND_FM2: Represents FM2 tuner band
 * @AP_TUNER_BAND_DRM: Represents DRM tuner band
 * @AP_TUNER_BAND_DAB: Represents DAB tuner band
 *
 * Represents the tuner band.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_TUNER_BAND_AM,
  AP_TUNER_BAND_FM,
  AP_TUNER_BAND_SW,
  AP_TUNER_BAND_LW,
  AP_TUNER_BAND_FM2,
  AP_TUNER_BAND_DRM,
  AP_TUNER_BAND_DAB
} ApTunerBand;


/**
 * ApTunerSearchStationStatus:
 * @AP_TUNER_SEARCH_REQ_COMPLETED: Search available stations operation completed. 
                                   This state doesnot mean that search is successful.
 * @AP_TUNER_SEARCH_REQ_FAIL: Search available stations request failed.
 * @AP_TUNER_SEARCH_REQ_INPROGRESS: Search available stations is in progress.
 * @AP_TUNER_SEARCH_REQ_NOT_AVAILABLE: Search functionality not available.
 * @AP_TUNER_SEARCH_REQ_CANCELLED: Search request is cancelled.
 *
 * Represents the status of search available stations or cancel search.
 * 
 * Since: 0.1.0
 */
typedef enum
{
  AP_TUNER_SEARCH_REQ_COMPLETED,
  AP_TUNER_SEARCH_REQ_FAIL,
  AP_TUNER_SEARCH_REQ_INPROGRESS,
  AP_TUNER_SEARCH_REQ_NOT_AVAILABLE,
  AP_TUNER_SEARCH_REQ_CANCELLED
} ApTunerSearchStationStatus;

/**
 * ApTunerSeekStatus:
 * @AP_TUNER_SEEK_REQ_COMPLETED: Seek station/ensemble operation is completed.
                                 This state doesnot mean that seek is successful.
 * @AP_TUNER_SEEK_REQ_FAIL: Seek station request failed.
 * @AP_TUNER_SEEK_REQ_INPROGRESS: Seek station is in progress.
 * @AP_TUNER_SEEK_REQ_NOT_AVAILABLE: Seek functionality not available.
 * @AP_TUNER_SEEK_REQ_CANCELLED: Seek request is cancelled.
 *
 * Represents the status of seek available station or cancel search.
 * 
 * Since: 0.1.0
 */
typedef enum
{
  AP_TUNER_SEEK_REQ_COMPLETED,
  AP_TUNER_SEEK_REQ_FAIL,
  AP_TUNER_SEEK_REQ_INPROGRESS,
  AP_TUNER_SEEK_REQ_NOT_AVAILABLE,
  AP_TUNER_SEEK_REQ_CANCELLED
} ApTunerSeekStatus;

/**
 * ApTunerProgramType:
 *
 * Represents pre-defined programme types.  
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_TUNER_PT_UNDEFINED,
  AP_TUNER_PT_NEWS,
  AP_TUNER_PT_CURRENTAFFAIRS,
  AP_TUNER_PT_INFORMATION,
  AP_TUNER_PT_SPORT,
  AP_TUNER_PT_EDUCATION,
  AP_TUNER_PT_DRAMA,
  AP_TUNER_PT_CULTURE,
  AP_TUNER_PT_SCIENCE,
  AP_TUNER_PT_VARIED,
  AP_TUNER_PT_POPMUSIC,
  AP_TUNER_PT_ROCKMUSIC,
  AP_TUNER_PT_EASYLISTENING,
  AP_TUNER_PT_LIGHTCLASSICAL,
  AP_TUNER_PT_SERIOUSCLASSICAL,
  AP_TUNER_PT_OTHERMUSIC,
  AP_TUNER_PT_WEATHER,
  AP_TUNER_PT_FINANCE,
  AP_TUNER_PT_CHILDRENSPROGRAMMES,
  AP_TUNER_PT_SOCIALAFFAIRS,
  AP_TUNER_PT_RELIGION,
  AP_TUNER_PT_PHONEIN,
  AP_TUNER_PT_TRAVEL,
  AP_TUNER_PT_LEISURE,
  AP_TUNER_PT_JAZZMUSIC,
  AP_TUNER_PT_COUNTRYMUSIC,
  AP_TUNER_PT_NATIONALMUSIC,
  AP_TUNER_PT_OLDIESMUSIC,
  AP_TUNER_PT_FOLKMUSIC,
  AP_TUNER_PT_DOCUMENTARY,
  AP_TUNER_PT_ALARMTEST,
  AP_TUNER_PT_ALARM,TALK,
  AP_TUNER_PT_CLASSICROCK,
  AP_TUNER_PT_ADULTHITS,
  AP_TUNER_PT_SOFTROCK,
  AP_TUNER_PT_TOP40,
  AP_TUNER_PT_SOFT,
  AP_TUNER_PT_NOSTALGIA,
  AP_TUNER_PT_CLASSICAL,
  AP_TUNER_PT_RHYTHMANDBLUES,
  AP_TUNER_PT_SOFTRHYTHMANDBLUES,
  AP_TUNER_PT_LANGUAGE,
  AP_TUNER_PT_RELIGIOUSMUSIC,
  AP_TUNER_PT_RELIGIOUSTALK,
  AP_TUNER_PT_PERSONALITY,
  AP_TUNER_PT_PUBLIC,
  AP_TUNER_PT_COLLEGE
} ApTunerProgramType;

#endif /* !__AP_TUNER_ENUMS__ */
