/******************************************************************
*FILE: ap-tts-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for tts manager.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-tts-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.TtsError."

static const GDBusErrorEntry error_entries[] =
{
    {
   		AP_TTS_ERROR_TTS_ENGINE_NOT_STARTED,
        ERROR_PREFIX "TtsEngineNotStarted"
    },
    {
   		AP_TTS_ERROR_TEXT_LENGTH_EXCEEDED,
        ERROR_PREFIX "TextLengthExceeded"
    },
    {
   		AP_TTS_ERROR_SPEECH_PLAY_FAILED,
        ERROR_PREFIX "SpeechPlayFailed"
    },
    {
   		AP_TTS_ERROR_OUT_OF_MEMORY,
        ERROR_PREFIX "OutOfMemory"
    },
    {
   		AP_TTS_ERROR_INVALID_PARAMETERS,
        ERROR_PREFIX "InvalidParameters"
    },
    {
   		AP_TTS_ERROR_UNKNOWN,
        ERROR_PREFIX "Unknown"
    },
	{
   		 AP_TTS_PREFERENCES_NOT_SET,
        ERROR_PREFIX "PreferencesNotSet"
    },
};

G_STATIC_ASSERT (G_N_ELEMENTS (error_entries) == AP_TTS_MANAGER_ERRORS);

GQuark
ap_tts_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-tts-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
