/******************************************************************
*FILE: ap-telephony-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for telephony manager.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-telephony-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.TelephonyError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_TELEPHONY_ERROR_UNKNOWN_SOURCE,
        ERROR_PREFIX "UnknownSource"
    },
    {
        AP_TELEPHONY_ERROR_UNKNOWN_ATTRIBUTE,
        ERROR_PREFIX "UnknownAttribute"
    },
    {
        AP_TELEPHONY_ERROR_INVALID_ATTRIBUTE_VALUE,
        ERROR_PREFIX "InvalidAttributeValue"
    },
    {
        AP_TELEPHONY_ERROR_ATTRIBUTE_UNAVAILABLE,
        ERROR_PREFIX "AttributeUnAvailable"
    },
    {
        AP_TELEPHONY_ERROR_ILLEGAL_BEHAVIOUR,
        ERROR_PREFIX "IllegalBehaviour"
    },
    {
        AP_TELEPHONY_ERROR_INVALID_HANDLE,
        ERROR_PREFIX "InValidHandle"
    },
    {
        AP_TELEPHONY_ERROR_BAD_CALL_INSTANCE,
        ERROR_PREFIX "BadCallInstance"
    },
    {
        AP_TELEPHONY_ERROR_INTERNAL,
        ERROR_PREFIX "InternalError"
    },
};

G_STATIC_ASSERT (G_N_ELEMENTS (error_entries) == AP_TELEPHONY_N_MANAGER_ERRORS);

GQuark
ap_telephony_error_quark (void)
{
    static volatile gsize id = 0;

    g_dbus_error_register_error_domain ("ap-telephony-error-quark", &id,
                                        error_entries,
                                        G_N_ELEMENTS (error_entries));

    return (GQuark) id;
}
