/******************************************************************
*FILE: ap-media-player-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: MediaPlayer error enums
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_MEDIA_PLAYER_ERROR_H
#define AP_MEDIA_PLAYER_ERROR_H

#include <glib.h>
#include "ap-media-player-enums.h"

G_BEGIN_DECLS

/**
 * AP_MPLAYER_ERROR:
 *
 * Error domain for #ApMediaError.
 *
 * Since: 1.0
 */
#define AP_MPLAYER_ERROR ap_mplayer_error_quark ()
GQuark ap_mplayer_error_quark (void);

/**
 * ApMplayerError:
 * @AP_MPLAYER_ERROR_UNKNOWN: Unrecongnised error.
 * @AP_MPLAYER_ERROR_BAD_PARAMS: Invalid input parameters.
 * @AP_MPLAYER_ERROR_FUNC_NOT_SUPPORTED: The function is not supported.
 * @AP_MPLAYER_ERROR_INVALID_HANDLE: The given handle ID is invalid
 * @AP_MPLAYER_ERROR_INTERNAL_ENGINE_ERR: Internal error in media player
 * component.
 * @AP_MPLAYER_ERROR_NO_METADATA_AVAILABLE: Metadata not available for the track
 *
 * Errors from operations on media player.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_ERROR_UNKNOWN,
  AP_MPLAYER_ERROR_BAD_PARAMS,
  AP_MPLAYER_ERROR_INVALID_HANDLE,
  AP_MPLAYER_ERROR_FUNC_NOT_SUPPORTED,
  AP_MPLAYER_ERROR_INTERNAL_ENGINE_ERR,
  AP_MPLAYER_ERROR_NO_METADATA_AVAILABLE
} ApMplayerError;

G_END_DECLS

#endif /* !AP_MEDIA_PLAYER_ERROR_H */
