/******************************************************************
*FILE: ap-media-player-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for Tuner.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-media-player-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.MPlayerError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_MPLAYER_ERROR_UNKNOWN,
        ERROR_PREFIX "Unknown"
    },
    {
        AP_MPLAYER_ERROR_BAD_PARAMS,
        ERROR_PREFIX "InvalidParameterValue"
    },
    {
        AP_MPLAYER_ERROR_FUNC_NOT_SUPPORTED,
        ERROR_PREFIX "FunctionNotSupported"
    },
    {
        AP_MPLAYER_ERROR_INTERNAL_ENGINE_ERR,
        ERROR_PREFIX "InternalEngineError"
    },
    {
        AP_MPLAYER_ERROR_INVALID_HANDLE,
        ERROR_PREFIX "Invalidhandle"
    },
    {
        AP_MPLAYER_ERROR_NO_METADATA_AVAILABLE,
        ERROR_PREFIX "NoMetadataAvailable"
    }
};


GQuark
ap_mplayer_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-mplayer-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
