/******************************************************************
*FILE: ap-media-player-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to mediaplayer
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_MPLAYER_ENUMS__
#define __AP_MPLAYER_ENUMS__

/**
 * ApMPlayerMediaType:
 * @AP_MPLAYER_MEDIA_TYPE_UNKNOWN: Unknown media.
 * @AP_MPLAYER_MEDIA_TYPE_AUDIO: Media is of type Audio.
 * @AP_MPLAYER_MEDIA_TYPE_VIDEO: Media is of type Video.
 * @AP_MPLAYER_MEDIA_TYPE_IMAGE: Media id of type Image.
 *
 * It represents different types for media.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_MEDIA_TYPE_UNKNOWN,
  AP_MPLAYER_MEDIA_TYPE_AUDIO,
  AP_MPLAYER_MEDIA_TYPE_VIDEO,
  AP_MPLAYER_MEDIA_TYPE_IMAGE
} ApMPlayerMediaType;


/**
 * ApMPlayerSortBy:
 * @AP_MPLAYER_SORT_BY_GENRE: Track list sort by genres
 * @AP_MPLAYER_SORT_BY_ARTIST: Track list sort by artists
 * @AP_MPLAYER_SORT_BY_ALBUM: Track list sort by albums
 * @AP_MPLAYER_SORT_BY_SONG: Track list sort by songs
 * @AP_MPLAYER_SORT_BY_TITLE: Track list sort by title
 * @AP_MPLAYER_SORT_BY_DATE: Track list sort by created date
 * @AP_MPLAYER_SORT_BY_TAG: Track list sort by tag
 * @AP_MPLAYER_SORT_BY_COMPOSER: Track list sort by composers
 * @AP_MPLAYER_SORT_BY_VIDEO: Track list sort by videos
 *
 * It represents different values for sort fields.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_SORT_BY_GENRE,
  AP_MPLAYER_SORT_BY_ARTIST,
  AP_MPLAYER_SORT_BY_ALBUM,
  AP_MPLAYER_SORT_BY_SONG,
  AP_MPLAYER_SORT_BY_TITLE,
  AP_MPLAYER_SORT_BY_DATE,
  AP_MPLAYER_SORT_BY_TAG,
  AP_MPLAYER_SORT_BY_COMPOSER,
  AP_MPLAYER_SORT_BY_VIDEO
} ApMPlayerSortBy;

/**
 * ApMPlayerSortOrder:
 * @AP_MPLAYER_SORT_ORDER_ASCENDING: Sort order is ascending.
 * @AP_MPLAYER_SORT_ORDER_DESCENDING: Sort order is descending.
 *
 * It represents different values for SortOrder.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_SORT_ORDER_ASCENDING,
  AP_MPLAYER_SORT_ORDER_DESCENDING
} ApMPlayerSortOrder;


/**
 * ApMPlayerMetaDataKey:
 * @AP_MPLAYER_METADATA_KEY_INVALID: Key invalid
 * @AP_MPLAYER_METADATA_KEY_ALBUM: Album text
 * @AP_MPLAYER_METADATA_KEY_ARTIST: Artist text
 * @AP_MPLAYER_METADATA_KEY_AUTHOR: Author text
 * @AP_MPLAYER_METADATA_KEY_GENRE: Genre text
 * @AP_MPLAYER_METADATA_KEY_TITLE: Media file title text
 * @AP_MPLAYER_METADATA_KEY_EPISODE: Episode number
 * @AP_MPLAYER_METADATA_KEY_EPISODE_TITLE: Episode title text
 * @AP_MPLAYER_METADATA_KEY_WIDTH: Image file width
 * @AP_MPLAYER_METADATA_KEY_HEIGHT: Image file height
 * @AP_MPLAYER_METADATA_KEY_CREATION_DATE: Creation date of the media file
 * @AP_MPLAYER_METADATA_KEY_DESCRIPTION: Description of media file
 * @AP_MPLAYER_METADATA_KEY_DURATION: Total duration
 * @AP_MPLAYER_METADATA_KEY_FAVOURITE: Is media file favourite
 * @AP_MPLAYER_METADATA_KEY_MIME: Multipurpose Internet Mail extensions
 * @AP_MPLAYER_METADATA_KEY_MODIFICATION_DATE: Modification date
 * @AP_MPLAYER_METADATA_KEY_RATING: Rating
 * @AP_MPLAYER_METADATA_KEY_THUMBNAIL: Thumbnail
 * @AP_MPLAYER_METADATA_KEY_TRACK_NUMBER: Track number
 *
 * It represents the list of keys for which the metadata is fetched.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_METADATA_KEY_INVALID,
  AP_MPLAYER_METADATA_KEY_ALBUM,
  AP_MPLAYER_METADATA_KEY_ARTIST,
  AP_MPLAYER_METADATA_KEY_AUTHOR,
  AP_MPLAYER_METADATA_KEY_GENRE,
  AP_MPLAYER_METADATA_KEY_TITLE,
  AP_MPLAYER_METADATA_KEY_EPISODE,
  AP_MPLAYER_METADATA_KEY_EPISODE_TITLE,
  AP_MPLAYER_METADATA_KEY_WIDTH,
  AP_MPLAYER_METADATA_KEY_HEIGHT,
  AP_MPLAYER_METADATA_KEY_CREATION_DATE,
  AP_MPLAYER_METADATA_KEY_DESCRIPTION,
  AP_MPLAYER_METADATA_KEY_DURATION,
  AP_MPLAYER_METADATA_KEY_FAVOURITE,
  AP_MPLAYER_METADATA_KEY_MIME,
  AP_MPLAYER_METADATA_KEY_MODIFICATION_DATE,
  AP_MPLAYER_METADATA_KEY_RATING,
  AP_MPLAYER_METADATA_KEY_THUMBNAIL,
  AP_MPLAYER_METADATA_KEY_TRACK_NUMBER
} ApMPlayerMetaDataKey;

/**
 * ApMPlayerState:
 * @AP_MPLAYER_STATE_PLAYING: A track is currently playing
 * @AP_MPLAYER_STATE_PAUSED: A track is current paused
 * @AP_MPLAYER_STATE_STOPPED: There is no currently playing track
 *
 * It represents different playback states.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_STATE_PLAYING,
  AP_MPLAYER_STATE_PAUSED,
  AP_MPLAYER_STATE_STOPPED
} ApMPlayerState;

/**
 * ApMPlayerSourceType:
 * @AP_MPLAYER_SOURCE_UNKNOWN: Unknown device type
 * @AP_MPLAYER_SOURCE_USB: Media is stored on a USB device
 * @AP_MPLAYER_SOURCE_IPOD: Media stored in IPod
 * @AP_MPLAYER_SOURCE_BLUETOOTH: Media is stored on a Bluetooth device
 * @AP_MPLAYER_SOURCE_CDROM: Media is stored on a CDROM
 * @AP_MPLAYER_SOURCE_UNSUPPORTED: Unsupported device
 *
 * It represents different source types.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_SOURCE_UNKNOWN,
  AP_MPLAYER_SOURCE_USB,
  AP_MPLAYER_SOURCE_IPOD,
  AP_MPLAYER_SOURCE_BLUETOOTH,
  AP_MPLAYER_SOURCE_CDROM,
  AP_MPLAYER_SOURCE_UNSUPPORTED
} ApMPlayerSourceType;

/**
 * ApMPlayerLoopStatus:
 * @AP_MPLAYER_LOOP_NONE: Indicates that playback will stop when there are no
 *  more tracks to play.
 * @AP_MPLAYER_LOOP_TRACK: Indicates that the current track will start again
 *  from beginning once it has finished playing.
 * @AP_MPLAYER_LOOP_PLAYLIST: Indicates that the playback loops through a list
 *  of tracks.
 *
 * Enums specifying current loop/repeat status.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_MPLAYER_LOOP_NONE,
  AP_MPLAYER_LOOP_TRACK,
  AP_MPLAYER_LOOP_PLAYLIST
} ApMPlayerLoopStatus;

#endif
