/******************************************************************
*FILE: ap-factory-reset-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: Factory reset error enums
*COPYRIGHT:  2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_FACTORY_RESET_ERROR_H
#define AP_FACTORY_RESET_ERROR_H

#include <glib.h>
#include "ap-factory-reset-enums.h"

G_BEGIN_DECLS

/**
 * AP_FACTORY_RESET_ERROR:
 *
 * Error domain for #ApFactoryResetError.
 *
 * Since: 1.0
 */
#define AP_FACTORY_RESET_ERROR ap_factory_reset_error_quark ()
GQuark ap_factory_reset_error_quark (void);

/**
 * ApFactoryResetError:
 * @AP_FACTORY_RESET_UNKNOWN_ERR: Unrecongnised error.
 * @AP_FACTORY_RESET_BAD_PARAMS_ERR: Invalid input parameters.
 * @AP_FACTORY_RESET_FUNC_NOT_SUPPORTED_ERR: The function is not supported.
 * @AP_FACTORY_RESET_INTERNAL_ENGINE_ERR: Internal error in factory reset
 * component.
 * Errors from operations on factory reset.
 *
 * Since: 1.0
 */
typedef enum
{
    AP_FACTORY_RESET_UNKNOWN_ERR,
    AP_FACTORY_RESET_BAD_PARAMS_ERR,
    AP_FACTORY_RESET_FUNC_NOT_SUPPORTED_ERR,
    AP_FACTORY_RESET_INTERNAL_ENGINE_ERR,
    AP_FACTORY_RESET_SUCCESS
} ApFactoryResetError;

G_END_DECLS

#endif /* !AP_FACTORY_RESET_ERROR_H */
