/******************************************************************
*FILE: ap-factory-reset-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to factory reset
*COPYRIGHT:  2017 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_FACTORY_RESET_ENUMS__
#define __AP_FACTORY_RESET_ENUMS__

/**
 * ApFactoryResetState:
 * @AP_FACTORY_RESET_STATE_PREPARE: prepare for factory reset.
 * @AP_FACTORY_RESET_STATE_EXECUTE: factory reset is ready to start.
 * @AP_FACTORY_RESET_STATE_FINALIZE: completed factory reset
 *
 * It represents different states of factory reset.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_FACTORY_RESET_STATE_PREPARE,
  AP_FACTORY_RESET_STATE_EXECUTE,
  AP_FACTORY_RESET_STATE_FINALIZE
} ApFactoryResetState;

/**
 * ApFactoryResetSystemId:
 * @AP_FACTORY_RESET_SYSTEM_ID_UNKOWN: 
 * @AP_FACTORY_RESET_SYSTEM_ID_ALL_DOMAINS: 
 * @AP_FACTORY_RESET_SYSTEM_ID_AUDIO_MANAGER: 
 * @AP_FACTORY_RESET_SYSTEM_ID_TUNER_AMFM: 
 * @AP_FACTORY_RESET_SYSTEM_ID_TUNER_DAB: 
 * @AP_FACTORY_RESET_SYSTEM_ID_TUNER_SXM: 
 * @AP_FACTORY_RESET_SYSTEM_ID_GenericGateway:
 *
 * It represents different system identifier a reset is issued.
 *
 * Since: 1.0
 */
typedef enum
{
  AP_FACTORY_RESET_SYSTEM_ID_UNKOWN,
  AP_FACTORY_RESET_SYSTEM_ID_ALL_DOMAINS,
  AP_FACTORY_RESET_SYSTEM_ID_AUDIO_MANAGER,
  AP_FACTORY_RESET_SYSTEM_ID_TUNER_AMFM,
  AP_FACTORY_RESET_SYSTEM_ID_TUNER_DAB,
  AP_FACTORY_RESET_SYSTEM_ID_TUNER_SXM,
  AP_FACTORY_RESET_SYSTEM_ID_GenericGateway  
} ApFactoryResetSystemId;


/**
 * ApFactoryResetType:
 * @AP_FACTORY_RESET_TYPE_UNKOWN:
 * @AP_FACTORY_RESET_TYPE_HMI:
 * @AP_FACTORY_RESET_TYPE_PRODUCTION:
 * @AP_FACTORY_RESET_TYPE_ALIGNMENT:
 * @AP_FACTORY_RESET_TYPE_CALIBRATION:
 * @AP_FACTORY_RESET_TYPE_CUSTOMER:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_RESET_ALL:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_RESET_USER:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_RESET_BANK:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_SWITCH_USER:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_SWITCH_BANK:
 * @AP_FACTORY_RESET_TYPE_USERMGMT_SAVE_BANK:
 * @AP_FACTORY_RESET_TYPE_DIAGNOSTICS_INTERNAL:
 *
 * It represents different factory reset types issued.
 *
 * Since: 1.0
 */
typedef enum
{
    AP_FACTORY_RESET_TYPE_UNKOWN,
    AP_FACTORY_RESET_TYPE_HMI,
    AP_FACTORY_RESET_TYPE_PRODUCTION,
    AP_FACTORY_RESET_TYPE_ALIGNMENT,
    AP_FACTORY_RESET_TYPE_CALIBRATION,
    AP_FACTORY_RESET_TYPE_CUSTOMER,
    AP_FACTORY_RESET_TYPE_USERMGMT_RESET_ALL,
    AP_FACTORY_RESET_TYPE_USERMGMT_RESET_USER,
    AP_FACTORY_RESET_TYPE_USERMGMT_RESET_BANK,
    AP_FACTORY_RESET_TYPE_USERMGMT_SWITCH_USER,
    AP_FACTORY_RESET_TYPE_USERMGMT_SWITCH_BANK,
    AP_FACTORY_RESET_TYPE_USERMGMT_SAVE_BANK,
    AP_FACTORY_RESET_TYPE_DIAGNOSTICS_INTERNAL
} ApFactoryResetType;


#endif
