/******************************************************************
*FILE: ap-contact-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: Contacts error enums
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_CONTACT_ERROR_H
#define AP_CONTACT_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_CONTACT_ERROR:
 *
 * Error domain for #APContactError.
 *
 * Since: 0.1.0
 */
#define AP_CONTACT_ERROR ap_contact_error_quark ()
GQuark ap_contact_error_quark (void);

/**
 * APContactError:
 * @AP_CONTACT_ERROR_UNKNOWN_SOURCE: The given source does not exist in this
 *    system.
 * @AP_CONTACT_ERROR_UNKNOWN_ATTRIBUTE: The given attribute does not exist in
 *    this system.
 * @AP_CONTACT_ERROR_INVALID_ATTRIBUTE_VALUE: Attribute value is invalid.
 * @AP_CONTACT_ERROR_ATTRIBUTE_UNAVAILABLE: Attribute is not currently available
 *    for access.
 * @AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR: The given contact manager implementation
 *    broke the interface definition.
 * @AP_CONTACT_ERROR_INVALID_HANDLE: Provided handle is invalid.
 *
 * Errors from operations on contact manager.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_CONTACT_ERROR_UNKNOWN_SOURCE,
  AP_CONTACT_ERROR_UNKNOWN_ATTRIBUTE,
  AP_CONTACT_ERROR_INVALID_ATTRIBUTE_VALUE,
  AP_CONTACT_ERROR_ATTRIBUTE_UNAVAILABLE,
  AP_CONTACT_ERROR_ILLEGAL_BEHAVIOUR,
  AP_CONTACT_ERROR_INVALID_HANDLE,
  /*< private >*/
  AP_CONTACT_N_MANAGER_ERRORS /*< skip >*/
} APContactError;

G_END_DECLS

#endif /* !AP_CONTACT_ERROR_H */
