/******************************************************************
*FILE: ap-contact-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: This file contains the enums related to contact manager
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef __AP_CONTACT_ENUMS__
#define __AP_CONTACT_ENUMS__

/**
* ApContactSortBy:
* @AP_CONTACT_SORTBY_FIRSTNAME: Sort by first name.
* @AP_CONTACT_SORTBY_LASTNAME: Sort by last name.
* @AP_CONTACT_SORTBY_ADDRESS: Sort by address,
* @AP_CONTACT_SORTBY_EMAIL: Sort by email.
* @AP_CONTACT_SORTBY_NUMBER: Sort by phone number,
* @AP_CONTACT_SORTBY_CATEGORY: Sort by category,
* @AP_CONTACT_SORTBY_BIRTHDAY: Sort by birthday
*
* It represents different values for SortBy.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_CONTACT_SORTBY_FIRSTNAME,
  AP_CONTACT_SORTBY_LASTNAME,
  AP_CONTACT_SORTBY_ADDRESS,
  AP_CONTACT_SORTBY_EMAIL,
  AP_CONTACT_SORTBY_NUMBER,
  AP_CONTACT_SORTBY_CATEGORY,
  AP_CONTACT_SORTBY_BIRTHDAY,
  AP_CONTACT_SORTBY_FINISHED
} ApContactSortBy;

/**
* ApContactSortOrder:
* @AP_CONTACT_SORT_ORDER_ASCENDING: Sort order is ascending.
* @AP_CONTACT_SORT_ORDER_DESCENDING: Sort order is descending.
*
* It represents different values for SortOrder.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_CONTACT_SORT_ORDER_ASCENDING,
  AP_CONTACT_SORT_ORDER_DESCENDING,
  AP_CONTACT_SORT_ORDER_FINISHED
} ApContactSortOrder;

/**
* ApContactOperator:
* @AP_CONTACT_OPERATOR_CONTAINS: With this operation, a contact will be returned
*				 if its filtered field contains the given value.
* @AP_CONTACT_OPERATOR_IS: With this operation, a contact will be returned if
*			   its filtered field matches exactly the given value.
*
* It represents different values for Operator.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_CONTACT_OPERATOR_CONTAINS,
  AP_CONTACT_OPERATOR_IS,
  AP_CONTACT_OPERATOR_FINISHED
} ApContactOperator;

/**
* ApContactField:
* @AP_CONTACT_FIELD_FIRSTNAME: First name.
* @AP_CONTACT_FIELD_LASTNAME: Last name.
* @AP_CONTACT_FIELD_ADDRESS: Address.
*
* It represents different values for Field.
*
* Since: 0.1.0
*/
typedef enum
{
  AP_CONTACT_FIELD_FIRSTNAME,
  AP_CONTACT_FIELD_LASTNAME,
  AP_CONTACT_FIELD_ADDRESS,
  AP_CONTACT_FIELD_FINISHED
} ApContactField;

#endif
