/******************************************************************
*FILE: ap-bluetooth-error-enums.h
*SW-COMPONENT: Internet
*DESCRIPTION: Bluetooth error enums
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#ifndef AP_BLUETOOTH_ERROR_H
#define AP_BLUETOOTH_ERROR_H

#include <glib.h>

G_BEGIN_DECLS

/**
 * AP_BLUETOOTH_ERROR:
 *
 * Error domain for #APBluetoothError.
 *
 * Since: 0.1.0
 */
#define AP_BLUETOOTH_ERROR ap_bluetooth_error_quark ()
GQuark ap_bluetooth_error_quark (void);

/**
 * APBluetoothError:
 * @AP_BLUETOOTH_ERROR_UNKNOWN_DEVICE: The given device does not exist in this
 *    system.
 * @AP_BLUETOOTH_ERROR_UNKNOWN_ATTRIBUTE: The given attribute does not exist in
 *    this device.
 * @AP_BLUETOOTH_ERROR_INVALID_ATTRIBUTE_VALUE: Attribute value is invalid.
 * @AP_BLUETOOTH_ERROR_ATTRIBUTE_UNAVAILABLE: Attribute is not currently 
      available for access.
 * @AP_BLUETOOTH_ERROR_ILLEGAL_BEHAVIOUR: The given bluetooth manager
      implementation broke the interface definition.
 *
 * Errors from operations on bluetooth manager.
 *
 * Since: 0.1.0
 */
typedef enum
{
  AP_BLUETOOTH_ERROR_UNKNOWN_DEVICE,
  AP_BLUETOOTH_ERROR_UNKNOWN_ATTRIBUTE,
  AP_BLUETOOTH_ERROR_INVALID_ATTRIBUTE_VALUE,
  AP_BLUETOOTH_ERROR_ATTRIBUTE_UNAVAILABLE,
  AP_BLUETOOTH_ERROR_ILLEGAL_BEHAVIOUR,
  AP_BLUETOOTH_ERROR_INTERNAL_ERROR,
  AP_BLUETOOTH_ERROR_NO_DEVICE_CONNECTED,
  /*< private >*/
  AP_BLUETOOTH_N_MANAGER_ERRORS /*< skip >*/
} APBluetoothError;

G_END_DECLS

#endif /* !AP_BLUETOOTH_ERROR_H */
