/******************************************************************
*FILE: ap-bluetooth-error-enums.c
*SW-COMPONENT: Internet
*DESCRIPTION: To register dbus error domain for Bluetooth manager.
*COPYRIGHT: © 2016 Robert Bosch GmbH
*
*The reproduction, distribution and utilization of this file as
*well as the communication of its contents to others without express
*authorization is prohibited. Offenders will be held liable for the
*payment of damages. All rights reserved in the event of the grant
*of a patent, utility model or design.
******************************************************************/

#include <gio/gio.h>
#include "ap-bluetooth-error-enums.h"

#define ERROR_PREFIX "com.bosch.AutomotiveProxy.BluetoothError."

static const GDBusErrorEntry error_entries[] =
{
    {
        AP_BLUETOOTH_ERROR_UNKNOWN_DEVICE,
        ERROR_PREFIX "UnknownDevice"
    },
    {
        AP_BLUETOOTH_ERROR_UNKNOWN_ATTRIBUTE,
        ERROR_PREFIX "UnknownAttribute"
    },
    {
        AP_BLUETOOTH_ERROR_INVALID_ATTRIBUTE_VALUE,
        ERROR_PREFIX "InvalidAttributeValue"
    },
    {
        AP_BLUETOOTH_ERROR_ATTRIBUTE_UNAVAILABLE,
        ERROR_PREFIX "AttributeUnAvailable"
    },
    {
        AP_BLUETOOTH_ERROR_ILLEGAL_BEHAVIOUR,
        ERROR_PREFIX "IllegalBehaviour"
    },
    {
        AP_BLUETOOTH_ERROR_INTERNAL_ERROR,
        ERROR_PREFIX "InternalError"
    },
    {
        AP_BLUETOOTH_ERROR_NO_DEVICE_CONNECTED,
        ERROR_PREFIX "NoDeviceConnected"
    },
};

GQuark
ap_bluetooth_error_quark (void)
{
  static volatile gsize id = 0;

  g_dbus_error_register_error_domain ("ap-bluetooth-error-quark", &id,
                                      error_entries,
                                      G_N_ELEMENTS (error_entries));

  return (GQuark) id;
}
