/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_service_AudioRouteMgr.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA service AudioRouteMgr.
*
* AUTHOR:       Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_service_audioroutemgr.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "Trace/fc_audioroutemgr_trace.h"
#include "ResourceMgmt/fc_audioroutemgr_audiosource.h"
#include "ResourceMgmt/fc_audioroutemgr_resourcemanager.h"
#include "ClientHandler/fc_audioroutemgr_clienthandler_audiofunc.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR
#include "trcGenProj/Header/fc_audioroutemgr_service_audioroutemgr.cpp.trc.h"
#endif

#define FC_AUDIOROUTEMGR_S_IMPORT_INTERFACE_MSG
#include "fc_audioroutemgr_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO

#include "midw_fi_if.h"

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION  1
#define FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MINOR_VERSION  0
#define FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_PATCH_VERSION  0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audioroutemgr_tclService_AudioRouteMgr, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
  ON_MESSAGE_SVCDATA(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_SET, vSetSourceRouteActivity)
  ON_MESSAGE_SVCDATA(MIDW_AUDIO_ROUTE_MGRFI_C_U16_LOADSOURCESETTINGS, AMT_C_U8_CCAMSG_OPCODE_METHODSTART, vLoadSourceSettings)

  ON_MESSAGE_SVCDATA(MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTEREJECT, AMT_C_U8_CCAMSG_OPCODE_SET, vSetAudioRouteRequestReject)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclService_AudioRouteMgr::fc_audioroutemgr_tclService_AudioRouteMgr(fc_audioroutemgr_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class ahl_tclBaseOneThreadService
*              with a pointer to this application, the service identifier,
*              the application identifier and the service version as parameters.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclService_AudioRouteMgr::
  fc_audioroutemgr_tclService_AudioRouteMgr(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclresourcemanager* poResourceMgr, fc_audioroutemgr_tclsourcefactory* poSourceFactory)
    :ahl_tclBaseOneThreadService(
      /* Application Pointer              */ poMainAppl,
      /* ID of offered Service            */ CCA_C_U16_SRV_AUDIO_ROUTE_MGR,
      /* MajorVersion of offered Service  */ FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION,
      /* MinoreVersion of offered Service */ FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MINOR_VERSION,
      /* PatchVersion of offered Service  */ FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_PATCH_VERSION)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclService_AudioRouteMgr() entered."));
  m_poResourceMgr = poResourceMgr;
  m_poSourceFactory = poSourceFactory;
  m_poMainAppl = poMainAppl;
  ahl_tclBaseOneThreadService::vSetPrivateServiceAvailableAllowed(FALSE);
  m_u16TargetAppID = 0;
  m_u16RegisterID = 0;
  m_u16CmdCounter = 0;

  m_u8CurSource = 0;
  m_u8PosNextSource = 0;
  m_u16SubSource = 0;
  m_u8Activity = 0;
  m_u8Resource = 0;
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclService_AudioRouteMgr::~fc_audioroutemgr_tclService_AudioRouteMgr(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclService_AudioRouteMgr::~fc_audioroutemgr_tclService_AudioRouteMgr(tVoid)
{
  ETG_TRACE_USR4(("~fc_audioroutemgr_tclService_AudioRouteMgr() entered."));
  m_poSourceFactory = NULL;
  m_poResourceMgr = NULL;

}

tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vAudioManagerAvailable()
{
  ETG_TRACE_USR1(("make own service available"));
  vSetPrivateServiceAvailableAllowed(TRUE);
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              which is offered by this server has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered."));
}

/*******************************************************************************
*
* FUNCTION: tBool fc_audioroutemgr_tclService_AudioRouteMgr
*                 ::bStatusMessageFactory(tU16 u16FunctionId,
*                                         amt_tclServiceData& roOutMsg,
*                                         amt_tclServiceData* poInMsg)
*
* DESCRIPTION: This function is called by the CCA framework to request ANY
*              property which is offered by this service. For each property
*              accessed via parameter 'u16FunctionId' the user has to prepare
*              the corresponding FI data object and to copy it to the
*              referenced service data object 'roOutMsg'.
*
* PARAMETER: [IN] u16FunctionId = Function ID of the requested property.
*            [OUT] roOutMsg = Reference to the service data object to which the
*                             content of the prepared FI data object should be
*                             copied to.
*            [IN] poInMsg = Selector message which is used to select dedicated
*                           content to be copied to 'roOutMsg' instead of
*                           updating the entire FI data object.
*
* RETURNVALUE: TRUE = For the requested property the FI data object was
*                     successfully created and copied to the referenced service
*                     data object 'roOutMsg'. The CCA framework sends a 'STATUS'
*                     message of the updated property to each registered
*                     clients.
*              FALSE = Failed to create the FI data object for the requested
*                      property and to update the referenced service data object
*                      'roOutMsg' with the new property content. The CCA
*                      framework sends an error message to the requesting
*                      client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bStatusMessageFactory().
*******************************************************************************/
tBool fc_audioroutemgr_tclService_AudioRouteMgr
      ::bStatusMessageFactory(tU16 u16FunctionId,
                              amt_tclServiceData& roOutMsg,
                              amt_tclServiceData* poInMsg)
{
  (tVoid) poInMsg;  // These lines are added to avoid LINT warnings. Please
                     // remove as soon as the variables are used.

  tBool bRetVal = FALSE;

  ETG_TRACE_USR4(("bStatusMessageFactory() entered. FID = 0x%4x.",
                  u16FunctionId));

  switch(u16FunctionId)
  {
    // Handle creation of the FI data object for this function ID and the
    // handover to the referenced service data object 'roOutMsg' here ...

    // Set local variable 'bSuccess' to TRUE if the creation of the FI data
    // object and the handover to 'roOutMsg' was successfull.
    case MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY:
    {
       midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus oFiDataObject;

       oFiDataObject.SourceRouteActivity.Source.enType =  (midw_fi_tcl_e8_AudSource::tenType)m_u8CurSource;
       oFiDataObject.SourceRouteActivity.PossibleNextSource.enType =  (midw_fi_tcl_e8_AudSource::tenType)m_u8PosNextSource;
       oFiDataObject.SourceRouteActivity.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)m_u8Resource;
       oFiDataObject.SourceRouteActivity.Activity.enType = (midw_fi_tcl_e8_SrcActivity::tenType)m_u8Activity;
       oFiDataObject.SourceRouteActivity.SubSource = m_u16SubSource;

       fi_tclVisitorMessage oVisitor(oFiDataObject, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION);
       oFiDataObject.vDestroy();
       ETG_TRACE_USR4(("bStatusMessageFactory() P_SOURCEROUTEACTIVITY Src =%d, PosNextSrc =%d, SubSrc =%d, Sink =%d, Activity =%d",
           m_u8CurSource,m_u8PosNextSource,m_u16SubSource,m_u8Resource,m_u8Activity));

       bRetVal = oVisitor.bHandOver(&roOutMsg);
       break;
    }

    case MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE:
    {
      ETG_TRACE_USR4(("bStatusMessageFactory MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE"));
      midw_audio_route_mgrfi_tclMsgRequestAudioRouteStatus oFiDataObject;

      if(m_poSourceFactory != OSAL_NULL)
        {
      oFiDataObject.RequestAudioRouteList = m_poSourceFactory->vReqRouteList();
        }

        fi_tclVisitorMessage oVisitor(oFiDataObject, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION);
        bRetVal = oVisitor.bHandOver(&roOutMsg);
        oFiDataObject.vDestroy();

        break;
    }

    case MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY:
    {
      ETG_TRACE_USR4(("bStatusMessageFactory MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY"));
      midw_audio_route_mgrfi_tclMsgSourceAvailabilityStatus oFiDataObject;

      if(m_poSourceFactory != OSAL_NULL)
        {
        oFiDataObject.SourceAvailabilityList = m_poSourceFactory->vSrcAvailabilityList();
        }

        fi_tclVisitorMessage oVisitor(oFiDataObject, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION);
        bRetVal = oVisitor.bHandOver(&roOutMsg);
        oFiDataObject.vDestroy();

        break;
    }


  default:
  {
     ETG_TRACE_ERR(("ERROR: Function Id: 0x%x called from status factory", u16FunctionId));
     bRetVal = FALSE;
     break;
  }  // default:
}
   return bRetVal;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_audioroutemgr_tclService_AudioRouteMgr
*                 ::bProcessSet(amt_tclServiceData* poMessage,
*                               tBool& bPropertyChanged,
*                               tU16& u16ErrorCode)
*
* DESCRIPTION: This function is called by the CCA framework when it has
*              received a message for a property with Opcode 'SET' or 'PURESET'
*              and there is no dedicated handler function defined in the
*              message map for this pair of FID and opcode. The user has to
*              set the application specific property to the requested value
*              and the CCA framework then cares about informing the requesting
*              client as well as other registered clients.
*
* PARAMETER: [IN] poMessage = Property to be set.
*            [OUT] bPropertyChanged = Property changed flag to be set to TRUE
*                                     if property has changed. Otherwise to be
*                                     set to FALSE (default).
*            [OUT] u16ErrorCode = Error code to be set if a CCA error occurs,
*                                 otherwise don't touch.
*
* RETURNVALUE: TRUE = Property successfully set to the passed value. The CCA
*                     framework sends a 'STATUS' message to the requesting
*                     client if the opcode was 'SET'. Othwerwise if opcode
*                     was 'PURESET' there is no 'STATUS' message sent to the
*                     requesting client. The CCA framework will send a 'STATUS'
*                     message to other registered clients as well if the [OUT]
*                     parameter 'bPropertyChanged' is set to TRUE.
*             FALSE = Failed to set the property to the passed value. The CCA
*                     framework sends an error message to the requesting client.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadService::bProcessSet().
*******************************************************************************/
tBool fc_audioroutemgr_tclService_AudioRouteMgr
      ::bProcessSet(amt_tclServiceData* poMessage,
                    tBool& bPropertyChanged,
                    tU16& u16ErrorCode)
{
  (tVoid) bPropertyChanged; // This line is added to avoid LINT warnings.
                            // Please remove as soon as the variable is used.

  tBool bSuccess = FALSE;

  tU16 u16FunctionId = poMessage->u16GetFunctionID();

  ETG_TRACE_USR4(("bProcessSet() entered. FID = 0x%4x.", u16FunctionId));

  //fi_tclVisitorMessage oVisitorMsg(poMessage);

  switch(u16FunctionId)
  {

  // Handle property setting for this function ID here ...
    case MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY:
    {
      ETG_TRACE_USR4(("bProcessSet() entered for P_SOURCEROUTEACTIVITY"));
      bSuccess = TRUE;
      break;
    }
    default:
    {
      ETG_TRACE_USR4(("bProcessSet() entered for unknown FID"));
      break;
    }

  }
    // Set local variable 'bSuccess' to TRUE if setting the propery to the new
    // value was successfull.

    // Set [OUT] parameter 'bPropertyChanged' to TRUE if the value of the just
    // set property has changed.

  if (FALSE == bSuccess)
  {
    u16ErrorCode = CCA_C_U16_ERROR_UNKNOWN_FCT_ID;

    ETG_TRACE_ERR(("bProcessSet(). Setting of property with 'FID = %u' failed.",
                   u16FunctionId));

    NORMAL_M_ASSERT_ALWAYS();
  }

  return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnLoopbackService(amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called from the vOnLoopback() function of this
*              CCA application if a message from one of this applications
*              services is received (so called self or loopback messages).
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*            [IN] poMessage = Message object.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vOnLoopbackService(amt_tclServiceData* poMessage) const
{
  gm_tclU32Message oVisitorMsg(poMessage);

  tU16 u16FunctionId = poMessage->u16GetFunctionID();

  ETG_TRACE_USR4(("vOnLoopbackService() entered. iFID = 0x%4x.", u16FunctionId));

  switch(u16FunctionId)
  {
  case MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY :
  {
    ETG_TRACE_ERR(("vOnLoopbackService() P_SOURCEROUTEACTIVITY received "));
  }
  break;
#if 0
  case AUDIOROUTEMGR_C_U16_IFID_EXAMPLE_1 :
  {
    tU32 u32MsgContent = oVisitorMsg.u32GetDWord();
    switch(u32MsgContent)
    {
    case AUDIOROUTEMGR_C_U32_MSGID_EXAMPLE_1 :
    {
      // Some Action.
    }
    break;

    default:
    {
      ETG_TRACE_ERR(("vOnLoopbackService(). Unknown u32MsgContent %u.",
             u32MsgContent));
    }
    }
  }
  break;
#endif
    default:
    {
      ETG_TRACE_ERR(("vOnLoopbackService(). Unknown iFID %u.", u16FunctionId));
      break;
    }
  }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the vOnTimer() function of this
*              CCA application on the expiration of a previously via function
*              bStartTimer() started timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vProcessTimer(tU16 u16TimerId) const
{
  static tU16 u16Count=0;
  u16Count++;
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u (%u).",u16TimerId,u16Count));

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION:
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: -
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("fc_audioroutemgr_tclService_AudioRouteMgr::vTraceRx() entered."));

   if(pcu8Data==0) return;
   // pcu8Data[0] == my file number
   // pcu8Data[1] == the command
   // pcu8Data[2] == the 1. parameter
   // rest is defined here

   ETG_TRACE_USR4(("vTraceRx() size=%u",size));
   if (size > 1)
   {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
      switch ( pcu8Data[1] )
      {
      case TRC::SetSourceRouteActivity:
         ETG_TRACE_USR4(("TTFis Rx SetSourceRouteActivity"));
         if (size > 6)
           vTraceInputSourceRouteActivity(pcu8Data[2],pcu8Data[3],pcu8Data[4],pcu8Data[5],pcu8Data[6]);
         else
           ETG_TRACE_USR4(("SetSourceRouteActivity too few params %u",size));
         break;
#if 0
      case TRC::ReqRoute:
        ETG_TRACE_USR4(("TTFis Rx SetSourceRouteActivity"));
       if (size > 1)
         vTraceInputReqaudioroute();
       else
       ETG_TRACE_USR4(("vSendSourceRouteActivityStatusOff too few params %u",size));
       break;
#endif
      default:
        ETG_TRACE_USR4(("default"));
         break;
      }
   }
}
/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusOff
*                  (tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity)
*
* DESCRIPTION: Sends the Status of Source Route Activity Off to HMI
*
* PARAMETER:   tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity
*
* RETURNVALUE: None.
*
**********************************************************************************************/

tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusOff(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource, tU8 u8Resource, tU8 u8Activity)
{
  ETG_TRACE_USR4(("vSendSourceRouteActivityStatusOff() entered"));

  vSendStatusMessage(u8Source, u8NextSource, u16SubSource, u8Resource, u8Activity);

  if (updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY) != AIL_EN_N_NO_ERROR)
  {
        ETG_TRACE_ERR(("Updating the clients failed for SourceRouteActivityStatusOff"));
  }
  else
  {
        ETG_TRACE_USR4(("Updating the clients done for SourceRouteActivityStatusOff"));
  }

}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusOn
*                  (tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity)
*
* DESCRIPTION: Sends the Status of Source Route Activity On to HMI
*
* PARAMETER:   tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusOn(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource, tU8 u8Resource, tU8 u8Activity)
{
  ETG_TRACE_USR4(("vSendSourceRouteActivityStatusOn() entered Src =%d, PosNextSrc =%d, SubSrc =%d, Sink =%d, Activity =%d",
      u8Source, u8NextSource, u16SubSource, u8Resource, u8Activity));
  vSendStatusMessage(u8Source, u8NextSource, u16SubSource, u8Resource, u8Activity);

  if (updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY) != AIL_EN_N_NO_ERROR)
  {
        ETG_TRACE_ERR(("Updating the clients failed for SourceRouteActivityStatusOn"));
  }
  else
  {
        ETG_TRACE_USR4(("Updating the clients done for SourceRouteActivityStatusOn"));
  }
}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusPause
*                  (tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity)
*
* DESCRIPTION: Sends the Status of Source Route Activity Pause to HMI
*
* PARAMETER:   tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendSourceRouteActivityStatusPause(tU8 u8Source, tU8 u8NextSource, tU16 u16SubSource, tU8 u8Resource, tU8 u8Activity)
{
  ETG_TRACE_USR4(("vSendSourceRouteActivityStatusPause() entered"));

  vSendStatusMessage(u8Source, u8NextSource, u16SubSource, u8Resource, u8Activity);

  if (updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY) != AIL_EN_N_NO_ERROR)
  {
        ETG_TRACE_ERR(("Updating the clients failed for SourceRouteActivityStatusPause"));
  }
  else
  {
        ETG_TRACE_USR4(("Updating the clients done for SourceRouteActivityStatusPause"));
  }

}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSetSourceRouteActivity
*                  (amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handle the Source Route Activity CCA Message from HMI
*
* PARAMETER:   poMessage - Pointer to CCA Message
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSetSourceRouteActivity(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received vSetSourceRouteActivity() from appid 0x%x, regid 0x%x, fid 0x%x...",
                              poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

   m_u16TargetAppID = poMessage->u16GetSourceAppID();
   m_u16RegisterID = poMessage->u16GetRegisterID();
   m_u16CmdCounter = poMessage->u16GetCmdCounter();


  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_audio_route_mgrfi_tclMsgP_SourceRouteActivitySet inmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    if(m_poResourceMgr != NULL)
    {
       tU8 u8CurSource = (tU8)inmsg.SourceRouteActivity.Source.enType;
       tU8 u8PosNextSource = (tU8)inmsg.SourceRouteActivity.PossibleNextSource.enType;
       tU16 u16SrcActivity = (tU16)inmsg.SourceRouteActivity.Activity.enType;
       tU16 u16Resource = (tU16)inmsg.SourceRouteActivity.Resource.enType;
       tU16 u16SubSource = inmsg.SourceRouteActivity.SubSource;
      ETG_TRACE_USR4(("Source Activity:%d, Source:%d, Possible Next Source:%d, SubSource :%d, Sink %d",
          u16SrcActivity,u8CurSource,u8PosNextSource,u16SubSource,u16Resource));

      m_poResourceMgr->vProcessSourceActivityRequest(u8CurSource,u8PosNextSource,u16SrcActivity, u16Resource, u16SubSource);
    }
    else
    {
         vSendErrorMsg(poMessage, MIDW_AUDIO_ROUTE_MGRFI_C_U16_ERROR_UNSPECIFIED);
      ETG_TRACE_ERR(("Fatal Error: _poMainAppl = NULL"));
    }
   }
  else
    {
      vSendErrorMsg(poMessage, MIDW_AUDIO_ROUTE_MGRFI_C_U16_ERROR_UNSPECIFIED);
    }

     inmsg.vDestroy();

}

tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSetAudioRouteRequestReject(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received vSetAudioRouteRequestReject() from appid 0x%x, regid 0x%x, fid 0x%x...",
      poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));


  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectSet inmsg;

  if(oVisitorMsg.s32GetData(inmsg, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    ETG_TRACE_USR4(("PASSED"));
    if(m_poSourceFactory != NULL)
    {
      tU8 source = (tU8)inmsg.Source.enType;
      tU16 u16SubSource = inmsg.SubSource;
      if(m_poSourceFactory->poSourcePtr(source) != NULL)
      {
        tU16 u16AppID = m_poSourceFactory->poSourcePtr(source)->u16GetAppID();

        ETG_TRACE_USR4(("vSetAudioRouteRequestReject AppID %d, Source:%d, SubSource :%d",
            u16AppID,source,u16SubSource));

        if(m_poSourceFactory->getClientHandler(u16AppID)!=NULL)
        {
            m_poSourceFactory->getClientHandler(u16AppID)->vPerformRouteRequestReject(source,u16SubSource);
        }
        else
        {
            ETG_TRACE_ERR(("Fatal Error: can not get client handler for AppID %d",u16AppID));
        }
      }
    }
    else
    {
      ETG_TRACE_ERR(("Fatal Error: m_poSourceFactory = NULL"));
    }
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: could not extract midw_audio_route_mgrfi_tclMsgRequestAudioRouteRejectMethodStart message"));
  }

  inmsg.vDestroy();
}
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vLoadSourceSettings(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Received vSetSourceRouteActivity() from appid 0x%x, regid 0x%x, fid 0x%x...",
                              poMessage->u16GetSourceAppID(), poMessage->u16GetRegisterID(), poMessage->u16GetFunctionID()));

   m_u16TargetAppID = poMessage->u16GetSourceAppID();
   m_u16RegisterID = poMessage->u16GetRegisterID();
   m_u16CmdCounter = poMessage->u16GetCmdCounter();

   if(poMessage != OSAL_NULL)
   {
  fi_tclVisitorMessage oVisitorMsg(poMessage);
  midw_audio_route_mgrfi_tclMsgLoadSourceSettingsMethodStart oFiDataObject1;

  if(oVisitorMsg.s32GetData(oFiDataObject1, FC_AUDIOROUTEMGR_SERVICE_AUDIOROUTEMGR_FI_MAJOR_VERSION) != OSAL_ERROR)
  {
    if(m_poResourceMgr != NULL)
    {
       tU8 u8CurSource = (tU8)oFiDataObject1.SourceRouteActivity.Source.enType;
       tU8 u8PosNextSource = (tU8) oFiDataObject1.SourceRouteActivity.PossibleNextSource.enType;
       tU16 u16SrcActivity = (tU16)oFiDataObject1.SourceRouteActivity.Activity.enType;
       tU16 u16SubSource = oFiDataObject1.SourceRouteActivity.SubSource;

      ETG_TRACE_USR4(("Source Activity:%d, Source:%d, Possible Next Source:%d, SubSource :%d",u16SrcActivity,u8CurSource,u8PosNextSource,u16SubSource));

      m_poMainAppl->m_poClientHandlerAudioRouteMgr_AudioFunc->vStartAudioSource(u8CurSource,u8PosNextSource);
    }
    else
    {
         vSendErrorMsg(poMessage, MIDW_AUDIO_ROUTE_MGRFI_C_U16_ERROR_UNSPECIFIED);
      ETG_TRACE_ERR(("Fatal Error: _poMainAppl = NULL"));
    }
   }
  else
    {
      vSendErrorMsg(poMessage, MIDW_AUDIO_ROUTE_MGRFI_C_U16_ERROR_UNSPECIFIED);
    }
     oFiDataObject1.vDestroy();
   }
   else
     ETG_TRACE_USR4(("poMessage is null"));
}
/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSendErrorMsg(amt_tclServiceData* poMessage, tU16 errorcode)
*
* DESCRIPTION: Sends the Error Message
*
* PARAMETER:   poMessage - Pointer to CCA Message, Error Code
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendErrorMsg(const amt_tclServiceData* poMessage, tU16 errorcode)
{
        ETG_TRACE_USR4(("Sending Error %u...", errorcode));

        amt_tclServiceDataError oErrorMsg(*poMessage, errorcode);
        _poMainAppl->enPostMessage(&oErrorMsg, TRUE);

}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vTraceInputSourceRouteActivity(tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity)
*
* DESCRIPTION: Simulates SourceRouteActivity
*
* PARAMETER:   tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vTraceInputSourceRouteActivity(tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity, tU16 u16SubSource)
{
  (tVoid)u8Resource;

    tU8 u8CurSource = u8Source;
  tU8 u8PosNextSource = u8NextSource;
  tU16 u16SrcActivity = u8Activity;
  tU16 u16Resource = u8Resource;

  if(m_poResourceMgr != NULL)
  {
    m_poResourceMgr->vProcessSourceActivityRequest(u8CurSource,u8PosNextSource,u16SrcActivity, u16Resource, u16SubSource);
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: _poMainAppl = NULL"));
  }
}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetAppID()
*
* DESCRIPTION: Returns the TargetAppID of the client
*
* PARAMETER:   None.
*
* RETURNVALUE: tU16 m_u16TargetAppID.
*
**********************************************************************************************/
tU16 fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetAppID()
{
  return m_u16TargetAppID;
}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetRegisterID()
*
* DESCRIPTION: Returns the Register ID of the Client.
*
* PARAMETER:   None.
*
* RETURNVALUE: tU16 m_u16RegisterID.
*
**********************************************************************************************/
tU16 fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetRegisterID()
{
  return m_u16RegisterID;
}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetCmdCounter()
*
* DESCRIPTION: Returns CmdCounter of the Request.
*
* PARAMETER:   None.
*
* RETURNVALUE: tU16 m_u16CmdCounter.
*
**********************************************************************************************/
tU16 fc_audioroutemgr_tclService_AudioRouteMgr::u16GetTargetCmdCounter()
{
  return m_u16CmdCounter;
}
/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vTraceInputSourceRouteActivity(tU8 u8Source, tU8 u8NextSource, tU8 u8Resource, tU8 u8Activity)
*
* DESCRIPTION: Returns CmdCounter of the Request.
*
* PARAMETER:   None.
*
* RETURNVALUE: tU16 m_u16CmdCounter.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendStatusMessage(tU8 u8curSrc, tU8 u8posNextSrc, tU16 u16SubSource, tU8 u8Resource, tU8 u8Activity)
{
  m_u8CurSource = u8curSrc;
  m_u8PosNextSource = u8posNextSrc;
  m_u16SubSource = u16SubSource;
  m_u8Activity = u8Activity;
  m_u8Resource = u8Resource;

  midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus oSourceActivityStatus;
  oSourceActivityStatus.SourceRouteActivity.Source.enType = (midw_fi_tcl_e8_AudSource::tenType)u8curSrc;
  oSourceActivityStatus.SourceRouteActivity.PossibleNextSource.enType = (midw_fi_tcl_e8_AudSource::tenType)u8posNextSrc;
  oSourceActivityStatus.SourceRouteActivity.Resource.enType = (midw_fi_tcl_e8_ResourceNo::tenType)u8Resource;
  oSourceActivityStatus.SourceRouteActivity.Activity.enType = (midw_fi_tcl_e8_SrcActivity::tenType)u8Activity;
  oSourceActivityStatus.SourceRouteActivity.SubSource = u16SubSource;

  fi_tclVisitorMessage oCCaMsg(oSourceActivityStatus);

  if(_poMainAppl != NULL)
  {
   oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),  // Source AppID
               u16GetTargetAppID(),
               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
               0,
               u16GetTargetRegisterID(),
               u16GetTargetCmdCounter(),
               CCA_C_U16_SRV_AUDIO_ROUTE_MGR,
               MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY,
               AMT_C_U8_CCAMSG_OPCODE_STATUS
                );

    if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR4(("Sending Failed:SendSourceRouteActivityStatus"));
      NORMAL_M_ASSERT_ALWAYS();
      }
    else
      ETG_TRACE_USR4(("Sending SendSourceRouteActivityStatus Successful"));
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: _poMainAppl = NULL"));
    NORMAL_M_ASSERT_ALWAYS();
  }
  oSourceActivityStatus.vDestroy();
}
/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::updateClients(tU16 u16FunctionId)
*
* DESCRIPTION: Updates the status to registered clients.
*
* PARAMETER:   None.
*
* RETURNVALUE: ail_tenCommunicationError.
*
**********************************************************************************************/
ail_tenCommunicationError fc_audioroutemgr_tclService_AudioRouteMgr::updateClients(tU16 u16FunctionId)
{
   return eUpdateClients(u16FunctionId);
}

/********************************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclService_AudioRouteMgr::vSendErrorStatusMessage(tU8 Source, tU16 SubSource, tU16 Error)
*
* DESCRIPTION: Sends the Error Status Message to client.
*
* PARAMETER:   tU8 Source, tU16 SubSource, tU16 Error
*
* RETURNVALUE: None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclService_AudioRouteMgr::vSendErrorStatusMessage(tU8 Source, tU16 SubSource, tU16 Error)
{
  ETG_TRACE_USR4(("vSendErrorMessage() entered."));
  midw_audio_route_mgrfi_tclMsgP_SourceRouteActivityStatus oSrcActStatus;
  oSrcActStatus.SourceRouteActivity.Source.enType = (midw_fi_tcl_e8_AudSource::tenType)Source;
  oSrcActStatus.SourceRouteActivity.SubSource = SubSource;
  oSrcActStatus.ErrorCode = Error;

  ETG_TRACE_USR4(("vSendErrorMessage():Source=%d,SubSource=%d,Error=%d",oSrcActStatus.SourceRouteActivity.Source.enType,
    oSrcActStatus.SourceRouteActivity.SubSource,oSrcActStatus.ErrorCode));
  ETG_TRACE_USR4(("vSendErrorMessage():Post Message to Controller Plugin"));

  fi_tclVisitorMessage oCCaMsg(oSrcActStatus);

  if(_poMainAppl != NULL){                                // changes made
  oCCaMsg.vInitServiceData(_poMainAppl->u16GetAppId(),  // Source AppID
               u16GetTargetAppID(),
               AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
               0,
               u16GetTargetRegisterID(),
               u16GetTargetCmdCounter(),
               CCA_C_U16_SRV_AUDIO_ROUTE_MGR,
               MIDW_AUDIO_ROUTE_MGRFI_C_U16_P_SOURCEROUTEACTIVITY,
               AMT_C_U8_CCAMSG_OPCODE_STATUS
                );
  }

  if(_poMainAppl != NULL)
  {
    if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) !=  AIL_EN_N_NO_ERROR)
    {
      ETG_TRACE_USR4(("Sending Failed:SourceRouteActivityStatusError"));
      NORMAL_M_ASSERT_ALWAYS();
      }
    else
      ETG_TRACE_USR4(("Sending SourceRouteActivityStatusError Successful"));
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: _poMainAppl = NULL"));
    NORMAL_M_ASSERT_ALWAYS();
  }
  oSrcActStatus.vDestroy();
}
