/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_main.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA Application.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI.
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#include "fc_audioroutemgr_main.h"
#include "ResourceMgmt/fc_audioroutemgr_sourcefactory.h"
#include "ClientHandler/fc_audioroutemgr_clienthandler_audiofunc.h"
#include "ClientHandler/fc_audioroutemgr_clienthandler_srcroute.h"
#include "ClientHandler/fc_audioroutemgr_clienthandler_streamrouter.h"
#include "fc_audioroutemgr_service_audioroutemgr.h"
#include "ResourceMgmt/fc_audioroutemgr_audiosource.h"
#include "ResourceMgmt/fc_audioroutemgr_resourcemanager_interface.h"
#include "ResourceMgmt/fc_audioroutemgr_resourcemanager.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_STDVISITORS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO

#include "midw_fi_if.h"

#include "Trace/fc_audioroutemgr_trace.h"
#include "Trace/fc_audioroutemgr_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_APPLICATION
#include "trcGenProj/Header/fc_audioroutemgr_main.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

#define FC_AUDIOROUTEMGR_TIMER_ID 0

#define FC_AUDIOROUTEMGR_TIMER_TIME_UNTIL_FIRST_TICK 2000
#define FC_AUDIOROUTEMGR_TIMER_TICK_INTERVALL 2000

/******************************************************************************/
/*                                                                            */
/* GLOBAL VARIABLES                                                           */
/*                                                                            */
/******************************************************************************/

                      // Static self reference to be used in function callbacks.
fc_audioroutemgr_tclApp* fc_audioroutemgr_tclApp::m_poMainAppInstance = NULL;

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

fc_audioroutemgr_tclApp* fc_audioroutemgr_tclApp::theServer()
{
   if(m_poMainAppInstance == NULL)
   {
     m_poMainAppInstance = OSAL_NEW fc_audioroutemgr_tclApp();
   }
   return m_poMainAppInstance;
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclApp::fc_audioroutemgr_tclApp()
*
* DESCRIPTION: Constructor.
*
*              Initialize static self reference to be used in function
*              callbacks.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclApp::fc_audioroutemgr_tclApp():ahl_tclBaseOneThreadApp()
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclApp() entered."));

  m_poClientHandlerAudioRouteMgr_AudioFunc = NULL;
  m_poClientHandlerAudioRouteMgr_StreamRouter = NULL;
  m_poAudioRouteMgr = NULL;
  m_poResourceManager = NULL;
  m_posourcefactory = NULL;
  m_poTrace = NULL;
  fc_audioroutemgr_tclApp::m_poMainAppInstance = this;
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclApp::~fc_audioroutemgr_tclApp()
*
* DESCRIPTION: Destructor.
*
*              Invalidate static self reference.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclApp::~fc_audioroutemgr_tclApp()
{
  ETG_TRACE_USR4(("~fc_audioroutemgr_tclApp() entered."));

    m_poClientHandlerAudioRouteMgr_AudioFunc = NULL;
    m_poClientHandlerAudioRouteMgr_StreamRouter = NULL;
    m_poAudioRouteMgr = NULL;
    m_poResourceManager = NULL;
    m_posourcefactory = NULL;
    m_poTrace = NULL;
    fc_audioroutemgr_tclApp::m_poMainAppInstance = NULL;
}

/*******************************************************************************
*
* FUNCTION: tBool fc_audioroutemgr_tclApp::bOnInit()
*
* DESCRIPTION: This function is called by the CCA framework before starting any
*              CCA message related communication action. As default this
*              function always returns TRUE. The user has to implement all his
*              local application initialization (create client and service
*              handler, create worker threads, allocate application memory,...).
*              If returns TRUE, initialization could be successfully performed
*              and framework will register application, else, a reset of the
*              system is forced immediately.
*
*              This function is the counterpart of vOnApplicationClose().
*
* PARAMETER: None.
*
* RETURNVALUE: TRUE  = Application successfully initialized.
*              FALSE = Application NOT successfully initialized.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::bOnInit().
*******************************************************************************/
tBool fc_audioroutemgr_tclApp::bOnInit()
{
  tBool bSuccess = TRUE;

  ETG_TRACE_USR4(("bOnInit() entered."));

  m_posourcefactory = OSAL_NEW fc_audioroutemgr_tclsourcefactory(this);

  if(NULL==m_posourcefactory)
  {
  ETG_TRACE_USR4(("Source factory not instantiated"));
  bSuccess = FALSE;
  FATAL_M_ASSERT_ALWAYS();
  }

  m_poResourceManager = OSAL_NEW fc_audioroutemgr_tclresourcemanager(this,m_posourcefactory);

  if(NULL==m_poResourceManager)
  {
    ETG_TRACE_USR4(("Resource manager not instantiated"));
   bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_poAudioRouteMgr = OSAL_NEW fc_audioroutemgr_tclService_AudioRouteMgr(this,m_poResourceManager, m_posourcefactory);

  if (NULL == m_poAudioRouteMgr)
  {
  ETG_TRACE_USR4(("Service Route manager not instantiated"));
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_poClientHandlerAudioRouteMgr_AudioFunc = OSAL_NEW fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(this,m_poResourceManager);

  if (NULL == m_poClientHandlerAudioRouteMgr_AudioFunc)
  {
  ETG_TRACE_USR4(("AudioFunc Client Handler not instantiated"));
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  m_poClientHandlerAudioRouteMgr_StreamRouter = OSAL_NEW fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(this,m_poResourceManager);

  if (NULL == m_poClientHandlerAudioRouteMgr_StreamRouter)
  {
  ETG_TRACE_USR4(("StreamRouter Client Handler not instantiated"));
    bSuccess = FALSE;
    FATAL_M_ASSERT_ALWAYS();
  }

  //initializing the trace class to communicate with TTFis

  m_poTrace = OSAL_NEW fc_audioroutemgr_tclTraceChannel();

  if(NULL == m_poTrace)
  {
    ETG_TRACE_USR4(("fc_audioroutemgr_tclTraceChannel not instantiated"));
    bSuccess = FALSE;
  }
  // register after instantiation of objects being registered for trace inputs!!!
  if(bSuccess)
  {
     vRegisterTraceInputs();
  }


  return bSuccess;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vAudioManagerAvailable()
*
* DESCRIPTION: This function informs the own service about availability of
*              another service. We want to make the own service dependent on another service.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vAudioManagerAvailable()
{
  // make own service available
  if(m_poAudioRouteMgr != NULL)
  {
    m_poAudioRouteMgr->vAudioManagerAvailable();
  }
  else
  {
    //FATAL if pointer to own service is not available
    ETG_TRACE_ERR(("m_poAudioRouteMgr is NULL"));
  }

}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vOnApplicationClose()
*
* DESCRIPTION: This function is called by the CCA framework to indicate the
*              imminent shutdown of the application. The user has to implement
*              the de-initialization of all his local application data (destroy
*              client and service handler, destroy worker threads, free
*              application memory, ... ). After this function call the
*              destructor of this application will be called.
*
*              This function is the counterpart of bOnInit().
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnApplicationClose().
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnApplicationClose()
{
  ETG_TRACE_USR4(("vOnApplicationClose() entered."));

  bStopTimer(FC_AUDIOROUTEMGR_TIMER_ID);

  try
  {

    if (m_poClientHandlerAudioRouteMgr_AudioFunc != NULL)
    {
      OSAL_DELETE m_poClientHandlerAudioRouteMgr_AudioFunc;
      m_poClientHandlerAudioRouteMgr_AudioFunc = NULL;
    }

  if (m_poClientHandlerAudioRouteMgr_StreamRouter != NULL)
    {
      OSAL_DELETE m_poClientHandlerAudioRouteMgr_StreamRouter;
      m_poClientHandlerAudioRouteMgr_StreamRouter = NULL;
    }

    if (m_poAudioRouteMgr != NULL)
    {
      OSAL_DELETE m_poAudioRouteMgr;
      m_poAudioRouteMgr = NULL;
    }

    if (m_poTrace != NULL)
    {
       OSAL_DELETE m_poTrace;
       m_poTrace = NULL;
    }

    if (m_posourcefactory != NULL)
    {
       OSAL_DELETE m_posourcefactory;
       m_posourcefactory = NULL;
    }

  }
  catch (...)
  { }

  ahl_tclBaseOneThreadApp::vOnApplicationClose();
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vOnLoadSettings()
*
* DESCRIPTION: This function is called by the CCA framework to trigger the
*              loading of last mode settings. The user has to load the
*              previously stored last mode settings from persistent memory.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoadSettings().
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnLoadSettings()
{
  ETG_TRACE_USR4(("vOnLoadSettings() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vOnSaveSettings()
*
* DESCRIPTION: This function is called by the CCA framework to trigger the
*              storage of last mode settings. The user has to store the last
*              mode settings to persistent memory.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnSaveSettings().
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnSaveSettings()
{
  ETG_TRACE_USR4(("vOnSaveSettings() entered."));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vOnTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called by the CCA framework on the expiration
*              of a previously via function bStartTimer() started timer. The
*              expired timer is forwarded to the respective service or
*              client-handler via a call of vProcessTimer().
*
*              The function is called from this applications context and
*              therefore no interthread programming rules must be considered
*              and the application methods and/or member variables can be
*              accessed without using the static self reference
*              'm_poMainAppInstance'.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnTimer().
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnTimer(tU16 u16TimerId)
{
  ETG_TRACE_USR4(("vOnTimer() entered."));

  switch(u16TimerId)
  {
    case FC_AUDIOROUTEMGR_TIMER_ID:
    {

      if (NULL != m_poAudioRouteMgr)
      {
        m_poAudioRouteMgr->vProcessTimer(u16TimerId);
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }

      if (NULL != m_poClientHandlerAudioRouteMgr_AudioFunc)
      {
        m_poClientHandlerAudioRouteMgr_AudioFunc->vProcessTimer(u16TimerId);
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }

    if (NULL != m_poClientHandlerAudioRouteMgr_StreamRouter)
      {
        m_poClientHandlerAudioRouteMgr_StreamRouter->vProcessTimer(u16TimerId);
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }

    }
    break;

    default:
    {
    }
  }
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclApp::vOnLoopback
*                 (tU16 u16ServiceID, amt_tclServiceData* poMessage)
*
* DESCRIPTION: This function is called by the CCA framework if a message was
*              sent from one if this applications services or from a
*              callback-handler of this application (so called self or loopback
*              messages). The message can be forwarded to the respective service
*              via a call of vOnLoopbackService(). If there is no service
*              registered for this message then the user has the option to
*              directly evaluate the message in the default block of this.
*              methods switch-clause.
*
* PARAMETER: [IN] u16ServiceID = Identifier of the service from where the
*                                message was sent.
*
*            [IN] poMessage = Message object.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadApp::vOnLoopback().
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnLoopback
      (tU16 u16ServiceID, amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("vOnLoopback() entered."));

  switch(u16ServiceID)
  {
    case CCA_C_U16_SRV_AUDIO_ROUTE_MGR:
    {
      if(NULL != m_poAudioRouteMgr)
      {
        m_poAudioRouteMgr->vOnLoopbackService(poMessage);
      }
      else
      {
        NORMAL_M_ASSERT_ALWAYS();
      }
    }
    break;

    default:
    {
      // Evaluate your none service related loopback messages here.
    }
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vRegisterTraceInputs(tVoid)
*
*
* DESCRIPTION: Register Trace Inputs
*
* PARAMETER:   None
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vRegisterTraceInputs(tVoid)
{
   ETG_TRACE_USR4(("vRegisterTraceInputs() entered."));

   if(m_poTrace) {
      m_poTrace->vRegisterTraceCallBack((TR_tenTraceChan)TR_TTFIS_AUDIO_ROUTER_MGMT);
      //daw2hi: ToDo Trace macros missing

      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclApp), this);
      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclClientHandleraudiofunc), m_poClientHandlerAudioRouteMgr_AudioFunc);
      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclClientHandlerstreamrouter), m_poClientHandlerAudioRouteMgr_StreamRouter);

      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclSourceFactory), m_posourcefactory);
      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclResourceManager), m_poResourceManager);
      m_poTrace->vRegisterTraceService(static_cast<tU32>(TRC::tclService), m_poAudioRouteMgr);
      /* +++
      add more classes using the trace input interface here
      +++ */
   }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vTraceRx(tPCUChar pcu8Data)
*
*
* DESCRIPTION: Receives TTFis Commands.
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclApp::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTraceRx() entered."));

   if(pcu8Data == OSAL_NULL) return;
   // pcu8Data[0] == my file number
   // pcu8Data[1] == the command
   // pcu8Data[2] == the 1. parameter
   // rest is defined here

   ETG_TRACE_USR4(("vTraceRx() size=%u",size));
   if (size > 1)
   {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
      switch ( pcu8Data[1] )
      {
      case 1:
         ETG_TRACE_USR4(("Received 1"));
         break;

      default:
        ETG_TRACE_USR4(("default"));
         break;
      }
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetResourceManager()
*
*
* DESCRIPTION: Returns pointer to Resource Manager
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclresourcemanager - Pointer to Resource Manager
*
*******************************************************************************/

fc_audioroutemgr_tclresourcemanager* fc_audioroutemgr_tclApp::poGetResourceManager()
{
  return this->m_poResourceManager;
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetSourceFactory()
*
*
* DESCRIPTION: Returns pointer to Source Factory
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclsourcefactory - Pointer to Source Factory
*
*******************************************************************************/
fc_audioroutemgr_tclsourcefactory* fc_audioroutemgr_tclApp::poGetSourceFactory()
{
  return this->m_posourcefactory;
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetAudioFuncClientHandler()
*
*
* DESCRIPTION: Returns pointer to Audio Func Client Handler
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc
*                      - Pointer to Audio Func Client Handler
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc* fc_audioroutemgr_tclApp::poGetAudioFuncClientHandler()
{
  return this->m_poClientHandlerAudioRouteMgr_AudioFunc;
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetAudioRouteMgrServiceHandler()
*
*
* DESCRIPTION: Returns pointer to AudioRouteMgr Service Handler
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclService_AudioRouteMgr
*                       - Pointer to AudioRouteMgr Service Handler
*
*******************************************************************************/
fc_audioroutemgr_tclService_AudioRouteMgr* fc_audioroutemgr_tclApp::poGetAudioRouteMgrServiceHandler(tVoid)
{
  return this->m_poAudioRouteMgr;
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetStreamRouterClientHandler()
*
*
* DESCRIPTION: Returns pointer to Stream Router Client Handler
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter
*                            - Pointer to Stream Router Client Handler
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter* fc_audioroutemgr_tclApp::poGetStreamRouterClientHandler(tVoid)
{
  return this->m_poClientHandlerAudioRouteMgr_StreamRouter;
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclApp::vGetMediaPlayerClientHandler() (REMOVED NOW)
*
*
* DESCRIPTION: Returns pointer to Media Player Client Handler
*
* PARAMETER:   None
*
* RETURNVALUE: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_MediaPlayer
*                           - Pointer to Media Player Client Handler


*
*******************************************************************************/


/********************************************************************************************
*
* FUNCTION:     fc_audioroutemgr_tclService_AudioRouteMgr::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
*
* DESCRIPTION:  This function is called from the framework to inform the derived
*               real application that a power state change message is received
*               from the SPM and will now be answered.
*
* PARAMETER:    tU32 u32OldAppState, tU32 u32AppState
*
* RETURNVALUE:  None.
*
**********************************************************************************************/
tVoid fc_audioroutemgr_tclApp::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclApp::vOnNewAppStateNotify() entered"));
   if (u32OldAppState != u32AppState)
   {
    ETG_TRACE_USR4(("fc_audioroutemgr_tclApp::u32AppState =%d",u32AppState));
       switch(u32AppState)
       {
           case AMT_C_U32_STATE_NORMAL:
           case AMT_C_U32_STATE_DIAGNOSIS:
           case AMT_C_U32_STATE_PAUSE:
           break;
           case AMT_C_U32_STATE_OFF:
           {
             if(poGetResourceManager() != OSAL_NULL)
             {
               poGetResourceManager()->postateControllerEnt->vResetState(stateController::DEALLOCATED);
               poGetResourceManager()->postateControllerMix->vResetState(stateController::DEALLOCATED);
         poGetResourceManager()->postateControllerMix2->vResetState(stateController::DEALLOCATED);

         //vdu1kor - fix issue (SUZUKI-22943)
         poGetResourceManager()->postateControllerEnt->vResetDQueueSrcActivityCall();
         poGetResourceManager()->postateControllerMix->vResetDQueueSrcActivityCall();
         poGetResourceManager()->postateControllerMix2->vResetDQueueSrcActivityCall();

         poGetAudioFuncClientHandler()->vPerformMuteRampOnAppStateChange();
         poGetAudioFuncClientHandler()->vPerformMuteOnAppStateChange();

             }
           }
           break;

           default:
           break;
       }
   }
   else
   {
       // switching to the same state
       // then we don't care
   }
}

