#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_audioroutemgr_trace.h"
#include "fc_audioroutemgr_trace_input.h"
#include "fc_audioroutemgr_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_TRACE
#include "trcGenProj/Header/fc_audioroutemgr_trace.cpp.trc.h"
#endif

// -- trace identifier ------- define this value for every class new

// -- trace identifier ------- define this value for every file new

// -- trace identifier ------- end

OSAL_tIODescriptor fc_audioroutemgr_tclTraceChannel::_fdTrace = OSAL_ERROR;
fc_audioroutemgr_tclTraceInput* fc_audioroutemgr_tclTraceChannel::_paReceiver[TRC::TRC_MAX_CLASS_NAMES];

/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : constructor
 * DESCRIPTION : initialization to no action
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       : -
 *******************************************************FunctionHeaderEnd******/
fc_audioroutemgr_tclTraceChannel::fc_audioroutemgr_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("fc_audioroutemgr_tclTraceChannel entered."));

   _eChannel = NO_CHAN_SELECTED;
   // check if channel was opened already by another instance
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();
   }
   _fdTrace = OSAL_ERROR;
   for (tInt i = 0; i < (tInt)TRC::TRC_MAX_CLASS_NAMES; i++)
   {
      _paReceiver[i] =0;
   }
}
/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : Destructor
 * DESCRIPTION : initialization to no action
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       : -
 *******************************************************FunctionHeaderEnd******/
fc_audioroutemgr_tclTraceChannel::~fc_audioroutemgr_tclTraceChannel(tVoid)
{
   ETG_TRACE_USR4(("~fc_audioroutemgr_tclTraceChannel entered."));
   if(_fdTrace != OSAL_ERROR)
   {
      vUnregisterTraceCallBack();//lint !e1551 prio3 reviewed: the macro TRACE_FLOW_DEF in this function cannot throw an exception
   }
   _fdTrace = OSAL_ERROR;
}

tVoid  fc_audioroutemgr_tclTraceChannel::vTrace_Rx_Callback (tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTrace_Rx_Callback entered. Redirecting to vTrace_Rx()."));
   vTrace_Rx(pcu8Data[0], &pcu8Data[1]);
}


/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : vTrace_Rx
 * DESCRIPTION : handles received messages from TTFIS
 * SYNTAX      : tVoid vdclk_Trace_vRx( tU8* pu8Data )
 * ARGUMENTS   : -
 *               pu8Data
 * RETURN VALUE: -
 *               none
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid  fc_audioroutemgr_tclTraceChannel::vTrace_Rx (tU32 size, tPCUChar pcu8Data)
{
   ETG_TRACE_USR4(("vTrace_Rx entered."));
   if(pcu8Data==0) return;

   if ( size > 0 )
   {
      // the router forwards the message to that call backs as defined by tclApp
      if(_paReceiver[pcu8Data[0]])
      {
         _paReceiver[pcu8Data[0]]->vTraceRx(size, pcu8Data);
      } else
      {
       ETG_TRACE_USR4(("vRegisterTraceService Trace Channel this service is not initialized."));
         //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel this service is not initialized", pcu8Data[2]);
      }
   } else
   {
      ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service number unknown."));
      //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel service number unknown", pcu8Data[2]);
   }
   return;
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : vRegisterTraceService
 * DESCRIPTION : adds the given trace input interface into the function array
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid fc_audioroutemgr_tclTraceChannel::vRegisterTraceService(tU32 uInputNum,
                                                  fc_audioroutemgr_tclTraceInput* pclInput) const
{
   ETG_TRACE_USR4(("vRegisterTraceService entered."));
   if(uInputNum < sizeof(_paReceiver)/sizeof(_paReceiver[0]))
   {
      _paReceiver[uInputNum] = pclInput;
    ETG_TRACE_USR4(("vRegisterTraceService Trace Channel service registered for :%u",uInputNum));
    //TRACE_DBG_LSN(TRC::FnTraceRx, TR_LEVEL_SYSTEM, "Trace Channel service registered for :", uInputNum);
   }
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : vRegisterTraceCallBack
 * DESCRIPTION : register the call back function at the OSAL trace interface
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid fc_audioroutemgr_tclTraceChannel::vRegisterTraceCallBack(TR_tenTraceChan eChan)
{
   ETG_TRACE_USR4(("vRegisterTraceCallBack entered."));
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;
   _eChannel = eChan;

   tVoid (*pCallbackFunction)(tPCUChar);
   pCallbackFunction = vTrace_Rx_Callback; // To ensure function pointer type safety

   oTraceChannel.enTraceChannel = _eChannel;
   oTraceChannel.pCallback = (
       OSAL_tpfCallback)pCallbackFunction;
   _fdTrace = OSAL_IOOpen( OSAL_C_STRING_DEVICE_TRACE, OSAL_EN_READWRITE );

   if(_fdTrace != OSAL_ERROR) {
      s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_REG, (intptr_t)&oTraceChannel );
   }
   if( OSAL_OK != s32Error )
   {
      ETG_TRACE_ERR(("vRegisterTraceCallBack ErrCouldntRegisterTraceChannel."));
      //TRACE_ERROR( TRC::FnTraceRx, TRC::ErrCouldntRegisterTraceChannel);
   }
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : fc_audioroutemgr_tclTraceChannel
 * FUNCTION    : vUnregisterTraceCallBack
 * DESCRIPTION : unregister the call back at trace interface
 * ARGUMENTS   : -
 * RETURN VALUE: -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tVoid fc_audioroutemgr_tclTraceChannel::vUnregisterTraceCallBack(tVoid) const
{
   ETG_TRACE_USR4(("vUnregisterTraceCallBack entered."));
   tS32 s32Error = OSAL_ERROR;
   OSAL_trIOCtrlLaunchChannel  oTraceChannel;

   tVoid (*pCallbackFunction)(tPCUChar);
   pCallbackFunction = vTrace_Rx_Callback; // To ensure function pointer type safety

   oTraceChannel.enTraceChannel = _eChannel;
   oTraceChannel.pCallback = (OSAL_tpfCallback)pCallbackFunction;

   if(_fdTrace != OSAL_ERROR)
   {
      s32Error = OSAL_s32IOControl( _fdTrace, OSAL_C_S32_IOCTRL_CALLBACK_UNREG, (intptr_t)&oTraceChannel );
   }
   if( OSAL_OK != s32Error )
   {
      ETG_TRACE_ERR(("vUnregisterTraceCallBack ErrCouldntUnregisterTraceChannel."));
      //TRACE_ERROR( TRC::FnTraceRx, TRC::ErrCouldntUnregisterTraceChannel);
   }
   OSAL_s32IOClose( _fdTrace );
}
