/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_sourcefactory.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Source Factory Class
*
* AUTHOR:     Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_SOURCEFACTORY_H
#define _FC_AUDIOROUTEMGR_SOURCEFACTORY_H

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

#include <vector>


using namespace std;

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES

/* Include server interface */
#include "midw_fi_if.h"
#include "../fc_audioroutemgr_main.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_srcroute.h"
#include "FC_StreamRouter_ucid_defs.h"

#define   UCID_DUMMY    0x0000
#define   APPID_DUMMY   0xFFFF

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class source;

struct tsSrcAvailability
{
    tU16 SubSource;
    tU8 SrcAvailability;
    tU8 SrcAvailReason;
};

class fc_audioroutemgr_tclsourcefactory:public fc_audioroutemgr_tclTraceInput
{
  public:
  //Constructor
  fc_audioroutemgr_tclsourcefactory(fc_audioroutemgr_tclApp* pCcaMainApp);

  //Destructor
  virtual ~ fc_audioroutemgr_tclsourcefactory()
  {
    m_poCcaMainApp = NULL;
  }

  virtual fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute* getClientHandler(tU16 u16AppID);
  tVoid vSendReqRouteList(std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> >&);
  tVoid vSendSrcAvailabilityList(std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> >&);
  std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> > vReqRouteList();
  std::vector<midw_fi_tcl_SourceAvailablityItem, std::allocator<midw_fi_tcl_SourceAvailablityItem> > vSrcAvailabilityList();
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
  vector<source*> sourceVector;
  vector<fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute*> clientHandlerVector;
  source* poSourcePtr(tU8 Src);

  source* poGetSource(tU8 SourceID); //ToDo: daw2hi: this seems to be obsolete was added above
  tBool bAddSinkToSource(tU8 CurSrc, tU16 Sink);
  tBool bRemoveSinkFromSource(tU8 CurSrc, tU16 Sink);
  private:

  multimap< tU8, tsSrcAvailability > m_SrcAvailMap;
  fc_audioroutemgr_tclApp* m_poCcaMainApp;
  std::vector<midw_fi_tcl_RequestAudioRouteItem, std::allocator<midw_fi_tcl_RequestAudioRouteItem> > m_ReqAudRouteList;

  tVoid vInsertItemsToSrcAvailMap(tU8 Src, tsSrcAvailability availability);
  tVoid vCreateNormalSourceInstances(fc_audioroutemgr_tclApp* pCcaMainApp);
};

#endif
