/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_resourcemanager_interface.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Resource Manager Interface Class
*
* AUTHOR:     Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#ifndef FC_AUDIOROUTEMGR_RESOURCEMANAGER_INTERFACE_H
# define FC_AUDIOROUTEMGR_RESOURCEMANAGER_INTERFACE_H
#include "system_types.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                          */
/*                                                                            */
/******************************************************************************/


class resourcemanager_interface
{
  public:

  virtual ~resourcemanager_interface(){}

  virtual tVoid vNotifyAllocate(tU8 CurSrc, tU16 SubSource) = 0;
  virtual tVoid vNotifyDeAllocate(tU8 CurSrc, tU16 SubSource) = 0;
  virtual tVoid vNotifyAllocateRoute(tU16 u16UCID) = 0;
  virtual tVoid vNotifySetPlay(tU16 u16UCID) = 0;
  virtual tVoid vNotifySetStop(tU16 u16UCID) = 0;
  virtual tVoid vNotifyDeAllocateRoute(tU16 u16UCID) = 0;
  virtual tVoid vNotifyMute(tU8 Source,tU16 SubSource, tU8 Mute_State, tU8 Channel,tU16 Resource) = 0;
  virtual tVoid vNotifySourceActivity(tU8 Source, tU16 SrcActivity, tU16 SubSource) = 0;

};

#endif
