/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_resourcemanager.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Resource Manager Class
*
* AUTHOR:    Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/
#ifndef _FC_AUDIOROUTEMGR_RESOURCEMANAGER_H
#define _FC_AUDIOROUTEMGR_RESOURCEMANAGER_H
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_audioroutemgr_resourcemanager_interface.h"
#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_audiosource.h"
#include "fc_audioroutemgr_sourcefactory.h"
#include "fc_audioroutemgr_statecontroller.h"
#include "fc_audioroutemgr_statecontrol.h"

class stateController;
class stateControl;
class source;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION--- Resource Manager                                       */
/*                                                                            */
/******************************************************************************/

class fc_audioroutemgr_tclresourcemanager: public resourcemanager_interface, public fc_audioroutemgr_tclTraceInput
{
  public:

  //Constructor
  fc_audioroutemgr_tclresourcemanager(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclsourcefactory* poSourceFactory);

  fc_audioroutemgr_tclresourcemanager& operator= (const fc_audioroutemgr_tclresourcemanager &oResMgr);
  fc_audioroutemgr_tclresourcemanager(const fc_audioroutemgr_tclresourcemanager &oResMgr);

  //Destructor
  virtual ~ fc_audioroutemgr_tclresourcemanager()
  {
    m_poSourceFactory = OSAL_NULL;
    m_poCcaMainApp = OSAL_NULL;
    postateController= OSAL_NULL;

    delete postateControllerEnt;
    postateControllerEnt= OSAL_NULL;

    delete postateControllerMix;
    postateControllerMix= OSAL_NULL;

    delete postateControllerMix2;
    postateControllerMix2 = OSAL_NULL;

    delete postateControllerMix3;
    postateControllerMix3 = OSAL_NULL;

  }

/***************************************************************************
        * Interfaces Implementation
 ***************************************************************************/
  virtual tVoid vNotifyAllocate(tU8 CurSrc, tU16 SubSource=0);
  virtual tVoid vNotifyDeAllocate(tU8 CurSrc, tU16 SubSource=0);
  virtual tVoid vNotifyAllocateRoute(tU16 u16UCID);
  virtual tVoid vNotifyDeAllocateRoute(tU16 u16UCID);
  virtual tVoid vNotifySetPlay(tU16 u16UCID);
  virtual tVoid vNotifySetStop(tU16 u16UCID);
  virtual tVoid vNotifyMute(tU8 Source,tU16 Subsource, tU8 Mute_State, tU8 Channel,tU16 Resource = 1);
  virtual tVoid vNotifySourceActivity(tU8 Source, tU16 SrcActivity, tU16 SubSource=0);

  virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
  virtual tVoid vGetSnapshot(tVoid);

  tVoid vProcessSourceActivityRequest(tU8 Src,tU8 PosNxtSrc,tU16 Activity,tU16 Resource,tU16 SubSrc);
  tU8  u8GetCurSrcinSM(tU8 Stream) const;
  tU8  u8GetNextSrcinSM(tU8 Stream) const;
  tU16 u16getSourceActivityStatus() const;
  tU8  u8UCIDtoSource(tU16 UCID);
  std::vector<tU8> u8UCIDtoSourceAll(tU16 UCID);

  tBool bCheckValidSrcState(tU8 src, stateController::enEvent event);
  tVoid vNotifySourceState(tU8 Src, tU8 state);
  tVoid vCalltoChangeState(SrcActivityCall);
  tVoid vCheckIfReqAlreadyInQueueForSrc(tU8 Src);
  tVoid vProcessOffRequestIfReqSameSrc(SrcActivityCall);
  stateController* poselStateController(tU8 Source);
  tBool bAddSinkToSource(tU8 CurSrc, tU16 Sink);
  tBool bRemoveSinkFromSource(tU8 CurSrc, tU16 Sink);
  tBool bIsSinkVectorEmpty(tU8 CurSrc);
  tBool bIsSourceAllocated(tU8 CurSrc);
  tVoid vSendAmpDeviceAudioRoute(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink);
  tVoid vNotifyAmpDevAudioRouteResult(tU8 CurSrc, tU16 SubSource, tU16 Sink, tU16 handle);

    stateController *postateControllerEnt;
    stateController *postateControllerMix;
  stateController *postateControllerMix2;
  //for permanent microphone
  stateController *postateControllerMix3;

  stateController *postateController;

  private:

  stateController* pGetStateControllerPtrFromUCID(tU16 UCID);
  fc_audioroutemgr_tclsourcefactory* m_poSourceFactory;
  fc_audioroutemgr_tclApp* m_poCcaMainApp;

};

#endif
