/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_audiosource.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   Audio Sources Class
*
* AUTHOR:     Vaijayanti Vadiraj (RBEI/ECV4), Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#include "fc_audioroutemgr_audiosource.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_srcroute.h"
#include "../ClientHandler/fc_audioroutemgr_clienthandler_streamrouter.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_SOURCEFACTORY
#include "trcGenProj/Header/fc_audioroutemgr_audiosource.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/


/*******************************************************************************
*
* FUNCTION:    source::source(tU16 src, tU16 ramp, tBool mutereq, tU16 muteState, tU16 srcState, tU16 RtIf)
*
*
* DESCRIPTION: Constructor.
*
* PARAMETER:   Source, m_u16MuteRamp, MuteRequest, m_enMuteState, SourceState, RoutingInterface
*
* RETURNVALUE: None.
*
*******************************************************************************/
source::source(tU8 src, tU8 supportedstream, tU16 ramp, tBool mutereq, source::enSrcMuteState muteState, source::enSrcState srcState, tU16 RtIf,tU16 ucid, tU16 appid, tU16 srcactivity, tU8 reason, source::enSrcMuteState srcchngmutestate, tU16 subsrc, tU8 srcavailability, tU8 srcavailreason, enVolumeLockType vollocktype, fc_audioroutemgr_tclApp* poCcaMainApp)
:m_u8SrcID(src), m_u8StreamSupported(supportedstream), m_u16MuteRamp(ramp), m_bMuteReq(mutereq), m_enMuteState(muteState), m_enSrcState(srcState), m_u16RoutingIf(RtIf), m_u16SrcUCID(ucid), m_u16AppID(appid), m_u16SrcActivity(srcactivity), m_u8Reason(reason), m_enSrcChngMuteState(srcchngmutestate), m_u16SubSrc(subsrc), m_u8SrcAvailability(srcavailability), m_u8SrcAvailReason(srcavailreason),m_enVolLockType(vollocktype), m_poCcaMainApp(poCcaMainApp)
{
}

/*******************************************************************************
*
* FUNCTION:    source::~source(tVoid)
*
*
* DESCRIPTION: Destructor.
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
source::~source()
{
  m_poCcaMainApp = OSAL_NULL;
}

std::vector<tU16> source::getSinkList()
{
  return m_Sinks;
}
tBool source::bAddSink(tU16 Sink)
{
  tBool bFound = false;
  vector<tU16>::const_iterator it;
  for(it=m_Sinks.begin(); it!= m_Sinks.end(); ++it)
  {
    if(*it== Sink)
    {
      ETG_TRACE_USR4(("Source %d bAddSink %d already connected",m_u8SrcID,Sink));
      bFound=true;
      break;
    }
  }
  if(!bFound)
  {
    m_Sinks.push_back(Sink);
    ETG_TRACE_USR4(("Source %d bAddSink %d done",m_u8SrcID,Sink));
  }
  return !bFound;
}
tBool source::bRemoveSink(tU16 Sink)
{
  vector<tU16>::iterator it;
  tBool bSuccess = false;
  for(it = m_Sinks.begin(); it!= m_Sinks.end(); ++it)
  {
    if(*it == Sink)
    {
      m_Sinks.erase(it);
      bSuccess=true;
      break;
    }
  }
  return bSuccess;
}
tBool source::bIsSinkVectorEmpty()
{
  if(m_Sinks.size() == 0) return true;
  else return false;
}
tU32 source::pGetNumberOfSinks()
{
    return static_cast<tU32>(m_Sinks.size());
}
/************************************************************************************
*
* FUNCTION:     tVoid source::vSendAllocate(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION:  Calls Corresponding CCA to allocate stream based on stream routing or src_route_fi
*
* PARAMETER:    Current Source, possible Next Source
*
* RETURNVALUE:  None.
*
**************************************************************************************/

tVoid source::vSendAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("vSendAllocate set Sink to 1"));
  vSendAllocate(CurSrc, PosNextSrc, SubSource, 1);
}
tVoid source::vSendAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource, tU16 Sink)
{
  ETG_TRACE_USR4(("Inside vSendAllocate CurSrc %d, POsNextSrc %d, Sink %d",CurSrc, PosNextSrc, Sink));

    if(pogetClientHandler() != OSAL_NULL)
    {
    pogetClientHandler()->vPerformAllocate(CurSrc, PosNextSrc, SubSource, Sink);
    }
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSendDeAllocate(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION:  Calls Corresponding CCA to Deallocate stream based on stream routing or src_route_fi
*
* PARAMETER:    Current Source, possible Next Source
*
* RETURNVALUE:  None.
*
**************************************************************************************/

tVoid source::vSendDeAllocate(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Inside vSendDeAllocate"));

    if(pogetClientHandler() != OSAL_NULL)
    {
      pogetClientHandler()->vPerformDeAllocate(CurSrc, PosNextSrc, SubSource);
    }
}
/************************************************************************************
*
* FUNCTION:     tVoid source::vSrcActOff(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION:  Calls Corresponding CCA to perform Sourceactivity off
*                     or SetStop based on stream routing fi or src_route_fi
*
* PARAMETER:    Current Source, possible Next Source
*
* RETURNVALUE:  None.
*
**************************************************************************************/

tVoid source::vSrcActOff(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Inside vSrcActOff"));

  if(pogetClientHandler() != OSAL_NULL)
  {
    pogetClientHandler()->vPerformStop(CurSrc, PosNextSrc, SubSource);
  }
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSrcActPause(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION:  Calls Corresponding CCA to perform Sourceactivity off
*                     or SetStop based on stream routing fi or src_route_fi
*
* PARAMETER:    Current Source, possible Next Source
*
* RETURNVALUE:  None.
*
**************************************************************************************/

tVoid source::vSrcActPause(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Inside vSrcActPause"));
  if(pogetClientHandler() != OSAL_NULL)
  {
    pogetClientHandler()->vPerformPause(CurSrc, PosNextSrc, SubSource);
  }
}
/************************************************************************************
*
* FUNCTION:     tVoid source::vSendDeAllocate(tU8 CurSrc, tU8 PosNextSrc)
*
*
* DESCRIPTION:  Calls Corresponding CCA to perform SourceActivity On
*           or SetPlay based on stream routing or src_route_fi
*
* PARAMETER:    Current Source, possible Next Source
*
* RETURNVALUE:  None.
*
**************************************************************************************/

tVoid source::vSrcActOn(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Inside vSrcActOn CurSrc %d",CurSrc));
  if(pogetClientHandler() != OSAL_NULL)
  {
    pogetClientHandler()->vPerformPlay(CurSrc, PosNextSrc, SubSource);
  }
}

/************************************************************************************
*
* FUNCTION:     tU16 source::u16GetMuteRamp(tVoid)
*
*
* DESCRIPTION:  Returns the m_u16MuteRamp for Possible Next Source
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*
**************************************************************************************/

tU16 source::u16GetMuteRamp(tVoid) const
{
  ETG_TRACE_USR4(("Inside u16GetMuteRamp"));
  return m_u16MuteRamp;
}

/************************************************************************************
*
* FUNCTION:     tU8 source::u8GetSourceSupportedStream(tVoid) const
*
*
* DESCRIPTION:  Returns the Supported Stream for the Source
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8 SourceType
*
**************************************************************************************/

tU8 source::u8GetSourceSupportedStream(tVoid) const
{
  ETG_TRACE_USR4(("u8GetSourceSupportedStream"));
  return m_u8StreamSupported;
}

/************************************************************************************
*
* FUNCTION:     tU16 source::u16GetUCID(tVoid)
*
*
* DESCRIPTION:  Returns the corresponding AudioManager source number.
*
* PARAMETER:    None
*
* RETURNVALUE:  m_u16SrcUCID
*
**************************************************************************************/
tU16 source::u16GetUCID(tVoid) const
{
  ETG_TRACE_USR4(("Inside u16GetUCID return UCID %d",m_u16SrcUCID));
  return m_u16SrcUCID;
}
/************************************************************************************
*
* FUNCTION:     tU16 source::u16GetAppID(tVoid)
*
*
* DESCRIPTION:  Returns the corresponding Application IDs of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  m_u16AppID
*
**************************************************************************************/
tU16 source::u16GetAppID(tVoid) const
{
  ETG_TRACE_USR4(("Inside u16GetAppID"));
  return m_u16AppID;
}

/************************************************************************************
*
* FUNCTION:     tU16 source::u16GetRoutingIf(tVoid)
*
*
* DESCRIPTION:  Returns the corresponding RoutingIFs of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  RoutingIF
*
**************************************************************************************/
tU16 source::u16GetRoutingIf(tVoid) const
{
  ETG_TRACE_USR4(("Inside u16GetRoutingIf"));
  return m_u16RoutingIf;
}
/************************************************************************************
*
* FUNCTION:     tU8 source::u8GetSourceID(tVoid)
*
* DESCRIPTION:  Returns the corresponding sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  RoutingIF
*
**************************************************************************************/
tU8 source::u8GetSourceID() const
{
  return m_u8SrcID;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSetState(enSrcState state)
*
* DESCRIPTION:  Set the state of the source.
*
* PARAMETER:    None
*
* RETURNVALUE:  RoutingIF
*
**************************************************************************************/
tVoid source::vSetState(enSrcState state)
{
  ETG_TRACE_USR4(("Inside vSetState m_u8SrcID = %d m_enSrcState = state (%d)",m_u8SrcID,ETG_CENUM(source::enSrcState,state)));
  m_enSrcState = state;
}

/************************************************************************************
*
* FUNCTION:     tU8 source::enGetState(tVoid)
*
* DESCRIPTION:  Returns the corresponding source state.
*
* PARAMETER:    None
*
* RETURNVALUE:  RoutingIF
*
**************************************************************************************/
source::enSrcState source::enGetState(tVoid) const
{
  //ETG_TRACE_USR4(("Inside enGetState"));
  return m_enSrcState;
}

/************************************************************************************
*
* FUNCTION:     enSrcMuteState source::enGetCompMuteState() const
*
* DESCRIPTION:  Returns the corresponding m_enMuteState of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  m_enMuteState
*
**************************************************************************************/
source::enSrcMuteState source::enGetCompMuteState() const
{
  //ETG_TRACE_USR4(("Inside enGetMuteState"));
  return m_enMuteState;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSetCompMuteState(enSrcMuteState m_enMuteState)
*
* DESCRIPTION:  Sets the corresponding m_enMuteState of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  None
*
**************************************************************************************/
tVoid source::vSetCompMuteState(source::enSrcMuteState muteState)
{
  //ETG_TRACE_USR4(("Inside vSetMuteState"));
  this->m_enMuteState = muteState;;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::u16GetActivity() const
*
* DESCRIPTION:  Gets the corresponding Activity source.
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*
**************************************************************************************/
tU16 source::u16GetActivity() const
{
  return this->m_u16SrcActivity;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::u8GetReason() const
*
* DESCRIPTION:  Gets the corresponding m_u8Reason
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16
*
**************************************************************************************/
tU8 source::u8GetReason() const
{
  return this->m_u8Reason;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSetSrcChngMuteState(enSrcMuteState MuteState)
*
* DESCRIPTION:  Sets the corresponding MuteState of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  None
*
**************************************************************************************/
tVoid source::vSetSrcChngMuteState(source::enSrcMuteState muteState)
{
  ETG_TRACE_USR4(("Inside vSetSrcChngMuteState"));
  this->m_enSrcChngMuteState = muteState;
}

/************************************************************************************
*
* FUNCTION:     enSrcMuteState source::enGetSrcChngMuteState() const
*
* DESCRIPTION:  Returns the corresponding MuteState of the sources.
*
* PARAMETER:    None
*
* RETURNVALUE:  MuteState
*
**************************************************************************************/
source::enSrcMuteState source::enGetSrcChngMuteState() const
{
  ETG_TRACE_USR4(("Inside enGetSrcChngMuteState"));
  return this->m_enSrcChngMuteState;
}
/************************************************************************************
*
* FUNCTION:     tU16 source::u16GetSubSrc()
*
* DESCRIPTION:  Returns the corresponding m_u16SubSrc
*
* PARAMETER:    None
*
* RETURNVALUE:  tU16.
*
**************************************************************************************/
tU16 source::u16GetSubSrc() const
{
  return this->m_u16SubSrc;
}
/************************************************************************************
*
* FUNCTION:     tVoid source::u8GetSrcAvailReason() const
*
* DESCRIPTION:  Returns the corresponding m_u8SrcAvailReason
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8.
*
**************************************************************************************/

tU8 source::u8GetSrcAvailReason() const
{
    return this->m_u8SrcAvailReason;
}
/************************************************************************************
*
* FUNCTION:     tVoid source::u8GetSrcAvailability()
*
* DESCRIPTION:  Returns the corresponding m_u8SrcAvailability
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8.
*
**************************************************************************************/
tU8 source::u8GetSrcAvailability() const
{
   return this->m_u8SrcAvailability;
}
/************************************************************************************
*
* FUNCTION:     tVoid source::vSetVolLockType(enVolumeLockType LockType)
*
* DESCRIPTION:  Sets the VolumeLock for each source
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8.
*
**************************************************************************************/
tVoid source::vSetVolLockType(enVolumeLockType LockType)
{
  this->m_enVolLockType = LockType;
}

/************************************************************************************
*
* FUNCTION:     tVoid source::vSetVolLockType(enVolumeLockType LockType)
*
* DESCRIPTION:  Returns the VolumeLock for the source.
*
* PARAMETER:    None
*
* RETURNVALUE:  tU8.
*
**************************************************************************************/
source::enVolumeLockType source::enGetVolLockType() const
{
  return this->m_enVolLockType;
}

/************************************************************************************
*
* FUNCTION:     source_If* source::pogetClientHandler() const
*
* DESCRIPTION:  Returns the corresponding client Handlers
*
* PARAMETER:    None
*
* RETURNVALUE:  source_If*
*
**************************************************************************************/
source_If* source::pogetClientHandler()
{
  source_If* poSourceIf = OSAL_NULL;

  if(OSAL_NULL != m_poCcaMainApp)
  {
   switch(m_u16RoutingIf)
   {
    case SRCROUTE_INTERFACE:
    {
        if((OSAL_NULL != m_poCcaMainApp->poGetSourceFactory()) && (OSAL_NULL != m_poCcaMainApp->poGetSourceFactory()->getClientHandler(this->m_u16AppID)))
      poSourceIf = m_poCcaMainApp->poGetSourceFactory()->getClientHandler(this->m_u16AppID);
      break;
    }
    case STREAMROUTER_INTERFACE:
    {
      poSourceIf = m_poCcaMainApp->poGetStreamRouterClientHandler();
      break;
    }
    default:
      break;
   }
  }
  return poSourceIf;
}
