/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_StreamRouter.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_StreamRouter.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI.
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_STREAMROUTER_H_
#define _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_STREAMROUTER_H_

//#include "ResourceMgmt/fc_audioroutemgr_audiosource.h"
#include "../ResourceMgmt/fc_audioroutemgr_resourcemanager.h"

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;
class source_If;

class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter
      : public ahl_tclBaseOneThreadClientHandler, public fc_audioroutemgr_tclTraceInput, public source_If
{
  public:

    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(tVoid);
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter(fc_audioroutemgr_tclApp* poMainAppl, fc_audioroutemgr_tclresourcemanager* poResourceMgr);
    virtual ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter();

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter& operator=
      (const fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

  // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/
    virtual tVoid vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0);
    virtual tVoid vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink);
    virtual tVoid vPerformDeAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource=0);
    virtual tVoid vPerformStop(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
    virtual tVoid vPerformPlay(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
    virtual tVoid vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource=0);
    // Add your CCA message handler function prototypes here.



    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_StreamRouter)


  private:

     tU8 m_u8Source;
     tU8 m_u8pendingRequest;
     tU8 m_u8pendingRequestSrc;
     fc_audioroutemgr_tclresourcemanager* m_poResourceMgr;
     fc_audioroutemgr_tclApp* m_poMainAppl;

     fc_audioroutemgr_tclsourcefactory* poSourceFactory() const;
   tVoid vHandleAllocateRoute_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleAllocateRoute_Error(amt_tclServiceData* poMessage);
   tVoid vHandleDeAllocateRoute_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleDeAllocateRoute_Error(amt_tclServiceData* poMessage);
   tVoid vHandleSetPlay_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleSetPlay_Error(amt_tclServiceData* poMessage);
   tVoid vHandleSetStop_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleSetStop_Error(amt_tclServiceData* poMessage);
   tVoid vCheckforPendingRequests(tVoid);
};

#endif // _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_STREAMROUTER_H_

