/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_SrcRoute.cpp
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_SrcRoute.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI.
*
*******************************************************************************/

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>  // implicitly links generic <osal_if.h>

//#include "../fc_audioroutemgr_main.h"
#include "fc_audioroutemgr_clienthandler_srcroute.h"
#include "../fc_audioroutemgr_service_audioroutemgr.h"
#include "fc_audioroutemgr_clienthandler_audiofunc.h"
#include "../ResourceMgmt/fc_audioroutemgr_statecontrol.h"
//#include "../ResourceMgmt/fc_audioroutemgr_audiosource.h"

// Include message framework interface (AMT, msgfw)
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

//Include FI interface of used service
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUD_SRC_ROUTEFI_SERVICEINFO

//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_FUNCTIONIDS
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_ERRORCODES
//#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_AUDIO_ROUTE_MGRFI_SERVICEINFO
#include <midw_fi_if.h>

#include "../Trace/fc_audioroutemgr_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDSRCROUTE
#include "trcGenProj/Header/fc_audioroutemgr_clienthandler_srcroute.cpp.trc.h"
#endif


/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// Version defines for used service
#define AUDIOROUTEMGR_SRCROUTE_FI_MAJOR_VERSION  1
#define AUDIOROUTEMGR_SRCROUTE_FI_MINOR_VERSION  0

/******************************************************************************/
/*                                                                            */
/* CCA MESSAGE MAP                                                            */
/*                                                                            */
/******************************************************************************/

BEGIN_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute, ahl_tclBaseWork)

  // Add your ON_MESSAGE_SVCDATA() macros here to define which corresponding
  // method should be called on receiving a specific message.
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_ALLOCATE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleAllocate_MethodResult)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_ALLOCATE, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleAllocate_Error)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_DEALLOCATE, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleDeAllocate_MethodResult)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_DEALLOCATE, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleDeallocate_Error)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_METHODRESULT, vHandleSourceActivity_MethodResult)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEACTIVITY, AMT_C_U8_CCAMSG_OPCODE_ERROR, vHandleSourceActivity_Error)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_MUTEREQUEST, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleMuteRequest_Status)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_REQUESTAUDIOROUTE, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleRequestAudioRouteStatus)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEAVAILABILITY, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSrcAvailabilityInfo)
  ON_MESSAGE_SVCDATA(MIDW_AUD_SRC_ROUTEFI_C_U16_SETAUDIOPROPERTY, AMT_C_U8_CCAMSG_OPCODE_STATUS, vHandleSetAudioPropertyStatus)
END_MSG_MAP()

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*             fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(fc_audioroutemgr_tclApp* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(fc_audioroutemgr_tclApp* poMainAppl, tU16 u16AppID, fc_audioroutemgr_tclsourcefactory* posourcefactory)
: ahl_tclBaseOneThreadClientHandler(
                  /* Application Pointer          */ poMainAppl,
                  /* ID of used Service           */ CCA_C_U16_SRV_AUD_SRC_ROUTE,
                  /* MajorVersion of used Service */ AUDIOROUTEMGR_SRCROUTE_FI_MAJOR_VERSION,
                  /* MinorVersion of used Service */ AUDIOROUTEMGR_SRCROUTE_FI_MINOR_VERSION,
                  u16AppID
                  )
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute() entered."));
  m_poCcaMainApp = poMainAppl;
  m_poSourceFactory = posourcefactory;
  m_u16ServerAppID = u16AppID;
  m_u8pendingRequest = REQUEST_NONE;
  m_u8currentSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
  m_u8pendingRequestSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
  m_u16pendingsubSource = 0;
  m_u16pendingSink = 0;
}

/*******************************************************************************
*
* FUNCTION: fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*             ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute(tVoid)
{
  ETG_TRACE_USR4(("~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute() entered."));
  m_poCcaMainApp = NULL;
  m_poSourceFactory = NULL;
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vOnServiceAvailable()
{
  ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",
    u16GetServerAppID()));

  vAddAutoRegisterForProperty(MIDW_AUD_SRC_ROUTEFI_C_U16_MUTEREQUEST);
  vAddAutoRegisterForProperty(MIDW_AUD_SRC_ROUTEFI_C_U16_REQUESTAUDIOROUTE);
  vAddAutoRegisterForProperty(MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEAVAILABILITY);
  vAddAutoRegisterForProperty(MIDW_AUD_SRC_ROUTEFI_C_U16_SETAUDIOPROPERTY);
  vCheckIfAnyPendingRequests();
}

/*******************************************************************************
*
* FUNCTION:    tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                                                  vCheckIfAnyPendingRequests(tVoid)
*
* DESCRIPTION: Checks for any pending Requests to ARL.
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vCheckIfAnyPendingRequests(tVoid)
{
  if((OSAL_NULL != m_poCcaMainApp) && (poResourceMgr() != OSAL_NULL) && (poResourceMgr()->postateControllerEnt != OSAL_NULL))
  {
    switch(m_u8pendingRequest)
    {
    case REQUEST_ALLOCATE:
      if(poResourceMgr()->postateControllerEnt->u8GetFrontCurSourceInQueue() == m_u8pendingRequestSrc)
  {
        vPerformAllocate(m_u8pendingRequestSrc,m_u8pendingRequestSrc, m_u16pendingsubSource, m_u16pendingSink);
  }
      break;
    case REQUEST_SRC_ACT_ON:
      if(poResourceMgr()->postateControllerEnt->u8GetFrontCurSourceInQueue() == m_u8pendingRequestSrc)
        vPerformPlay(m_u8pendingRequestSrc, m_u8pendingRequestSrc, m_u16pendingsubSource);
      break;
    //VVD
    case REQUEST_SRC_ACT_PAUSE:
      if(poResourceMgr()->postateControllerEnt->u8GetFrontCurSourceInQueue() == m_u8pendingRequestSrc)
       {
        ETG_TRACE_USR4(("vCheckIfAnyPendingRequests(), REQUEST_SRC_ACT_PAUSE"));
      vPerformPause(m_u8pendingRequestSrc, m_u8pendingRequestSrc, m_u16pendingsubSource, m_u16pendingSink);
      }
      else
      {
        ETG_TRACE_USR4(("vCheckIfAnyPendingRequests(), cannot perform pasue,m_u8pendingRequestSrc:%d,PNS in Queue:%d",m_u8pendingRequestSrc,poResourceMgr()->postateControllerEnt->u8GetFrontPossibleNextSourceInQueue()));
      }
      break;

    default:
      break;
    }
  }
  else
  {
    ETG_TRACE_USR4(("m_poResourceMgr is NULL"));
  }
}
/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vOnServiceUnavailable()
{
  ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",
    u16GetServerAppID()));
}

/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: This function is called from the superior application of this
*              client-handler in case of the expiration of a timer.
*
* PARAMETER: [IN] u16TimerId = Identifier of the expired timer.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vProcessTimer(tU16 u16TimerId) const
{
  ETG_TRACE_USR4(("vProcessTimer() entered. TimerID = %u.",u16TimerId));

  if(TRUE == bIfServiceAvailable())
  {
    // Create message for used service.
  }

}


/*******************************************************************************
*
* FUNCTION: tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vProcessTimer(tU16 u16TimerId)
*
* DESCRIPTION: Receives TTFis Trace Commands.
*
* PARAMETER:   tPCUChar pcu8Data.
*
* RETURNVALUE: -
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceRx(tU32 size, tPCUChar pcu8Data)
{
  ETG_TRACE_USR4(("fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceRx() entered."));


  if(pcu8Data==0) return;
  // pcu8Data[0] == my file number
  // pcu8Data[1] == the command
  // pcu8Data[2] == the 1. parameter
  // rest is defined here

  ETG_TRACE_USR4(("vTraceRx() size=%u",size));
  if (size > 1)
  {
    ETG_TRACE_USR4(("vTraceRx() pcu8Data[0] [1] =%u %u",(tU16)pcu8Data[0],(tU16)pcu8Data[1]));
    switch ( pcu8Data[1] )
    {
    case 1:
      ETG_TRACE_USR4(("Received 1"));
      break;

    default:
      ETG_TRACE_USR4(("default"));
      break;
    }
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleAllocate_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Allocate Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleAllocate_MethodResult(amt_tclServiceData* poMessage) const
{
  ETG_TRACE_USR4(("vAllocate_MethodResult() entered."));

  if(poMessage)
  {
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    midw_aud_src_routefi_tclMsgAllocateMethodResult oMethodResult;

    if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_SRCROUTE_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
      ETG_TRACE_USR4(("received oMethodResult.Source.enType = %x",ETG_ENUM(AudioSourceNo,(tU8)oMethodResult.u8Source.enType)));
    }

    midw_fi_tcl_e8_AudSource ::tenType Source = oMethodResult.u8Source.enType;
    tU16 SubSource = oMethodResult.u16SubSource;
    tU16 Error = oMethodResult.u16Error;
    ETG_TRACE_USR4(("received oMethodResult SubSource = %d, Error = %d",SubSource,Error));
    if(Error == 0)
    {
      if((m_poCcaMainApp != OSAL_NULL) && (poResourceMgr() != OSAL_NULL))
      {
        poResourceMgr()->vNotifyAllocate((tU8)Source, SubSource);
      }
      else
      {
        //do nothing
      }
    }
    else
    {
      vHandleAllocate_Error((tU8)Source, SubSource);
      vSendErrorMessage(Source, SubSource, Error);
    }
    oMethodResult.vDestroy();
  }
  else
  {
    //My message is a NULL Pointer
    ETG_TRACE_USR4(("vHandleMute_MethodResult() message is NULL"));
    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleAllocate_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Allocate Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleAllocate_Error(tU8 src, tU16 subsrc) const
{
  ETG_TRACE_USR4(("vHandleAllocate_Error() entered."));
  if(OSAL_NULL != poResourceMgr() && OSAL_NULL != poResourceMgr()->poselStateController(src))
  {
    stateController *postateController = poResourceMgr()->poselStateController(src);
    postateController->vResetState((tU16)stateController::DEALLOCATED);
    poResourceMgr()->vNotifySourceState(src,(tU8)source::SRC_STATE_OFF);
        vCheckNxtSrcAndSendProcessSrcActivityCalls(src, subsrc, postateController);
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleDeAllocate_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the DeAllocate Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleDeAllocate_MethodResult(amt_tclServiceData* poMessage) const
{
  ETG_TRACE_USR4(("vDeAllocate_MethodResult() entered."));

  if(poMessage)
  {
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    midw_aud_src_routefi_tclMsgDeAllocateMethodResult oMethodResult;

    if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_SRCROUTE_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
      ETG_TRACE_USR4(("received oMethodResult.Source.enType = %x",ETG_ENUM(AudioSourceNo,(tU8)oMethodResult.u8Source.enType)));
    }

    midw_fi_tcl_e8_AudSource ::tenType Source = oMethodResult.u8Source.enType;
    tU16 SubSource = oMethodResult.u16SubSource;
    tU16 Error = oMethodResult.u16Error;
    ETG_TRACE_USR4(("received oMethodResult SubSource = %d, Error = %d",SubSource,Error));
    if(Error == 0)
    {
      if((m_poCcaMainApp != OSAL_NULL) && (poResourceMgr() != OSAL_NULL))
      {
        poResourceMgr()->vNotifyDeAllocate((tU8)Source,SubSource);
      }
      else
      {
        //do nothing
      }
    }
    else
    {
      vHandleDeallocate_Error((tU8)Source, SubSource);
      vSendErrorMessage(Source, SubSource, Error);
    }
    oMethodResult.vDestroy();
  }
  else
  {
    //My message is a NULL Pointer
    ETG_TRACE_USR4(("vHandleMute_MethodResult() message is NULL"));
    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleDeallocate_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Deallocate Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleDeallocate_Error(tU8 src, tU16 subsrc) const
{
  ETG_TRACE_USR4(("vHandleDeallocate_Error() entered."));

  //ETG_TRACE_ERR(("vHandleDeAllocate_Error::Error Code:%d",u16ErrorCode));
  if(OSAL_NULL != poResourceMgr() && OSAL_NULL != poResourceMgr()->poselStateController(src))
  {
    stateController *postateController = poResourceMgr()->poselStateController(src);
    postateController->vResetState((tU16)stateController::DEALLOCATED);
    poResourceMgr()->vNotifySourceState(src,(tU8)source::SRC_STATE_OFF);
    vCheckNxtSrcAndSendProcessSrcActivityCalls(src, subsrc, postateController);
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleSourceActivity_MethodResult(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Source Activity Method Result.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleSourceActivity_MethodResult(amt_tclServiceData* poMessage) const
{
  ETG_TRACE_USR4(("vSourceActivity_MethodResult() entered."));

  if(poMessage)
  {
    fi_tclVisitorMessage oVisitorMsg(poMessage);

    midw_aud_src_routefi_tclMsgSourceActivityMethodResult oMethodResult;

    if (oVisitorMsg.s32GetData(oMethodResult, AUDIOROUTEMGR_SRCROUTE_FI_MAJOR_VERSION) != OSAL_ERROR)
    {
      ETG_TRACE_USR4(("received oMethodResult.Source.enType = %x and oMethodResult.SrcActivity.enType = %x",
        ETG_ENUM(AudioSourceNo,(tU8)oMethodResult.u8Source.enType),ETG_ENUM(SrcActivity,oMethodResult.e8Activity.enType)));
    }

    midw_fi_tcl_e8_AudSource ::tenType Source = oMethodResult.u8Source.enType;

    midw_fi_tcl_e8_SrcActivity :: tenType SrcActivity = oMethodResult.e8Activity.enType;
    tU16 SubSource = oMethodResult.u16SubSource;
    tU16 Error = oMethodResult.u16Error;
    ETG_TRACE_USR4(("received oMethodResult SubSource = %d, Error = %d",SubSource,Error));
    if(Error == 0)
    {
      if((m_poCcaMainApp != OSAL_NULL) && (poResourceMgr() != OSAL_NULL))
      {
        poResourceMgr()->vNotifySourceActivity((tU8)Source,(tU16)SrcActivity,oMethodResult.u16SubSource);
      }
      else
      {
        //do nothing
      }
    }
    else
    {
      vHandleSourceActivity_Error((tU8)Source, SubSource);
      vSendErrorMessage(Source, SubSource, Error);
    }
    oMethodResult.vDestroy();
  }
  else
  {
    //My message is a NULL Pointer
    ETG_TRACE_USR4(("vHandleMute_MethodResult() message is NULL"));
    NORMAL_M_ASSERT_ALWAYS();
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleSourceActivity_Error(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Source Activity Error.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleSourceActivity_Error(tU8 src, tU16 subsrc) const
{
  ETG_TRACE_USR4(("vHandleSourceActivity_Error() entered."));
  if(OSAL_NULL != poResourceMgr() && OSAL_NULL != poResourceMgr()->poselStateController(src))
  {
    stateController *postateController = poResourceMgr()->poselStateController(src);
    postateController->vResetState((tU16)stateController::DEALLOCATED);
    tU8 PosNextSrc = postateController->u8posNextSrc;


  (const_cast<fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute*> (this))-> vPerformDeAllocate(src,PosNextSrc,subsrc);
    poResourceMgr()->vNotifySourceState(src,(tU8)source::SRC_STATE_OFF);
    vCheckNxtSrcAndSendProcessSrcActivityCalls(src, subsrc, postateController);
  }
}
/*******************************************************************************
*
* FUNCTION:     fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vSendErrorMessage(midw_fi_tcl_e8_AudSource,tU16,tU16)
*
* DESCRIPTION:  Handles the Source Activity Error.
*
* PARAMETER:    midw_fi_tcl_e8_AudSource- source
*        tU16-  SubSource
*        tU16-  Error
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vSendErrorMessage(midw_fi_tcl_e8_AudSource::tenType Source, tU16 SubSource, tU16 Error) const
{
  ETG_TRACE_USR4(("vSendErrorMessage() entered."));

  if(OSAL_NULL != m_poCcaMainApp && OSAL_NULL != m_poCcaMainApp->poGetAudioRouteMgrServiceHandler())
  {
    m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->vSendErrorStatusMessage((tU8)Source, SubSource, Error);
  }
  else
  {
    ETG_TRACE_USR4(("Fatal Error: _poMainAppl = NULL"));
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleMuteRequest_Status(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Mute Request Status from ARL.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleMuteRequest_Status(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Entered vHandleMuteRequest_Status()"));

  if ( poMessage != OSAL_NULL )
  {
    fi_tclVisitorMessage oVisitorMsg( poMessage );
    midw_aud_src_routefi_tclMsgMuteRequestStatus oMuteRequestStatus;
    oVisitorMsg.s32GetData(oMuteRequestStatus);

    std::vector<midw_fi_tcl_MuteRequestItem>::const_iterator MuteReqIterator;

    source* poSourcePtr = OSAL_NULL;
      tU8  u8requestingSource;
      tU8  u8muteAction;
      tU32 u8muteReason;

    if((m_poCcaMainApp != OSAL_NULL) && (m_poSourceFactory != OSAL_NULL) && (poResourceMgr() != OSAL_NULL))
    {
      for(MuteReqIterator = oMuteRequestStatus.MuteRequestList.begin();
        MuteReqIterator != oMuteRequestStatus.MuteRequestList.end();
        ++MuteReqIterator)
      {
        u8requestingSource = (tU8)(*MuteReqIterator).u8Source.enType;
        u8muteAction = (tU8) (*MuteReqIterator).u8Action.enType;
        u8muteReason = (tU8) (*MuteReqIterator).u32Reason.u32Value;

        ETG_TRACE_USR4(("Requesting Source: %d, MuteAction: %d, MuteReason: %d",u8requestingSource,u8muteAction,u8muteReason));

        poSourcePtr = m_poSourceFactory->poSourcePtr(u8requestingSource);

        if(OSAL_NULL != poSourcePtr)
        {
          std::vector<tU16> sinkList = poSourcePtr->getSinkList();
          tU16 sink = 1; //set 1 as default
          for(unsigned int i=0;i<sinkList.size();i++)
          {
            ETG_TRACE_USR4(("Source %d is on sink %d",u8requestingSource,sinkList[i]));
          }
          if(sinkList.size()>0)
          {
            ETG_TRACE_USR4(("Currently we choose the first sink %d only for mute",sinkList[0]));
            sink = sinkList[0];
          }
      tU8 u8SupportedChannel = poSourcePtr->u8GetSourceSupportedStream();
          source::enSrcMuteState encompMuteState = poSourcePtr->enGetCompMuteState();
      m_u8currentSrc = poResourceMgr()->u8GetCurSrcinSM(u8SupportedChannel);

          ETG_TRACE_USR4(("m_u8currentSrc: %d, muteState: %d",m_u8currentSrc,encompMuteState));

          if((poSourcePtr->enGetState() == source::SRC_STATE_ON) && (u8muteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_MUTE) &&
            (encompMuteState == source::SRC_DEMUTE))
            {
                  for(unsigned int i=0;i<sinkList.size();i++)
                  {
                    ETG_TRACE_USR4(("Source %d vPerformComponentMute on sink %d",u8requestingSource,sinkList[i]));
                    m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformComponentMute(u8requestingSource,u8muteAction,u8muteReason, u8SupportedChannel, 1, static_cast<tU8>(sinkList[i]));
                  }
            }
          else if((poSourcePtr->enGetState() == source::SRC_STATE_ON) && (u8muteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE) &&
                (encompMuteState == source::SRC_MUTE))
          {
              for(unsigned int i=0;i<sinkList.size();i++)
              {
                ETG_TRACE_USR4(("Source %d vPerformComponentMute on sink %d",u8requestingSource,sinkList[i]));
                m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformComponentMute(u8requestingSource,u8muteAction,u8muteReason, u8SupportedChannel, 1, static_cast<tU8>(sinkList[i]));
              }
          }
          else if((poSourcePtr->enGetState() == source::SRC_STATE_ON_IP) && (u8muteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_MUTE) &&
                  (encompMuteState == source::SRC_DEMUTE))
          {
               vPerformSetMuteState(u8requestingSource,u8muteAction);
          }
          else if((poSourcePtr->enGetState() == source::SRC_STATE_ON_IP) && (u8muteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE) &&
                  (encompMuteState == source::SRC_MUTE))
          {//Bug 1938362 Cabin audio lost when mic 1 is activated and deactivated while Audio USB is played in Cabin region
              for(unsigned int i=0;i<sinkList.size();i++)
              {
                ETG_TRACE_USR4(("ADDED_NEW Source %d vPerformComponentMute on sink %d during SRC_STATE_ON_IP",u8requestingSource,sinkList[i]));
                m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformComponentMute(u8requestingSource,u8muteAction,u8muteReason, u8SupportedChannel, 1, static_cast<tU8>(sinkList[i]));
              }
          }
	  else
	  {
              poSourcePtr->vSetCompMuteState((source::enSrcMuteState)u8muteAction);
              vPerformSetMuteState(u8requestingSource,u8muteAction);
	  }
        }
      }
    }
    oMuteRequestStatus.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("vHandleMuteRequest_Status()-->poMessage = OSAL_NULL"));
  }

}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleRequestAudioRouteStatus(amt_tclServiceData* poMessage)
*
* DESCRIPTION: Handles the Request Audio Route Status Message from ARL.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleRequestAudioRouteStatus(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Entered vHandleRequestAudioRouteStatus()"));

  if ( poMessage != OSAL_NULL )
  {
    fi_tclVisitorMessage oVisitorMsg( poMessage );
    midw_aud_src_routefi_tclMsgRequestAudioRouteStatus iReqRouteStatus;

    //Get the data
    oVisitorMsg.s32GetData(iReqRouteStatus);

    if(iReqRouteStatus.RequestAudioRouteList.empty())
    {
      ETG_TRACE_ERR(("List Empty"));
    }
    else
    {
      if(OSAL_NULL != m_poCcaMainApp && OSAL_NULL != m_poCcaMainApp->poGetAudioRouteMgrServiceHandler() && OSAL_NULL != m_poSourceFactory)
      {
        m_poSourceFactory->vSendReqRouteList(iReqRouteStatus.RequestAudioRouteList);

        if (m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE) != AIL_EN_N_NO_ERROR)
        {
              ETG_TRACE_ERR(("Updating the clients failed for AudioRouteRequest"));
        }
        else
        {
              ETG_TRACE_USR4(("Updating the clients done for AudioRouteRequest"));
        }

      }
      else
      {
        ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
      }
    }
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleSrcAvailabilityInfo(amt_tclServiceData* poMessage);
*
* DESCRIPTION: Handles the Source Availability Status Message from ARL.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleSrcAvailabilityInfo(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Entered vHandleSrcAvailabilityInfo()"));

  if ( poMessage != OSAL_NULL )
  {
    fi_tclVisitorMessage oVisitorMsg( poMessage );
    midw_aud_src_routefi_tclMsgSourceAvailabilityStatus inSrcAvailStatus;
    //Get the data
    oVisitorMsg.s32GetData(inSrcAvailStatus);

    if(inSrcAvailStatus.SourceAvailabilityList.empty())
    {
      ETG_TRACE_ERR(("List Empty"));
    }
    else
    {
      if(OSAL_NULL != m_poCcaMainApp && OSAL_NULL != m_poCcaMainApp->poGetAudioRouteMgrServiceHandler() &&
         OSAL_NULL != m_poSourceFactory)
      {
        m_poSourceFactory->vSendSrcAvailabilityList(inSrcAvailStatus.SourceAvailabilityList);

        if (m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY) != AIL_EN_N_NO_ERROR)
        {
              ETG_TRACE_ERR(("Updating the clients failed for SourceAvailability"));
        }
        else
        {
              ETG_TRACE_USR4(("Updating the clients done for SourceAvailability"));
        }
      }
      else
      {
        ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
      }
    }
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vHandleSetAudioPropertyStatus(amt_tclServiceData* poMessage);
*
* DESCRIPTION: Handles the SetAudioProperty Status Message from ARL.
*
* PARAMETER:   poMessage- Pointer to the CCA Message
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vHandleSetAudioPropertyStatus(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("Entered vHandleSetAudioPropertyStatus()"));
  if ( poMessage != OSAL_NULL )
  {
    fi_tclVisitorMessage oVisitorMsg( poMessage );
    midw_aud_src_routefi_tclMsgSetAudioPropertyStatus inSetAudioPropertyStatus;
    source* poSourcePtr = OSAL_NULL;
    oVisitorMsg.s32GetData(inSetAudioPropertyStatus);

    std::vector<midw_fi_tcl_SetAudioPropertyItem>::const_iterator SetAudioPropertyIterator;
    tU8 Source;
    tU8 Type;
    tS32 Offset;

    if(m_poCcaMainApp != OSAL_NULL && m_poSourceFactory != OSAL_NULL &&
           OSAL_NULL != poResourceMgr() && m_poCcaMainApp->poGetAudioFuncClientHandler() != OSAL_NULL)
    {
      ETG_TRACE_USR4(("Entered vHandleSetAudioPropertyStatus() looping list with size %d", inSetAudioPropertyStatus.SetAudioPropertyList.size()));
      for(SetAudioPropertyIterator = inSetAudioPropertyStatus.SetAudioPropertyList.begin();
        SetAudioPropertyIterator != inSetAudioPropertyStatus.SetAudioPropertyList.end();
        ++SetAudioPropertyIterator)
      {
        Source = (tU8)(*SetAudioPropertyIterator).u8Source.enType;
        Type = (tU8)(*SetAudioPropertyIterator).u8Property.enType;
        Offset = (*SetAudioPropertyIterator).s32PropValue;

        poSourcePtr = m_poSourceFactory->poSourcePtr(Source);

        switch((*SetAudioPropertyIterator).u8Property.enType)
        {
          case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_INPUT_GAIN:
          case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_IPOD_DUCKING:
          {
            m_poCcaMainApp->poGetAudioFuncClientHandler()->vSendAudioPropertyDataToFCAM(Source, Type, Offset);
            break;
          }
          case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_VOLUME_LOCK:
          {
            source::enVolumeLockType LockType = (source::enVolumeLockType)(*SetAudioPropertyIterator).s32PropValue;

            if(OSAL_NULL != poSourcePtr)
              poSourcePtr->vSetVolLockType(LockType);

              m_poCcaMainApp->poGetAudioFuncClientHandler()->vSetVolumeLock(LockType);

            break;
          }
          default:
          {
            ETG_TRACE_ERR(("Invalid Property"));
            break;
          }
          }
       }
      }
     }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                              vPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to stop the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformStop(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformSrcActOff"));

  if((_poMainAppl != OSAL_NULL) && (OSAL_NULL != poResourceMgr()))
  {
    midw_aud_src_routefi_tclMsgSourceActivityMethodStart oSourceActivity;

    oSourceActivity.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)CurSrc;
    oSourceActivity.u16SubSource = SubSource;
    oSourceActivity.u8PosNextSrc.enType = (midw_fi_tcl_e8_AudSource::tenType)PosNextSrc; //daw2hi
    oSourceActivity.e8Activity.enType = midw_fi_tcl_e8_SrcActivity::FI_EN_OFF;

    fi_tclVisitorMessage oCCaMsg(oSourceActivity);
    oCCaMsg.vInitServiceData(   _poMainAppl->u16GetAppId(),   // Source AppID
      this->m_u16ServerAppID,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEACTIVITY,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_ERR(("FAILED SENDING CCA MSG: SrcActivity OFF "));
        NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
        ETG_TRACE_USR4(("Sending SrcActivity OFF Successful"));
      }
    }
    else
    {
      /* IF ARL Service is not available, Answer OFF immmediately as per ErrorHandlingConcept */
      ETG_TRACE_ERR(("SrcActivity Service not available "));
      poResourceMgr()->vNotifySourceActivity(CurSrc,(tU16)midw_fi_tcl_e8_SrcActivity::FI_EN_OFF,SubSource);
    }
    oSourceActivity.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending SrcActivity OFF ERROR !!!!"));
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                              vPerformSrcActOff(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to stop the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource)
{
   ETG_TRACE_USR4(("vPerformPause Sink hardcoded to 1 !!!"));
   vPerformPause(CurSrc,PosNextSrc,SubSource,1);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformPause(tU8 CurSrc,tU8 PosNextSrc, tU16 SubSource, tU16 /*Sink*/)
{
    ETG_TRACE_ERR(("ToDo: Sink not yet used."));
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformSrcActPause Src %d, PosNext %d, SubSrc %d",
        CurSrc, PosNextSrc, SubSource));
  if((_poMainAppl != OSAL_NULL) && (OSAL_NULL != poResourceMgr()))
  {
    midw_aud_src_routefi_tclMsgSourceActivityMethodStart oSourceActivity;
    oSourceActivity.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)CurSrc;
    oSourceActivity.u16SubSource = SubSource;
    oSourceActivity.e8Activity.enType = midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE;
    oSourceActivity.u8PosNextSrc.enType = (midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;

    fi_tclVisitorMessage oCCaMsg(oSourceActivity);
    oCCaMsg.vInitServiceData(   _poMainAppl->u16GetAppId(),   // Source AppID
      this->m_u16ServerAppID,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEACTIVITY,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
    m_u8pendingRequest = REQUEST_NONE;
      m_u8pendingRequestSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
      if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_ERR(("FAILED SENDING CCA MSG: SrcActivity PAUSE "));
        NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
        ETG_TRACE_USR4(("Sending SrcActivity Pause Successful"));
      }
    }
    else
    {   /* IF ARL Service is not available, Answer Pause immmediately as per ErrorHandlingConcept */
      ETG_TRACE_ERR(("SrcActivity Service not available "));

    //VVD
    poResourceMgr()->postateControllerEnt->vResetState((tU16)stateController::DEALLOCATED);

    // If there is already a Pending request during Service unavailability then remove the prvious request and store the new one.
    if(REQUEST_NONE != m_u8pendingRequest)
      {
        if(OSAL_NULL != poResourceMgr()->poselStateController(CurSrc))
    {
      stateController *postateController = poResourceMgr()->poselStateController(CurSrc);
      if(!postateController->QueueSrcActivityCall.empty())
        postateController->QueueSrcActivityCall.pop_front();
    }
  }
        m_u8pendingRequest = REQUEST_SRC_ACT_PAUSE;

        //vdu1kor : Possible Next Source should be current source for SrcActPause (Suzuki Fix RTC-181896)
        //m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
        m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)CurSrc;

        m_u16pendingsubSource = SubSource;
  }
    oSourceActivity.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending SrcActivity Pause ERROR !!!!"));
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                              vPerformSrcActOn(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Start the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformPlay(tU8 CurSrc, tU8 PosNextSrc, tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformSrcActOn CurSrc %d, PosNext %d, SubSrc %d",
        CurSrc, PosNextSrc, SubSource));

  if((_poMainAppl != OSAL_NULL) && (OSAL_NULL != poResourceMgr()))
  {
    midw_aud_src_routefi_tclMsgSourceActivityMethodStart oSourceActivity;
    oSourceActivity.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)CurSrc;
    oSourceActivity.u16SubSource = SubSource;
    oSourceActivity.u8PosNextSrc.enType = (midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
    oSourceActivity.e8Activity.enType = midw_fi_tcl_e8_SrcActivity::FI_EN_ON;

    fi_tclVisitorMessage oCCaMsg(oSourceActivity);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
      this->m_u16ServerAppID,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_SOURCEACTIVITY,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      this->m_u8pendingRequest = REQUEST_NONE;
      this->m_u8pendingRequestSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;
      if (_poMainAppl->enPostMessage(&oCCaMsg, TRUE) != AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_ERR(("FAILED SENDING CCA MSG: SrcActivity ON "));
        NORMAL_M_ASSERT_ALWAYS();
      }
      else
      {
        ETG_TRACE_USR4(("Sending SrcActivity ON Successful"));
      }
    }
    else
    {
    ETG_TRACE_ERR(("SrcActivity Service not available "));
    /* IF service is not available Store the Request and the Source Requested, to send calls again when service becomes available */
    poResourceMgr()->postateControllerEnt->vResetState((tU16)stateController::ALLOCATED);

    // If there is already a Pending request during Service unavailability then remove the prvious request and store the new one.
    if(REQUEST_NONE != m_u8pendingRequest)
      {
        if(OSAL_NULL != poResourceMgr()->poselStateController(CurSrc))
    {
      stateController *postateController = poResourceMgr()->poselStateController(CurSrc);
      if(!postateController->QueueSrcActivityCall.empty())
        postateController->QueueSrcActivityCall.pop_front();
    }
  }
        m_u8pendingRequest = REQUEST_SRC_ACT_ON;
        m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)CurSrc;
        m_u16pendingsubSource = SubSource;
  }
    oSourceActivity.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending SrcActivity ON ERROR !!!!"));
  }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                              vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to Allocate Stream for the New source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource)
{
  ETG_TRACE_USR4(("vPerformAllocate set Sink to 1"));
  vPerformAllocate(CurSrc, PosNextSrc, SubSource, 1);
}
/*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource, tU16 Sink)
{

  ETG_TRACE_USR4(("Entered vPerformAllocate CurSrc =%d, PosNext =%d, Sink =%d",CurSrc,PosNextSrc,Sink));
  (tVoid)CurSrc;

  ETG_TRACE_USR4(("Server AppID: %x",m_u16ServerAppID));

  if((_poMainAppl != OSAL_NULL) && (poResourceMgr() != OSAL_NULL))
  {
    midw_aud_src_routefi_tclMsgAllocateMethodStart oallocate;
    oallocate.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
    oallocate.u16SubSource = SubSource;
  oallocate.u16Sink = Sink; //daw2hi added

    fi_tclVisitorMessage oCCaMsg(oallocate);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
      this->m_u16ServerAppID,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_ALLOCATE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      this->m_u8pendingRequest = REQUEST_NONE;
      this->m_u8pendingRequestSrc = (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE;

      tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg,TRUE);
      if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR4(("Sending Allocate Successful"));
      }
      else
      {
        ETG_TRACE_USR4(("Sending Allocate not Successful, ErrCode:%d Regid: %d",u16ErrCode,u16GetRegID()));
      }
    }
    else
    { /* IF service is not available Store the Request and the Source Requested, to send calls again when service becomes available */
      //Resetting the state to Allocated to allow further Source changes.
      poResourceMgr()->postateControllerEnt->vResetState((tU16)stateController::DEALLOCATED);
      this->m_u8pendingRequest = REQUEST_ALLOCATE;
      this->m_u8pendingRequestSrc = (tU8)(midw_fi_tcl_e8_AudSource::tenType)PosNextSrc;
      this->m_u16pendingsubSource = SubSource;
      this->m_u16pendingSink = Sink;
      ETG_TRACE_ERR(("Allocate Service not available "));
    }
    oallocate.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending Allocate ERROR !!!!"));
  }

}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                              vPerformDeallocate(tU8 CurSrc,tU8 PosNextSrc)
*
* DESCRIPTION: Sends the CCA Message to DeAllocate Stream of the current source
*
* PARAMETER:   tU8 CurSrc,tU8 PosNextSrc
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformDeAllocate(tU8 CurSrc,tU8 PosNextSrc,tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformDeallocate Src %d, PosNext %d, SubSrc %d",
        CurSrc, PosNextSrc, SubSource));

  (tVoid)PosNextSrc;  // Lint

  if(_poMainAppl != NULL)
  {
    midw_aud_src_routefi_tclMsgDeAllocateMethodStart odeallocate;
    odeallocate.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)CurSrc;
    odeallocate.u16SubSource = SubSource;

    fi_tclVisitorMessage oCCaMsg(odeallocate);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
      this->m_u16ServerAppID,        // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_DEALLOCATE,
      AMT_C_U8_CCAMSG_OPCODE_METHODSTART
      );

    if(bIfServiceAvailable())
    {
      this->m_u8pendingRequest = REQUEST_NONE;
      this->m_u8pendingRequestSrc = (tU8) midw_fi_tcl_e8_AudSource::FI_EN_NONE;
      tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg,TRUE);
      if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR4(("Sending Deallocate Successful"));
      }
      else
      {
        ETG_TRACE_USR4(("Sending DeAllocate not Successful, ErrCode:%d Regid: %d",u16ErrCode,u16GetRegID()));
      }
    }
    else
    {
      ETG_TRACE_USR4(("Deallocate Service not Available"));
      /* IF ARL Service is not available, Answer DeAllocate immmediately as per ErrorHandlingConcept */
      poResourceMgr()->vNotifyDeAllocate(CurSrc,SubSource);
    }
    odeallocate.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending Deallocate ERROR !!!!"));
  }

}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                             vSetMuteState(tU8 Source,tU8 SrcMuteState)
*
* DESCRIPTION: Sends the CCA Message to Set the Mute State of the current source
*
* PARAMETER:   tU8 Source,tU8 SrcMuteState
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformSetMuteState(tU8 Source,tU8 SrcMuteState)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vSetMuteState"));
  ETG_TRACE_USR4(("Source : %d, SrcMuteState : %d, ServerAppID : %d",Source,SrcMuteState,this->u16GetServerAppID()));

  if(_poMainAppl != NULL)
  {
    midw_aud_src_routefi_tclMsgMuteStateSet oSetMuteState;
    oSetMuteState.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)Source;
    oSetMuteState.u8MuteState.enType = (midw_fi_tcl_e8_MuteState::tenType)SrcMuteState;

    fi_tclVisitorMessage oCCaMsg(oSetMuteState);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
      this->u16GetServerAppID(),  // Target AppID
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
      0,
      u16GetRegID(),
      0,
      CCA_C_U16_SRV_AUD_SRC_ROUTE,
      MIDW_AUD_SRC_ROUTEFI_C_U16_MUTESTATE,
      AMT_C_U8_CCAMSG_OPCODE_SET
      );

    if(bIfServiceAvailable())
    {
      tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg,TRUE);
      if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR4(("Setting MuteState Successful"));
      }
      else
      {
        ETG_TRACE_USR4(("Setting MuteState not Successful, ErrCode:%d Regid: %d",u16ErrCode,u16GetRegID()));
      }
    }
    else
    {
      ETG_TRACE_USR4(("MuteState Service not Available"));
    }
    oSetMuteState.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending MuteState ERROR !!!!"));
  }

}


tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformRouteRequestReject(tU8 Source,tU16 SubSource)
{
  ETG_TRACE_USR4(("Entered fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vPerformRouteRequestReject"));
  ETG_TRACE_USR4(("Source : %d, SubSource %d, ServerAppID : %d",Source,SubSource,this->u16GetServerAppID()));

  if(_poMainAppl != NULL)
  {
    midw_aud_src_routefi_tclMsgRequestAudioRouteRejectSet oReject;
    oReject.u8Source.enType = (midw_fi_tcl_e8_AudSource::tenType)Source;
    oReject.u16SubSource = SubSource;
    //TBD Reason

    fi_tclVisitorMessage oCCaMsg(oReject);
    oCCaMsg.vInitServiceData( _poMainAppl->u16GetAppId(),   // Source AppID
        this->u16GetServerAppID(),  // Target AppID
        AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,
        0,
        u16GetRegID(),
        0,
        CCA_C_U16_SRV_AUD_SRC_ROUTE,
        MIDW_AUD_SRC_ROUTEFI_C_U16_REQUESTAUDIOROUTEREJECT,
        AMT_C_U8_CCAMSG_OPCODE_SET
    );

    if(bIfServiceAvailable())
    {
      tU16 u16ErrCode = (tU16)_poMainAppl->enPostMessage(&oCCaMsg,TRUE);
      if(u16ErrCode == (tU16)AIL_EN_N_NO_ERROR)
      {
        ETG_TRACE_USR4(("Sending AudioRouteRequestReject Successful"));
      }
      else
      {
        ETG_TRACE_USR4(("Sending AudioRouteRequestReject not Successful, ErrCode:%d Regid: %d",u16ErrCode,u16GetRegID()));
      }
    }
    else
    {
      ETG_TRACE_USR4(("Service not Available, can't send AudioRouteRequestReject"));
    }
    oReject.vDestroy();
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    ETG_TRACE_USR4(("Sending AudioRouteRequestReject ERROR !!!!"));
  }

}



/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vTraceInputMuteRequestStatus(tU8 m_u8requestingSource,tU8 m_u8muteAction,tU16 m_u8muteReason)
*
* DESCRIPTION: Simulate MuteRequestStatus function through TTFis input command.
*
* PARAMETER:   tU8 m_u8requestingSource,tU8 m_u8muteAction,tU16 m_u8muteReason
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceInputMuteRequestStatus(tU8 RequestingSource,tU8 MuteAction,tU16 MuteReason)
{
  ETG_TRACE_USR4(("Entered vTraceInputMuteRequestStatus()"));

  source* poSourcePtr = OSAL_NULL;

  if((m_poCcaMainApp != OSAL_NULL) && (m_poSourceFactory != OSAL_NULL))
  {
    poSourcePtr = m_poSourceFactory->poSourcePtr(RequestingSource);

    if(OSAL_NULL != poSourcePtr)
    {
      source::enSrcMuteState muteState = poSourcePtr->enGetCompMuteState();
            tU8 u8SupportedChannel = poSourcePtr->u8GetSourceSupportedStream();
      ETG_TRACE_USR4(("Current Source : %d, ReqSrc_MuteState : %d",m_u8currentSrc,muteState));

      if((poSourcePtr->enGetState() == source::SRC_STATE_ON) && (MuteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_MUTE) && ((muteState == source::SRC_DEMUTE)))
      {
        m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformComponentMute(RequestingSource,MuteAction,MuteReason, u8SupportedChannel);
      }

      else if((MuteAction == (tU8)midw_fi_tcl_e8MuteAction::FI_EN_DEMUTE) && (muteState == source::SRC_MUTE) && (poSourcePtr->enGetState() == source::SRC_STATE_ON))
      {
        m_poCcaMainApp->poGetAudioFuncClientHandler()->vPerformComponentMute(RequestingSource,MuteAction,MuteReason, u8SupportedChannel);
      }
      else
      {
        poSourcePtr->vSetCompMuteState((source::enSrcMuteState)MuteAction);
      }
    }
  }
  else
  {
    ETG_TRACE_ERR(("m_poCcaMainApp = OSAL_NULL"));
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vTraceInputRequestAudioRoute(tU8 Source,tU16 Activity)
*
* DESCRIPTION: Simulate RequestAudioRouteStatus function through TTFis input command.
*
* PARAMETER:   tU8 Source,tU16 Activity
*
* RETURNVALUE: None.
*
*******************************************************************************/

tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceInputRequestAudioRoute(tU8 Source,tU16 Activity)
{

  ETG_TRACE_USR4(("Entered vTraceInputRequestAudioRoute()"));
  ETG_TRACE_USR4(("Source : %d,Activity : %d",Source,Activity));


  if((m_poCcaMainApp != OSAL_NULL) && (m_poSourceFactory != OSAL_NULL) && OSAL_NULL != m_poCcaMainApp->poGetAudioRouteMgrServiceHandler())
  {
    if (m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_REQUESTAUDIOROUTE) != AIL_EN_N_NO_ERROR)
    {
          ETG_TRACE_ERR(("Updating the clients failed for RequestAudioRoute"));
    }
    else
    {
          ETG_TRACE_USR4(("Updating the clients done for RequestAudioRoute"));
    }
  }
  else
  {
    ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
  }
}

/*!***********************************************************************
* METHOD:      fc_audioroutemgr_tclresourcemanager*
*                    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*                                                    poResourceMgr() const
*
* DESCRIPTION:    Returns Resource Manager class Pointer
*
* RETURNVALUE:     fc_audioroutemgr_tclresourcemanager
*
* PARAMETER  :     None
*************************************************************************/
fc_audioroutemgr_tclresourcemanager* fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::poResourceMgr() const
{
  fc_audioroutemgr_tclresourcemanager *poResrcMgr = NULL;

  if(m_poCcaMainApp != OSAL_NULL)
  {
    return m_poCcaMainApp->poGetResourceManager();
  }
  else
  {
    return poResrcMgr;
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vTraceInputRequestSrcAvailability(tU8 Source,tU8 Availability)
*
* DESCRIPTION: Simulate SrcAvailability function through TTFis input command.
*
* PARAMETER:   tU8 Source,tU8 Availability
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceInputRequestSrcAvailability(tU8 /* Source */, tU8 /* Availability */)
{
  if((m_poCcaMainApp != OSAL_NULL) && (m_poSourceFactory != OSAL_NULL)  && OSAL_NULL != m_poCcaMainApp->poGetAudioRouteMgrServiceHandler())
  {
      if (m_poCcaMainApp->poGetAudioRouteMgrServiceHandler()->updateClients(MIDW_AUDIO_ROUTE_MGRFI_C_U16_SOURCEAVAILABILITY) != AIL_EN_N_NO_ERROR)
      {
            ETG_TRACE_ERR(("Updating the clients failed for SourceAvailability"));
      }
      else
      {
            ETG_TRACE_USR4(("Updating the clients done for SourceAvailability"));
      }
  }
    else
    {
      ETG_TRACE_ERR(("Fatal Error: m_poCcaMainApp = NULL"));
    }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vTraceInputSetAudioRoute(tU8 Source, tU8 Type, tS32 Value)
*
* DESCRIPTION: Simulate SetAudioRouteProperty function through TTFis input command.
*
* PARAMETER:   tU8 Source, tU8 Type, tS32 Value
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vTraceInputSetAudioRoute(tU8 Source, tU8 Type, tS32 Value)
{
  if(m_poCcaMainApp != OSAL_NULL && m_poSourceFactory != OSAL_NULL &&
           OSAL_NULL != poResourceMgr() && m_poCcaMainApp->poGetAudioFuncClientHandler() != OSAL_NULL)
  {
  switch(Type)
  {
    case (tU8)midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_INPUT_GAIN:
    case midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_IPOD_DUCKING:
    {
      m_poCcaMainApp->poGetAudioFuncClientHandler()->vSendAudioPropertyDataToFCAM(Source, Type, Value);
      break;
    }
    case (tU8)midw_fi_tcl_e8_AudioProperty::FI_EN_AUDIO_PROP_VOLUME_LOCK:
    {
      if(m_poSourceFactory->poSourcePtr(Source) != NULL)
        m_poSourceFactory->poSourcePtr(Source)->vSetVolLockType((source::enVolumeLockType)Value);
      if(m_poCcaMainApp->poGetResourceManager()->postateControllerEnt->tU16GetState() == (tU16)stateController::DEMUTED)
      {
        m_poCcaMainApp->poGetAudioFuncClientHandler()->vSetVolumeLock((source::enVolumeLockType)Value);
      }
      break;
    }
    default:
    {
      ETG_TRACE_ERR(("Invalid Property"));
      break;
    }
  }
  }
}
/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vCheckNxtSrcAndProcessSrcActivityCalls()
*
* DESCRIPTION: Checks next source and processes source Activity Calls..
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vCheckNxtSrcAndSendProcessSrcActivityCalls(tU8 src, tU16 subsrc, stateController* postateController) const
{
   if(postateController != OSAL_NULL)
   {
    if(!postateController->QueueSrcActivityCall.empty())
        postateController->QueueSrcActivityCall.pop_front();

     if(postateController->bCheckIfSrcSameasSrcInFrontofQueue(src) && postateController->u16GetFrontSubSourceInQueue() == subsrc)
     {
       if(!postateController->QueueSrcActivityCall.empty())
       postateController->QueueSrcActivityCall.pop_front();

      vProcessSrcActivityCallsInQueue(postateController);
     }
     else
     {
       vProcessSrcActivityCallsInQueue(postateController);
     }
   }
}

/*******************************************************************************
*
* FUNCTION:    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::
*               vProcessSrcActivityCallsInQueue()
*
* DESCRIPTION: Processes Source Activity Requests in Queue.
*
* PARAMETER:   None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid fc_audioroutemgr_tclClientHandler_AudioRouteMgr_SrcRoute::vProcessSrcActivityCallsInQueue(stateController* postateController) const
{
  if(OSAL_NULL != postateController)
  {
  if(!postateController->QueueSrcActivityCall.empty() && postateController->u8GetFrontCurSourceInQueue() != (tU8)midw_fi_tcl_e8_AudSource::FI_EN_NONE)
    {
    postateController->u8curSrc = postateController->u8GetFrontCurSourceInQueue();
    postateController->u8posNextSrc = postateController->u8GetFrontPossibleNextSourceInQueue();
    postateController->u8activity = (tU8)postateController->u16GetFrontActivityInQueue();
    postateController->u16SubSource = postateController->u16GetFrontSubSourceInQueue();

    auto itr = postateController->Activitymap.find((stateController::enSrcAct)postateController->u8activity);
    if(itr != postateController->Activitymap.end())
        postateController->vChangeState( itr->second, postateController->u8curSrc, postateController->u8posNextSrc, postateController->u16SubSource);
     }
   }
}
