/*******************************************************************************
*
* FILE:          FC_AudioRouteMgr_clienthandler_AudioRouteMgr_AudioFunc.h
*
* SW-COMPONENT:  FC_AudioRouteMgr application
*
* PROJECT:       NISSAN LCN2KAI
*
* DESCRIPTION:   CCA client-handler for the service AudioRouteMgr_AudioFunc.
*
* AUTHOR:        Ravindra Kumar Rajendran (RBEI/ECV4)
*
* COPYRIGHT:    (c) 2012 RBEI
*
*******************************************************************************/

#ifndef _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_AUDIOFUNC_H_
#define _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_AUDIOFUNC_H_

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
//#define SYSTEM_S_IMPORT_INTERFACE_MAP
//#include <stl_pif.h>




#include <map>

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define Streams 4
#include "../ResourceMgmt/fc_audioroutemgr_resourcemanager.h"

class ahl_tclBaseOneThreadClientHandler;

struct tsAmpDevAudioRouteParam
{
    tU16 u16AmpDevSink;
    tU8  u8AmpDevSource;
    tU16 u16AmpDevSubSource;
};

class fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc
      : public ahl_tclBaseOneThreadClientHandler, public fc_audioroutemgr_tclTraceInput
{
  public:

    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(tVoid);
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc(fc_audioroutemgr_tclApp* poMainAppl,fc_audioroutemgr_tclresourcemanager* poResourceMgr);
    virtual ~fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc();

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc& operator=
      (const fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    tVoid vPerformMute(tU8 ,tU8, tU16);
    tVoid vPerformMute(tU8 ,tU8, tU16, tU16);
    tVoid vPerformMute_Ramp(tU8 ,tU8 );
    tVoid vPerformMute_Ramp(tU8 ,tU8, tU16);
    tVoid vPerformSpeakerTest();
    tVoid vPerformDeMute(tU8 ,tU8 );
    tVoid vPerformDeMute(tU8 ,tU8, tU16);
    tVoid vStartAudioSource(tU8 ,tU8 );
    tVoid vStartAudioSource(tU8 ,tU8, tU16);
    tVoid vPerformComponentMute(tU8 requestingSource,tU8 State,tU32 Reason, tU8 Channel, tU8 Requester=1,tU8 Resource=1);
    tVoid vPerformMuteOnAppStateChange();
    tVoid vPerformMuteRampOnAppStateChange();
    tVoid vSendAudioPropertyDataToFCAM(tU8 Source, tU8 Type, tS32 Offset);
    tVoid vSetVolumeLock(source::enVolumeLockType Locktype);
  // inbox for TTFis
    virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
    void vSendAmpDeviceAudioRoute(tU8 CurSrc, tU16 SubSource, tU16 Sink); //only one of both is needed
    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

   DECLARE_MSG_MAP(fc_audioroutemgr_tclClientHandler_AudioRouteMgr_AudioFunc)

  private:

   tBool m_bComponentMuteFlag[Streams];
   tU8 m_u8Channel;
   tU8 m_u8Source;
   tU16 m_u16SubSource;
   tU8 m_u8MuteState;
   tU8 m_u8CompMuteState[Streams];
   tU8 m_u8CompRequestingSource[Streams];

   //changed to map to handle multiple AmpDevAudioRoute messages in parallel
   std::map<tU32,tsAmpDevAudioRouteParam> m_AmpDevAudioRouteParamMap;


   fc_audioroutemgr_tclresourcemanager* m_poResourceManager;
   fc_audioroutemgr_tclApp* m_poMainAppl;

   //Pending mute requests
   std::map<midw_fi_tcl_e8_AudioChannel::tenType, midw_fi_tcl_e8MuteAction::tenType> m_pendingmute;

   tVoid vHandleAudioSource_MethodResult(amt_tclServiceData* poMessage) const;
   tVoid vHandleSetMuteRamp_MethodResult(amt_tclServiceData* poMessage) const;
   tVoid vHandleMute_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleAmpDevAudioRoute_MethodResult(amt_tclServiceData* poMessage);
   tVoid vHandleMute_Error(amt_tclServiceData* poMessage) const;
   fc_audioroutemgr_tclsourcefactory* poSourceFactory() const;
   std::map<midw_fi_tcl_e8_AudSource::tenType, midw_fi_tcl_e8_Aud_EDType::tenType> m_MapSrcToEDType;
   tVoid vMuteRequestonChannel(midw_mascffi_tclMsgMuteMethodStart objMute, midw_fi_tcl_e8_AudioChannel::tenType channel);
   tBool bSendARMMuteMessage(midw_fi_tcl_e8MuteAction::tenType action,const midw_fi_tcl_e8_AudioChannel::tenType channel);
};

#endif // _FC_AUDIOROUTEMGR_CLIENTHANDLER_AUDIOROUTEMGR_AUDIOFUNC_H_

