#ifndef STREAM_MUTE_IF_H
#define STREAM_MUTE_IF_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "StreamMuteNotify_IF.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/ADR3StreamType.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/Fading_Reason.h"
#include "../../Fading/Fading_IF.h"

class StreamMute_IF
{
public:
  enum tenStreamMuteaction
  {
    MUTE_ACTION_NONE = 0,
    MUTE_ACTION_MUTE = 1,
    MUTE_ACTION_DEMUTE = 2
  };
  enum
  {
    INTERNAL_BEH = 1,
    EXTERNAL_BEH = 2,
    BEH_NONE = 3
  };

/*
  enum
  {
    STREAM_NONE = 0,
    STREAM_EXC = 1,
    STREAM_MIX = 2,
    STREAM_MIX2 = 3,
    STREAM_MAX = 4,
    STREAM_ALL = (1<<STREAM_EXC)|(1<<STREAM_MIX)|(1<<STREAM_MIX2)
  };

*/
  virtual void muteStream(tU8 muteReq, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream)=0;
  virtual void muteStream(tU8 muteReq, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream, tU16 Sink)=0;
  virtual tU8 registerForStreamMute(tU8 beh, StreamMuteNotify_IF* muteReqObj, tU8 initReq=MUTE_ACTION_NONE, tU8 muteMask=0)=0;
  virtual tVoid vInitFading(Fading_IF* poFading)=0;
  virtual tBool bIsMuteRequested(tU8 muteReq, tenStream stream)=0;
  virtual tVoid vMuteResponseTimeOut(tVoid)=0;
  virtual tVoid vDeleteMuteResponseTimer() = 0;
  virtual ~StreamMute_IF(){}
};
#endif
