#ifndef STREAM_MUTE_H
#define STREAM_MUTE_H


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_TYPES
#include "osal_if.h"

//#define SYSTEM_S_USE_std
//#define SYSTEM_S_IMPORT_INTERFACE_VECTOR
//#include <stl_pif.h>



#include <vector>




#include "StreamMute_IF.h"
#include "StreamMuteNotify_IF.h"
#include "../../InternalComponentCommunication/DataTypes/TypeDefines/MuteAction.h"
#include "../../Fading/Fading_IF.h"

using namespace std;

class StreamMuteReq
{
public:
  enum
  {
    NO_REQ = 0,
    MUTE_REQ = 1,
    DEMUTE_REQ = 2
  };
  StreamMuteReq(tU8 id, tU8 b, StreamMuteNotify_IF* Notify_impl, tU8 initReq, tU8 muteMask)
  {
    tU8 streamIndex;
    reqId = id;
    OSAL_pvMemorySet(req, StreamMute_IF::MUTE_ACTION_NONE, sizeof(req));
    if(initReq == StreamMute_IF::MUTE_ACTION_MUTE)
    {
      for(streamIndex = EN_AUDIO_SOURCE_STREAM_DEFAULT;streamIndex < EN_AUDIO_SOURCE_STREAM_MAX; streamIndex++)
      {
        if(muteMask & (1<<streamIndex))
        {
          req[streamIndex] = StreamMute_IF::MUTE_ACTION_MUTE;
        }
      }
    }
    OSAL_pvMemorySet(ack, StreamMuteNotify_IF::MUTE_ACK_CLR, sizeof(ack));
    u8beh = b;
    muteOnStream = EN_AUDIO_SOURCE_STREAM_DEFAULT;
    StreamMuteNotify_impl = Notify_impl;
  }
  tU8 reqId;
  tU8 req[EN_AUDIO_SOURCE_STREAM_MAX];
  tU8 ack[EN_AUDIO_SOURCE_STREAM_MAX];
  tU8 Normal_ack[EN_AUDIO_SOURCE_STREAM_MAX];
  tU8 Private_ack[EN_AUDIO_SOURCE_STREAM_MAX];
  tU8 Analog_ack[EN_AUDIO_SOURCE_STREAM_MAX];
  tU8 u8beh;
  tU8 muteOnStream;
   StreamMuteNotify_IF* StreamMuteNotify_impl;
};
class StreamMute: public StreamMute_IF
{
public:
  StreamMute();
  virtual ~StreamMute();
  static StreamMute* getInstance()
  {
    static StreamMute sm;
    return &sm;
  }

  static tVoid vMuteResponseTimeOutTimerCallback(tVoid* pArg);
  tVoid notifyMute(tenStream stream,tenSinks enResource = Speaker);
  tVoid notifyDemute(tenStream stream,tenSinks enResource =Speaker );
  tVoid notifyDemuteRunning(tenStream stream,tenSinks enResource = Speaker)const;
  virtual tVoid muteStream(tU8 muteReq, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream);
  virtual tVoid muteStream(tU8 muteReq, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream, tU16 Sink);
  virtual tU8 registerForStreamMute(tU8 u8beh, StreamMuteNotify_IF* muteReqObj, tU8 initReq=MUTE_ACTION_NONE, tU8 muteMask=0);
  tBool checkAnyMute(tenStream stream);
  tVoid clearMute(tU8 muteReq, tenStream stream , tenFadingReason reason);
  tVoid clearMute(tU8 muteReq, tenStream stream , tenFadingReason reason, tU16 Sink);
  tVoid setMuteReq(tU8 muteReqId, tenStream stream , tenFadingReason reason);
  tVoid setMuteReq(tU8 muteReqId, tenStream stream , tenFadingReason reason, tU16 Sink);
  tVoid sendDemuteAckToExtReq(tU8 muteReqId, tenStream stream);
  StreamMuteReq* getMuteRequester(tU8 muteReqId);
  tVoid vTTFisCmd(tenMuteTTFisCommands cmd, tU8* data);
  virtual tVoid vInitFading(Fading_IF* poFading){pFading = poFading;}
  virtual tBool bIsMuteRequested(tU8 muteReq, tenStream stream);
  virtual tVoid vMuteResponseTimeOut(tVoid);
  virtual tVoid vDeleteMuteResponseTimer();
  vector<StreamMuteReq> muteReqVector;
  vector<StreamMuteReq> demuteReqVector;
  tU8 regId;
  Fading_IF* pFading;

};

#endif
