#include "StreamMute.h"
#include "StreamMute_IF.h"
#include "StreamMuteNotify_IF.h"

#include "../../InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "../../InternalComponentCommunication/Messages/mute/IDSetMute.h"
#include "fc_audiomanager_main.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
//#define ET_TRACE_INFO_ON
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_MASCFFI_TYPES
#include "etrace_if.h"
#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
//#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_VOLUME
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/StreamMute.cpp.trc.h"
#endif

OSAL_tTimerHandle  m_hMuteResponseTimeOutTimer;

StreamMute::StreamMute()
{
  regId = 0;
  pFading = NULL;

  tS32 s32OsalError;
  s32OsalError = OSAL_s32TimerCreate( (OSAL_tpfCallback)vMuteResponseTimeOutTimerCallback,
      0, &m_hMuteResponseTimeOutTimer );
  ETG_TRACE_USR4(("s32OsalError = %d ",s32OsalError));//To solve compiler warning

}

/*
* tVoid StreamMute::vDeleteMuteResponseTimer()
* DESCRIPTION: Stopping & Deleting Response Timer
*/

tVoid StreamMute::vDeleteMuteResponseTimer()
{
  if( m_hMuteResponseTimeOutTimer != OSAL_C_INVALID_HANDLE)
  {
   // In GTEST, this will be executed outside of the test environment, because the singleton
   // instance is static. So in GTEST, the call to OSAL_s32TimerDelete is ommitted to avoid
   // an error message from OSAL MockDelegatee.
#ifndef GTEST_INCLUDE_GTEST_GTEST_H_
    tS32 s32RetVal = OSAL_s32TimerSetTime(m_hMuteResponseTimeOutTimer, 0, 0); //stopping the timer before delete.
    if (s32RetVal == OSAL_OK)
    {
      tS32 s32OsalError = OSAL_s32TimerDelete(m_hMuteResponseTimeOutTimer);
      NORMAL_M_ASSERT(s32OsalError == OSAL_OK);
    }
#endif // GTEST_INCLUDE_GTEST_GTEST_H_
    m_hMuteResponseTimeOutTimer = OSAL_C_INVALID_HANDLE;
  }
  pFading = NULL;
}

StreamMute::~StreamMute()
{
  pFading = NULL;
}

tVoid StreamMute::vMuteResponseTimeOutTimerCallback(tVoid* pArg){
  (tVoid)pArg;    /* unused parameter */
  fc_audiomanager_tclApp::vEventFromOtherThreads(FC_AUDIOMANAGER_EVENT_ID_MUTE_RESPONSE_TIMEOUT);
}

tVoid StreamMute::vMuteResponseTimeOut(tVoid)
{
  ETG_TRACE_USR4(("vMuteResponseTimeOut"));

  tU8 stream;
  for(stream = (tU8)EN_AUDIO_SOURCE_STREAM_MAIN; stream < (tU8)EN_AUDIO_SOURCE_STREAM_MIX3; stream++)
  {
    notifyMute((tenStream)stream);
  }
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::muteStream()
 *
 * DESCRIPTION: implements the muteStream interface.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tVoid StreamMute::muteStream(tU8 u8muteReqId, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream)
{
   ETG_TRACE_USR4(("muteStream called with no sink, use Sink 1"));
   muteStream(u8muteReqId, action, Reason, stream, 1);
}
tVoid StreamMute::muteStream(tU8 u8muteReqId, tenStreamMuteaction action,tenFadingReason Reason, tenStream stream, tU16 Sink)
{
  //ETG_TRACE_USR4(("muteStream   ReqId:%d   action:%d reason:%d  stream:%d, sink %d", u8muteReqId, action, Reason, stream, Sink));
  if(action == StreamMute_IF::MUTE_ACTION_MUTE)
  {
    ETG_TRACE_USR4(("muteStream   ReqId:%d   action:%d (MUTE) reason:%d  stream:%d, sink %d", u8muteReqId, action, Reason, stream, Sink));
    setMuteReq(u8muteReqId, stream , Reason, Sink);
  }
  else if(action == StreamMute_IF::MUTE_ACTION_DEMUTE)
  {
    ETG_TRACE_USR4(("muteStream   ReqId:%d   action:%d (DEMUTE) reason:%d  stream:%d, sink %d", u8muteReqId, action, Reason, stream, Sink));
    clearMute(u8muteReqId, stream , Reason, Sink);
    //sendDemuteAckToExtReq(u8muteReqId, stream);
  }
}

tBool StreamMute::bIsMuteRequested(tU8 muteReq, tenStream stream)
{
  StreamMuteReq* s = getMuteRequester(muteReq);
  if(s == NULL) return false;
  if((s->req[stream] == StreamMuteReq::MUTE_REQ) && (s->ack[stream] == StreamMuteNotify_IF::MUTE_ACK_MUTE))
  {
    return true;
  }
  return false;
}
/*******************************************************************************
 *
 * FUNCTION: StreamMute::registerForStreamMute()
 *
 * DESCRIPTION: implements the muteStream interface.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
tU8 StreamMute::registerForStreamMute(tU8 u8beh, StreamMuteNotify_IF* muteReqObj, tU8 initReq, tU8 muteMask)
{
  ++regId;
  muteReqVector.push_back(StreamMuteReq(regId, u8beh,muteReqObj, initReq, muteMask));
  ETG_TRACE_USR4(("registerForStreamMute   behavior:%x and initial request:%x with mute mask:%x", u8beh, initReq, muteMask));
  return regId;
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::sendDemuteAckToExtReq()
 *
 * DESCRIPTION: sends acknowledgements: DEMUTE_RUNNING and DEMUTED to
 *         EXT requesters
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid StreamMute::sendDemuteAckToExtReq(tU8 u8muteReqId, tenStream stream)
{
  tBool bOtherExtReq = FALSE;
  StreamMuteReq* s = getMuteRequester(u8muteReqId);
  vector<StreamMuteReq>::iterator muteReqIterator;

  ETG_TRACE_USR4(("sendDemuteAckToExtReq u8muteReqId %d, stream %d",u8muteReqId, (int)stream));
  for(muteReqIterator = muteReqVector.begin();muteReqIterator != muteReqVector.end();muteReqIterator++)
  {
    if((muteReqIterator->reqId == u8muteReqId) && (muteReqIterator->u8beh == StreamMute_IF::INTERNAL_BEH))
    {
      return;
    }
    else
    {
      if((muteReqIterator->req[stream] == StreamMuteReq::MUTE_REQ) && (muteReqIterator->u8beh == StreamMute_IF::EXTERNAL_BEH) && (muteReqIterator->reqId != u8muteReqId))
      {
        bOtherExtReq = TRUE;
        break;
      }
    }
  }
  if(bOtherExtReq == FALSE)
  {
    if((s != NULL) && (s->u8beh == StreamMute_IF::EXTERNAL_BEH))
    {
      s->ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
      s->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE_RUNNING, stream);
      s->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE, stream);
    }
  }
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::notifyMute()
 *
 * DESCRIPTION: when notification for mute is received, it checks if there have
 *        been mute requested on the stream and accordingly informs
 *         mute requesters
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid StreamMute::notifyMute(tenStream stream,tenSinks enResource)
{
  if(muteReqVector.empty())
  {
    ETG_TRACE_USR2(("notifyMute   stream:%d, muteReqVector is empty", stream));
    return;
  }
  ETG_TRACE_USR2(("Added notifyMute   stream:%d, Sink %d", stream,enResource));
  vector<StreamMuteReq>::iterator muteReqIterator;
  for(muteReqIterator = muteReqVector.begin();muteReqIterator != muteReqVector.end();muteReqIterator++)
  {
     if(enResource == Speaker)
     {
        ETG_TRACE_USR3(("ADDED notifying mute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));

        if(muteReqIterator->Normal_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_MUTE)
        {
           muteReqIterator->Normal_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying mute requester:%d, having requested %u for stream %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream], ETG_CENUM(tenStream, stream)));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_MUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyMute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
     else if(enResource == Headphone)
     {
        ETG_TRACE_USR3(("ADDED notifying mute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));

        if(muteReqIterator->Private_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_MUTE)
        {
           muteReqIterator->Private_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying mute requester:%d, having requested %u for stream %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream], ETG_CENUM(tenStream, stream)));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_MUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyMute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
     else if(enResource == Sink17)
     {
        ETG_TRACE_USR3(("ADDED notifying mute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));
        if(muteReqIterator->Analog_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_MUTE)
        {
	   muteReqIterator->Analog_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying mute requester:%d, having requested %u for stream %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream], ETG_CENUM(tenStream, stream)));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_MUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyMute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
  }
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::notifyDemute()
 *
 * DESCRIPTION: when notification for demute is received, it checks if there have
 *        been demute requested on the stream and accordingly informs
 *         mute requesters
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid StreamMute::notifyDemute(tenStream stream,tenSinks enResource)
{
  if(muteReqVector.empty())
  {
    ETG_TRACE_USR2(("notifyDemute   stream:%d, muteReqVector is empty", stream));
    return;
  }
  ETG_TRACE_USR2(("Added notifyDemute   stream:%d, Sink %d", stream,enResource));
  vector<StreamMuteReq>::iterator muteReqIterator;
  for(muteReqIterator = muteReqVector.begin();muteReqIterator != muteReqVector.end();muteReqIterator++)
  {
     if(enResource == Speaker)
     {
        ETG_TRACE_USR3(("ADDED notifying demute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));
        if(muteReqIterator->Normal_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_DEMUTE)
        {
           muteReqIterator->Normal_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying demute requester:%d, having requested %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream]));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyDemute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
     else if(enResource == Headphone)
     {
        ETG_TRACE_USR3(("ADDED notifying demute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));
        if(muteReqIterator->Private_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_DEMUTE)
        {
           muteReqIterator->Private_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying demute requester:%d, having requested %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream]));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyDemute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
     else if(enResource == Sink17)
     {
        ETG_TRACE_USR3(("ADDED notifying demute requester:%d, having requested %u"
              , muteReqIterator->reqId, muteReqIterator->req[stream]));
        if(muteReqIterator->Analog_ack[stream] == StreamMuteNotify_IF::MUTE_ACK_DEMUTE)
	{
           muteReqIterator->Analog_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_CLR;
           ETG_TRACE_USR3(("notifying demute requester:%d, having requested %u"
                 , muteReqIterator->reqId, muteReqIterator->req[stream]));
           muteReqIterator->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE, stream,enResource);
        }
        else if (muteReqIterator->ack[stream] != StreamMuteNotify_IF::MUTE_ACK_CLR)  // expected other notification
        {
           ETG_TRACE_USR4(("notifyDemute   RequesterId: %u - waiting for ack[%u] = %u"
                 , muteReqIterator->reqId, ETG_CENUM(tenStream, stream), muteReqIterator->ack[stream]));
        }
     }
  }
}

tVoid StreamMute::notifyDemuteRunning(tenStream stream,tenSinks enResource)const
{
  //to be done
  (tVoid)stream;
  (tVoid)enResource;
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::clearMute()
 *
 * DESCRIPTION: validates demute request against all the mute/demute requests
 *        for the stream and eventually processes demute
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid StreamMute::clearMute(tU8 muteReq, tenStream stream , tenFadingReason reason)
{
   ETG_TRACE_USR4(("clearMute called with no Sink, use Sink 1"));
   clearMute(muteReq,  stream , reason, 1);
}
tVoid StreamMute::clearMute(tU8 muteReq, tenStream stream , tenFadingReason reason, tU16 Sink)
{
  StreamMuteReq* s = getMuteRequester(muteReq);
  if(s == NULL) return;

  s->req[stream] = StreamMuteReq::DEMUTE_REQ;
  s->muteOnStream &=  (tU8)(~(1<<stream)); //gen4 [-wcoversion] compiler warning fix

  s->ack[stream] = StreamMuteNotify_IF::MUTE_ACK_DEMUTE_RUNNING;
  s->StreamMuteNotify_impl->StreamMuteNotify(StreamMuteNotify_IF::MUTE_ACK_DEMUTE_RUNNING, stream, Sink);
  s->ack[stream] = StreamMuteNotify_IF::MUTE_ACK_DEMUTE;

  if(Sink == Speaker)
  {
     s->Normal_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_DEMUTE;
  }
  else if(Sink == Headphone)
  {
     s->Private_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_DEMUTE;
  }
  else if(Sink == Sink17)
  {
     s->Analog_ack[stream] = StreamMuteNotify_IF::MUTE_ACK_DEMUTE;
  }

  ETG_TRACE_USR3(("clearMute()   ReqId: %u for stream: %u with reason %u, muteOnStream = 0x%x, sink %d"
        , muteReq, ETG_CENUM(tenStream, stream), ETG_CENUM(tenFadingReason, reason), s->muteOnStream, Sink));

  //if( (checkAnyMute(stream) == FALSE) || (Sink == midw_fi_tcl_e8_ResourceNo::FI_EN_AUDIO_LINE_OUT) )
	  if( (checkAnyMute(stream) == FALSE) || (Sink == 17) )
  {
    // send PO message to demute ADR..
    if(pFading == NULL) return;
    tU16 RampL=pFading->fading_getRampLin(EN_AUDIO_FADING_ACTION_DEMUTE,reason,stream);
    tU16 Rampd=pFading->fading_getRampdB(EN_AUDIO_FADING_ACTION_DEMUTE,reason,stream);
    //tU16 Sink=pFading->getSink(); //don't overwrite the given parameter
    ID_SetMute setMute(stream,EN_AUDIO_MUTE_MUTEACTION_Off,RampL,Rampd,Sink);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setMute);
  }
  else
  {
    ETG_TRACE_USR4(("inside clearMute, No Demute due to active mute !!!"));
  }
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::setMuteReq()
 *
 * DESCRIPTION: makes a mute on a stream
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
#define MUTE_RESPONSE_TIMEOUT_TIME 1000
tVoid StreamMute::setMuteReq(tU8 u8muteReqId, tenStream stream , tenFadingReason reason)
{
   ETG_TRACE_ERR(("setMuteReq() aclled with no sink, use Sink 1"));
   setMuteReq(u8muteReqId, stream , reason, 1);
}

tVoid StreamMute::setMuteReq(tU8 u8muteReqId, tenStream stream , tenFadingReason reason, tU16 Sink)
{
  tS32 s32RetVal;
  StreamMuteReq* s = getMuteRequester(u8muteReqId);
  if(s == NULL) return;
  s->req[stream] = StreamMuteReq::MUTE_REQ;
  s->ack[stream] = StreamMuteNotify_IF::MUTE_ACK_MUTE;
  s->muteOnStream = (tU8)(s->muteOnStream |(1<<stream));  //gen4 prio3 compiler warning fix

  ETG_TRACE_USR3(("setMuteReq()   ReqId: %u for stream: %u with reason %u, muteOnStream = 0x%x, Sink %d"
        , u8muteReqId, ETG_CENUM(tenStream, stream), ETG_CENUM(tenFadingReason, reason), s->muteOnStream, Sink));

  if(Sink == Speaker)
  {
     s->Normal_ack[stream] = s->ack[stream];
  }
  else if(Sink == Headphone)
  {
     s->Private_ack[stream] = s->ack[stream];
  }
  else if(Sink == Sink17)
  {
     s->Analog_ack[stream] = s->ack[stream];
  }

  if(pFading == NULL) return;
  tU16 RampL=pFading->fading_getRampLin(EN_AUDIO_FADING_ACTION_MUTE,reason,stream);
  tU16 Rampd=pFading->fading_getRampdB(EN_AUDIO_FADING_ACTION_MUTE,reason,stream);
    //daw2hi: added
  tU16 FadingSink=pFading->getSink();
  ETG_TRACE_FATAL(("setMuteReq() Sink %d, FadingSink %d",Sink, FadingSink));
  // send PO message to mute ADR..
  ID_SetMute setMute(stream,EN_AUDIO_MUTE_MUTEACTION_On,RampL,Rampd, Sink);
  InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&setMute);

  s32RetVal = OSAL_s32TimerSetTime( m_hMuteResponseTimeOutTimer, (tU32) MUTE_RESPONSE_TIMEOUT_TIME, 0);
  if (OSAL_OK != s32RetVal)
  {
     ETG_TRACE_ERR(("setMuteReq()  failed setting timer - s32RetVal = %d", s32RetVal));
  }
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::getMuteRequester()
 *
 * DESCRIPTION: returns pointer to mute requster based on requester ID
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
StreamMuteReq* StreamMute::getMuteRequester(tU8 u8muteReqId)
{
  StreamMuteReq* s=NULL;
  vector<StreamMuteReq>::iterator muteReqIterator;
  for(muteReqIterator = muteReqVector.begin();muteReqIterator != muteReqVector.end();muteReqIterator++)
  {
    if(muteReqIterator->reqId == u8muteReqId)
    {
      s = &(*muteReqIterator);
      break;
    }
  }
  return s;
}

/*******************************************************************************
 *
 * FUNCTION: StreamMute::checkAnyMute()
 *
 * DESCRIPTION: checks if there are any mute on the stream
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tBool StreamMute::checkAnyMute(tenStream stream)
{
  vector<StreamMuteReq>::iterator muteReqIterator;
  for(muteReqIterator = muteReqVector.begin();muteReqIterator != muteReqVector.end();muteReqIterator++)
  {
    if(muteReqIterator->req[stream] == StreamMuteReq::MUTE_REQ)
    {
      ETG_TRACE_USR3(("checkAnyMute()   found mute request from requester %u for stream %u "
            , muteReqIterator->reqId, stream));
      return TRUE;
    }
  }

  ETG_TRACE_USR3(("checkAnyMute()   no mute requests found for stream:%d", stream));

  return FALSE;
}


/*******************************************************************************
 *
 * FUNCTION: StreamMute::vTTFisCmd()
 *
 * DESCRIPTION: function to handle TTFis input commands
 *
 * PARAMETER:
 *
 * RETURNVALUE:
 *
 *******************************************************************************/
tVoid StreamMute::vTTFisCmd(tenMuteTTFisCommands cmd, tU8* data)
{
  switch(cmd)
  {
  case EN_AUDIO_TTFIS_CMD_MUTE: // mute
    switch(data[1])
    {
    case 1:
      muteStream(data[0], StreamMute_IF::MUTE_ACTION_MUTE,EN_AUDIO_FADING_RES_SOURCESEL, EN_AUDIO_SOURCE_STREAM_MAIN);
      break;
    case 2:
      muteStream(data[0], StreamMute_IF::MUTE_ACTION_DEMUTE,EN_AUDIO_FADING_RES_SOURCESEL, EN_AUDIO_SOURCE_STREAM_MAIN);
      break;
    default:
      break;
    }
    break;
  case EN_AUDIO_TTFIS_CMD_MUTE_NOTIFY: // notify mute
    switch(data[0])
    {
    case 1:
      notifyMute(EN_AUDIO_SOURCE_STREAM_MAIN);
      break;
    case 2:
      notifyDemuteRunning(EN_AUDIO_SOURCE_STREAM_MAIN);
      break;
    case 3:
      notifyDemute(EN_AUDIO_SOURCE_STREAM_MAIN);
      break;
    default:
      break;
    }
    break;
  default:
    break;
  }
}
