/*
 * SinkMute.h
 *
 *  Created on: Jan 7, 2013
 *      Author: sss4kor
 */

#ifndef SINKMUTE_H_
#define SINKMUTE_H_

#include "StreamMuteNotify_IF.h"
#include "StreamMute_IF.h"
#include "InternalComponentCommunication/DataTypes/TypeDefines/SourceDefines.h"
/*******************************************************************************
 *
 * CLASS: SinkMute
 *
 *******************************************************************************/
class SinkMute: public IF_MessageObserver<PO_MessageConfig::enID>, public StreamMuteNotify_IF

{
public:
   InternalCommunicationAdapter* pPO; // Pointer for post office access
   StreamMute_IF* pStreamMute;

   tU8 muteRegId;
   tBool TCUMuteRadioOrderState;
   tenInternalSource m_u8ActiveMainStreamSource;

   SinkMute();


   SinkMute(StreamMute_IF* pStreamMute);
   tU8 u8getMuteRegId() const;

   virtual ~SinkMute()
   {
     InternalCommunicationAdapter::getInstance()->POMessages->DeRegisterObserver(this);
     //delete(pPO);
     pPO = NULL;
     delete(pStreamMute);
   }
   void addObserver();
   //void demuteMixStream();

   virtual void MessageNotification(PO_MessageConfig::enID MsgId);
   virtual void StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink);
};




#endif /* SINKMUTE_H_ */
