#define ETRACE_S_IMPORT_INTERFACE_GENERIC
// #define ET_TRACE_INFO_ON
#include <etrace_if.h>   // implicitly links generic <osal_if.h>

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/SinkMute.cpp.trc.h"
#endif

#include "../../util/Macro.h"

// from InternalComponentCommunication
#include "InternalCommunicationAdapter.h"
#include "Messages/mute/IDCCAResultMute.h"
#include "Messages/mute/IDCCAStartMute.h"
#include "Messages/mute/IDTCUMuteRadioOrder.h"
#include "Messages/mute/IDNotifySystemMute.h"
#include "Messages/Source/IDSetAudioRoute.h"
#include "DataTypes/TypeDefines/MuteAction.h"
#include "Messages/Source/IDIntSource.h"
#include "SinkMute.h"

/*******************************************************************************
 *
 * FUNCTION: SinkMute::SinkMute()
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER:None
 *
 * RETURN TYPE : None
 *
 *******************************************************************************/

SinkMute::SinkMute(StreamMute_IF* m_pStreamMute) :
        IF_MessageObserver<PO_MessageConfig::enID>("SinkMute Observer which observes on ServiceFunction")
{
    ETG_TRACE_USR4(("SinkMute Observer constructor"));

    m_u8ActiveMainStreamSource = AUD_INT_SRC_NOSOURCE;
    muteRegId = 0;
    TCUMuteRadioOrderState = false;

    pStreamMute = m_pStreamMute;
    pPO = InternalCommunicationAdapter::getInstance();

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pStreamMute);
    muteRegId = pStreamMute->registerForStreamMute(StreamMute_IF::INTERNAL_BEH, this);

    addObserver();
    ETG_TRACE_USR4(("SinkMute Observer: constructor"));

}
/*******************************************************************************
 *
 * FUNCTION: void SinkMute::addObserver()
 *
 * DESCRIPTION:Gets called when AddSource observer has to be registered to post office
 *
 * PARAMETER:None
 *
 * RETURN TYPE : Void
 *
 *******************************************************************************/
void SinkMute::addObserver()
{
    ETG_TRACE_USR4(("SinkMute: addObserver"));

    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
    AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::IDIntSource);
    pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_TCUMuteRadioOrder);

    ETG_TRACE_USR4(("SinkMute Observer created"));

}

/*void SinkMute::demuteMixStream()
 {
 StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
 pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX1);
 }*/
/*******************************************************************************
 *
 * FUNCTION: void SinkMute
 * ::MessageNotification(PO_MessageConfig::enID MsgId)
 *
 * DESCRIPTION:This function is called by post office on new incoming messages which is addressed to SinkMute.
 *
 * PARAMETER:PO_MessageConfig::enID MsgId
 *
 * RETURN TYPE : Void
 *
 *******************************************************************************/

void SinkMute::MessageNotification(PO_MessageConfig::enID MsgId)
{
    ETG_TRACE_USR4(("SinkMute::MessageNotification called from Thread: 0x%x", OSAL_ThreadWhoAmI()));
    ETG_TRACE_USR4(("SinkMute::MessageNotification MsgId: 0x%x", MsgId));

    switch (MsgId)
    {
    case PO_MessageConfig::IDIntSource:
    {
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);
        const IDIntSource* pMsg = pPO->POMessages->QueryMessage < IDIntSource > (MsgId);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

        ETG_TRACE_USR4(("Sink_Mute Observer ActiveMainStream Source : %d", pMsg->value.m_Source));

        if (pMsg->value.m_Channel == midw_fi_tcl_e8_AudioChannel::FI_EN_AUDIO_CHANNEL_EXC)
        {
            m_u8ActiveMainStreamSource = pMsg->value.m_Source;

            if (TCUMuteRadioOrderState)
            {
                StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_NONE;
                if (m_u8ActiveMainStreamSource == AUD_INT_SRC_TCU_ECALL)
                {
                    action = StreamMute_IF::MUTE_ACTION_DEMUTE;
                }
                else
                {
                    action = StreamMute_IF::MUTE_ACTION_MUTE;
                }
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MAIN);
            }

        }
        break;
    }
    case PO_MessageConfig::ID_TCUMuteRadioOrder:
    {
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO->POMessages);
        const ID_TCUMuteRadioOrder* pMsg = pPO->POMessages->QueryMessage < ID_TCUMuteRadioOrder > (MsgId);
        AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pMsg);

        ETG_TRACE_USR4(("Sink_Mute Observer has received action : %x", pMsg->bTCUMute));
        TCUMuteRadioOrderState = pMsg->bTCUMute;

        if (pStreamMute != NULL)
        {
            if (pMsg->bTCUMute)
            {
                ETG_TRACE_USR4(("Muting all streams"));
                StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_MUTE;

                if (pMsg->bTCUMute && m_u8ActiveMainStreamSource != AUD_INT_SRC_TCU_ECALL)
                {
                    pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MAIN);
                }
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MIX1);
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MIX2);

                ID_NotifySystemMute sysMute(muteRegId, 0x01, EN_AUDIO_MUTE_MUTEACTION_On, EN_AUDIO_FADING_RES_OTHER);
                pPO->POMessages->DeliverMsg(&sysMute);
            }
            else
            {
                ETG_TRACE_USR4(("DeMuting all streams"));
                StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MAIN);
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MIX1);
                pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER, EN_AUDIO_SOURCE_STREAM_MIX2);

                ID_NotifySystemMute sysMute(muteRegId, 0x01, EN_AUDIO_MUTE_MUTEACTION_Off, EN_AUDIO_FADING_RES_OTHER);
                pPO->POMessages->DeliverMsg(&sysMute);
            }
        }
    }
        break;
    default:
        break;
    }
}

void SinkMute::StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink)
{
    (tVoid) muteAck;
    (tVoid) stream;
    (tVoid) sink;
    ETG_TRACE_USR4(("SinkMute::StreamMuteNotify called from Thread: 0x%x", OSAL_ThreadWhoAmI()));

}

tU8 SinkMute::u8getMuteRegId(tVoid) const
{
    return muteRegId;
}/*
 * SinkMute.cpp
 *
 *  Created on: Jan 7, 2013
 *      Author: sss4kor
 */

