
/************************************************************************FA*
 *File         :  ARM_Proxy.cpp
 *----------------------------------------------------------------------------
 *Copyright         : (c) 2012 Robert Bosch GmbH, Hildesheim
 *Author            : Anu Sebastian(RBEI/ECV)
 *---------------------------------------------------------------------------
 Created by :      Anu Sebastian       Initial version
 ************************************************************************/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
// #define ET_TRACE_INFO_ON
#include <etrace_if.h>    // implicitly links generic <osal_if.h>

#include "../../fc_audiomanager_trace.h"
#include "../../fc_audiomanager_trace_macros.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/ARM_Proxy.cpp.trc.h"
#endif

// from InternalComponentCommunication
#include "InternalCommunicationAdapter.h"
#include "Messages/mute/IDCCAResultMute.h"
#include "Messages/mute/IDCCAStartMute.h"
#include "Messages/Source/IDSetAudioRoute.h"
#include "Messages/mute/IDMuteStateHandleVoltage.h"
#include "DataTypes/TypeDefines/MuteAction.h"

#include "../../util/Macro.h"
#include "ARM_Proxy.h"

/*******************************************************************************
 *
 * FUNCTION: ARM_Proxy::ARM_Proxy()
 *
 * DESCRIPTION: Constructor
 *
 * PARAMETER:None
 *
 * RETURN TYPE : None
 *
 *******************************************************************************/
/*
ARM_Proxy::ARM_Proxy() :
    IF_MessageObserver<PO_MessageConfig::enID>("ARM_Proxy Observer which observes on ServiceFunction")
{
  ETG_TRACE_USR4(("ARM_Proxy Observer constructor"));

  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

  pStreamMute = StreamMute::getInstance();
  muteRegId = pStreamMute->registerForStreamMute(StreamMute_IF::EXTERNAL_BEH, this);

   addObserver();
   ETG_TRACE_USR4(("ARM_Proxy Observer: constructor"));
}
*/

ARM_Proxy::ARM_Proxy(StreamMute_IF* m_pStreamMute) :
        IF_MessageObserver<PO_MessageConfig::enID>("ARM_Proxy Observer which observes on ServiceFunction")
{
  ETG_TRACE_USR4(("ARM_Proxy Observer constructor"));

  pPO = InternalCommunicationAdapter::getInstance();
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);

  bLowVoltageActive = false;
  pStreamMute = m_pStreamMute;
  muteRegId = pStreamMute->registerForStreamMute(StreamMute_IF::EXTERNAL_BEH, \
                          this, \
                          StreamMute_IF::MUTE_ACTION_MUTE, \
                          (1<<EN_AUDIO_SOURCE_STREAM_MAIN)|(1<<EN_AUDIO_SOURCE_STREAM_MIX1)|(1<<EN_AUDIO_SOURCE_STREAM_MIX2));

   addObserver();
   ETG_TRACE_USR4(("ARM_Proxy Observer: constructor"));
   //demuteMixStream();
}
/*******************************************************************************
 *
 * FUNCTION: void ARM_Proxy::addObserver()
 *
 * DESCRIPTION:Gets called when AddSource observer has to be registered to post office
 *
 * PARAMETER:None
 *
 * RETURN TYPE : Void
 *
 *******************************************************************************/
void ARM_Proxy::addObserver()
{
   ETG_TRACE_USR4(("ARM_Proxy: addObserver"));

  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(pPO);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_CCAStart_Mute);
  // pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_NotifyStartup);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_SetAudioRoute);
   pPO->POMessages->AddObserver(this, PO_MessageConfig::ID_MuteState_HandleVoltage);
   ETG_TRACE_USR4(("ARM_Proxy Observer created"));

}

//resource has default sink 1
void ARM_Proxy::demuteMixStream(tU16 resource)
{
   StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_DEMUTE;
   pStreamMute->muteStream(muteRegId, action, EN_AUDIO_FADING_RES_OTHER,EN_AUDIO_SOURCE_STREAM_MIX1,resource);
}

/*******************************************************************************
 *
 * FUNCTION: void ARM_Proxy
 * ::MessageNotification(PO_MessageConfig::enID MsgId)
 *
 * DESCRIPTION:This function is called by post office on new incoming messages which is addressed to ARM_Proxy.
 *
 * PARAMETER:PO_MessageConfig::enID MsgId
 *
 * RETURN TYPE : Void
 *
 *******************************************************************************/

void ARM_Proxy::MessageNotification(PO_MessageConfig::enID MsgId)
{
  ETG_TRACE_USR4(("ARM_Proxy::MessageNotification called from Thread: 0x%x", OSAL_ThreadWhoAmI()));
  ETG_TRACE_USR4(("ARM_Proxy::MessageNotification MsgId: 0x%x", MsgId));

  switch(MsgId)
   {
      //case PO_MessageConfig::ID_NotifyStartup:
  case PO_MessageConfig::ID_SetAudioRoute:
  { const MSG_SetAudioRoute* pMsg = pPO->POMessages->QueryMessage<MSG_SetAudioRoute>(MsgId);
    if(pMsg->enStream == EN_AUDIO_SOURCE_STREAM_MIX1)
       demuteMixStream(pMsg->Resource);
    break;
  }
  case PO_MessageConfig::ID_MuteState_HandleVoltage:
  {
    const ID_MuteState_HandleVoltage* pMsg = pPO->POMessages->QueryMessage<ID_MuteState_HandleVoltage>(MsgId);
    if(pMsg->en_VoltageState == EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_START)
    {
      bLowVoltageActive = true;
      if(pStreamMute->bIsMuteRequested(muteRegId, EN_AUDIO_SOURCE_STREAM_MAIN))
      {
        StreamMuteNotify(MUTE_ACK_MUTE, (tU8)EN_AUDIO_SOURCE_STREAM_MAIN,1); //have to hardcode to 1 here
      }
    }
    else if(pMsg->en_VoltageState == EN_AUDIO_VOLTAGESTATE_CRITICAL_LOW_VOLTAGE_END)
    {
      bLowVoltageActive = false;
    }
    else
    {
    }
    break;
  }
    case PO_MessageConfig::ID_CCAStart_Mute:
    {   /* Obtaining the CCA_Mute_Start Message from CCA handler by ARM_Proxy*/

   const ID_CCAStart_Mute* pMsg = pPO->POMessages->QueryMessage<ID_CCAStart_Mute>(MsgId);

   ETG_TRACE_USR4(("ARM_Proxy Observer has received Requester: %x, Reason: %x , Resource(Stream):%x , State : %x, for Sink %d",
        pMsg->Requester,pMsg->Reason,pMsg->Resource,pMsg->State,pMsg->Sink));

   /*
    * Calling of mute/demute stream and receiving of mutenotify-------------To be implemented
    */

   StreamMute_IF::tenStreamMuteaction action = StreamMute_IF::MUTE_ACTION_MUTE;

   if(pMsg->State == EN_AUDIO_MUTE_MUTEACTION_Off)
   {
     action = StreamMute_IF::MUTE_ACTION_DEMUTE;

   }

   pStreamMute->muteStream(muteRegId, action, tenFadingReason(pMsg->Reason),tenStream(pMsg->Resource),pMsg->Sink);
   if((action == StreamMute_IF::MUTE_ACTION_MUTE) && (bLowVoltageActive == true))
   {
     StreamMuteNotify(MUTE_ACK_MUTE, tenStream(pMsg->Resource),pMsg->Sink);
   }

   break;
    }
      default:
         ETG_TRACE_USR4(("ARM_Proxy::MessageNotification unknown Message %x",MsgId));
         break;
     }

}



void ARM_Proxy::StreamMuteNotify(tenMuteNotification muteAck, tU8 stream, tU16 sink)
{
  ETG_TRACE_USR4(("ARM_Proxy::StreamMuteNotify called from Thread: 0x%x for stream %d, sink %d", OSAL_ThreadWhoAmI(), stream, sink));

  tenMuteResult muteResult = EN_AUDIO_MUTE_MUTERESULT_MUTE;
  switch(muteAck)
  {
    case MUTE_ACK_DEMUTE:
      muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE;
      break;
    case MUTE_ACK_DEMUTE_RUNNING:
      muteResult = EN_AUDIO_MUTE_MUTERESULT_DEMUTE_RUNNING;
      break;
    default:
      break;
  }

  ID_CCAResult_Mute CCAResult_Mute(1,stream,muteResult,sink);

  //Delivering the ID_CCAResult_Mute  Message back to Service Function
  ID_CCAResult_Mute resultMute(CCAResult_Mute.Requester,CCAResult_Mute.Resource,CCAResult_Mute.State,sink);
  pPO->POMessages->DeliverMsg(&resultMute);

  ETG_TRACE_USR4(("ARM_Proxy::StreamMuteNotify sent to audio service handler with requester: 0x%x, resource: 0x%x, state: 0x%x, sink %d",
		  CCAResult_Mute.Requester,CCAResult_Mute.Resource,CCAResult_Mute.State,sink));
}

tU8 ARM_Proxy::u8getMuteRegId(tVoid)const
{
  return muteRegId;
}
