
/*******************************************************************************
*
* FILE:          fc_audiomanager_clienthandler_VehicleData.h
*
* SW-COMPONENT:  FC_Audiomanager application
*
* PROJECT:
*
* DESCRIPTION:   CCA client-handler for the service Vehicle data
*
* AUTHOR:         Medha Manjunath Hegde
*
* COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
*
*******************************************************************************/
#include "../ExternItf/CCA/aud_CCAMsg.h"
#ifndef _FC_AUDIOMANAGER_CLIENTHANDLER_VEHICLEDATA_H_
#define _FC_AUDIOMANAGER_CLIENTHANDLER_VEHICLEDATA_H_
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
/*#include "InternalComponentCommunication/Messages/mute/IDMuteStateHandleVoltage.h"
#include "InternalComponentCommunication/Messages/power/ID_SysPowerMode.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"*/

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadClientHandler;

class fc_audiomanager_tclClientHandler_VehicleData
      : public ahl_tclBaseOneThreadClientHandler
{
  public:

    fc_audiomanager_tclClientHandler_VehicleData(tVoid);
    fc_audiomanager_tclClientHandler_VehicleData(fc_audiomanager_tclApp* poMainAppl);
    virtual ~fc_audiomanager_tclClientHandler_VehicleData();

    //tVoid MessageNotification(PO_MessageConfig::enID MsgId);

    /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audiomanager_tclClientHandler_AudioManagerspm' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
    fc_audiomanager_tclClientHandler_VehicleData& operator=
      (const fc_audiomanager_tclClientHandler_VehicleData &oClientHandler);

    /***************************************************************************
    * Application specific methods.
    ***************************************************************************/
    tVoid vProcessTimer(tU16 u16TimerId) const;

    /***************************************************************************
    * Overriding ahl_tclBaseOneThreadClientHandler methods.
    ***************************************************************************/
    virtual tVoid vOnServiceAvailable();
    virtual tVoid vOnServiceUnavailable();

    /***************************************************************************
    * Handler function declarations used by message map.
    ***************************************************************************/

    // Add your CCA message handler function prototypes here.

    /***************************************************************************
    * Message map definition macro
    ***************************************************************************/

  private:

  tVoid vOnPartialMute(amt_tclServiceData* poMessage);
  tVoid vOnFullCanMute(amt_tclServiceData* poMessage);
  std::map<tU8, tS16> m_AttenuationDBMAp;
  fc_audiomanager_tclApp* poMainApplInstance;
    DECLARE_MSG_MAP(fc_audiomanager_tclClientHandler_VehicleData);
};

#endif // _FC_AUDIOMANAGER_CLIENTHANDLER_AUDIOMANAGERSPM_H_



