/*******************************************************************************
 *
 * FILE:          fc_audiomanager_service_Client_Handler_Phone
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA service Audio_Diagnosis.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/
/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/
#include "fc_audiomanager_main.h"
#include "fc_audiomanager_service_Client_Handler_Phone.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO

#include "conn_most_fi_if.h"

//#define ET_TRACE_INFO_ON
#include "etrace_if.h"
#include "fc_audiomanager_trace.h"
#include "fc_audiomanager_trace_macros.h"
#include "InternalComponentCommunication/InternalCommunicationAdapter.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_PhoneDeviceList.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_SERVICE_AUDIO_FUNCTION
#include "trcGenProj/Header/fc_audiomanager_service_Client_Handler_Phone.cpp.trc.h"
#endif
/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/

// this comment is for Eclispe formatting issues only
BEGIN_MSG_MAP(fc_audiomanager_service_Client_Handler_Phone, ahl_tclBaseWork)
// this comment is for Eclispe formatting issues only
ON_MESSAGE_SVCDATA( MOST_BTSETFI_C_U16_DEVICELISTEXTENDED , AMT_C_U8_CCAMSG_OPCODE_STATUS , vHandle_DeviceList_Status )
END_MSG_MAP()

#define MAX_PHONETYPES 11
/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_service_Client_Handler_Phone::fc_audiomanager_service_Client_Handler_Phone(fc_audiomanager_tclApp* poMainAppl)
 *
 * DESCRIPTION: Constructor.
 *              Create an object of the base class
 *              ahl_tclBaseOneThreadClientHandler with a pointer to this
 *              application, the to be used service identifier and the service
 *              version as parameters.
 * PARAMETER  : [IN] poMainAppl = Pointer to the object of this application.
 * RETURNVALUE: None.
 *******************************************************************************/
fc_audiomanager_service_Client_Handler_Phone::fc_audiomanager_service_Client_Handler_Phone(fc_audiomanager_tclApp* poMainAppl) :
      ahl_tclBaseOneThreadClientHandler(
      /* Application Pointer              */poMainAppl,
      /* ID of offered Service            */CCA_C_U16_SRV_FB_BLUETOOTHSETTINGS,
      /* MajorVersion of offered Service  */MOST_BTSETFI_C_U16_SERVICE_MAJORVERSION,
      /* MinoreVersion of offered Service */MOST_BTSETFI_C_U16_SERVICE_MINORVERSION) //,
/* PatchVersion of offered Service  *///FC_AUDIOMANAGER_SERVICE_AUDIO_CLIENT_HANDLER_FI_PATCH_VERSION)  //Don't provide this. Registration won't work.
{
   ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Phone_Phone() entered."));

   vAddAutoRegisterForProperty(MOST_BTSETFI_C_U16_DEVICELISTEXTENDED);
   vInitDeviceListMap();
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_service_Client_Handler_Phone::~fc_audiomanager_service_Client_Handler_Phone(tVoid)
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 *******************************************************************************/
fc_audiomanager_service_Client_Handler_Phone::~fc_audiomanager_service_Client_Handler_Phone(tVoid)
{
   ETG_TRACE_USR4(("~fc_audiomanager_service_Client_Handler_Phone() entered."));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_service_Client_Handler_Phone::vOnServiceAvailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become available.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceAvailable().
 *******************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Phone::vOnServiceAvailable()
{
   ETG_TRACE_USR4(("vOnServiceAvailable() entered. AppID = %u.",u16GetServerAppID()));

}

/*******************************************************************************
 *
 * FUNCTION: tVoid fc_audiomanager_service_Client_Handler_Phone::vOnServiceUnavailable()
 *
 * DESCRIPTION: This function is called by the CCA framework when the service
 *              which is offered by this server has become unavailable.
 *
 * PARAMETER: None.
 *
 * RETURNVALUE: None.
 *
 ********************************************************************************
 * Overrides method ahl_tclBaseOneThreadService::vOnServiceUnavailable().
 *******************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Phone::vOnServiceUnavailable()
{
   ETG_TRACE_USR4(("vOnServiceUnavailable() entered. AppID = %u.",u16GetServerAppID()));
}

/**********************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Phone::vInitDeviceListMap()
{
  for( tU8 i = 2; i <= MAX_PHONETYPES; i++) //valid values for DeviceHandle is 2..11
    {
      m_DeviceAvailMap[i] = false;
    }
}

/**********************************************************************************/ //
tVoid fc_audiomanager_service_Client_Handler_Phone::vHandle_DeviceList_Status(amt_tclServiceData* poMessage)
{
  ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Phone: vHandle_DeviceList_Status\n"));

  vector<tU8> tempVector;


  if ( poMessage != OSAL_NULL )
    {
      fi_tclVisitorMessage oVisitorMsg( poMessage );
      most_btsetfi_tclMsgDeviceListExtendedStatus inDeviceListStatus;
      oVisitorMsg.s32GetData(inDeviceListStatus);

      std::vector<most_fi_tcl_BTSetDeviceListExtendedResultItem>::const_iterator DeviceListIterator;

      if(inDeviceListStatus.oDeviceListExtendedResult.oItems.empty())
  {
    ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Phone: DeviceList Empty"));
    vInitDeviceListMap();
  }
      else
  {
    for( DeviceListIterator = inDeviceListStatus.oDeviceListExtendedResult.oItems.begin();
        DeviceListIterator != inDeviceListStatus.oDeviceListExtendedResult.oItems.end();
        DeviceListIterator++)
      {
        tU8 deviceno = (*DeviceListIterator).u8DeviceHandle;

        ETG_TRACE_USR4(("fc_audiomanager_service_Client_Handler_Phone: Device Handle : %d", deviceno));

        tempVector.push_back(deviceno);
      }

    sort(tempVector.begin(), tempVector.end());

    vector<tU8>::iterator it = tempVector.begin();

    for(tU8 i = 2; i <= MAX_PHONETYPES ; i++)
      {
        if( (it != tempVector.end()) && (i == *it) ) //valid values for DeviceHandle is 2..11
    {
      m_DeviceAvailMap[i] = true;
      it++;
      ETG_TRACE_USR4(("Phone Type Paired : %d", i));
    }
        else
    {
      m_DeviceAvailMap[i] = false;
    }
      }
  }

      ID_PhoneDeviceList odevicelist(m_DeviceAvailMap);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&odevicelist);
    }
}

