/*******************************************************************************
 *
 * FILE:          fc_audiomanager_main.h
 *
 * SW-COMPONENT:  fc_audiomanager application
 *
 * PROJECT:
 *
 * DESCRIPTION:   CCA Application.
 *
 * AUTHOR:
 *
 * COPYRIGHT:    (c) 2010 Robert Bosch GmbH, Hildesheim
 *
 *******************************************************************************/

#ifndef _FC_AUDIOMANAGER_MAIN_H_
#define _FC_AUDIOMANAGER_MAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include "util/Macro.h"
#include "fc_audiomanager_trace_input.h"

#include "LoopBack/aud_loopback_if.h"

// FunctionID for non-Service-related Loopback messages
#define FC_AUDIOMANAGER_TRACE_STREAM_FID  0xfffe

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/
// ***   AHL_MAX_TIMERS 5                              **********
// ***   use only FC_AUDIOMANAGER_TIMER_ID  0...4 !!!  **********
enum
{
  FC_AUDIOMANAGER_TIMER_ID_100MS,   // regularly ticking timer every 100ms
  FC_AUDIOMANAGER_TIMER_ID_BEEP,
  FC_AUDIOMANAGER_TIMER_ID_MIC_DIAG,
  FC_AUDIOMANAGER_TIMER_ID_PING
  };

#define FC_AUDIOMANAGER_TIMER_PING_INTERVAL 2000
#define FC_AUDIOMANAGER_TIMER_PING_FIRST_INTERVAL 2000


enum
{
  FC_AUDIOMANAGER_EVENT_ID_PING,
  FC_AUDIOMANAGER_EVENT_ID_CHECK_PWR_AMP,
  FC_AUDIOMANAGER_EVENT_ID_SINK_DEMUTE,
  FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_OFF,
  FC_AUDIOMANAGER_EVENT_ID_SINK_ADR3_STANDBY,
  FC_AUDIOMANAGER_EVENT_ID_SPECIAL_MUTE,
  FC_AUDIOMANAGER_EVENT_ID_CHECK_ACC,
  FC_AUDIOMANAGER_EVENT_ID_SINK_BOOSTER_ON,
  FC_AUDIOMANAGER_EVENT_ID_MUTE_RESPONSE_TIMEOUT,
  FC_AUDIOMANAGER_EVENT_ID_ARKAMYS,
    FC_AUDIOMANAGER_EVENT_ID_VEHICLEDOMAIN_CHECK_ALIVE,
  FC_AUDIOMANAGER_EVENT_ID_EXTAMPLIFIER_CONNECTION
};

// lowest 6 Byte are available 0xXX000001 for bPostEvent
const tU32 FC_AUDIOMANAGER_AHL_EVENT_CHECK_PWR_AMP    = 0x00000001;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_SINK_DEMUTE      = 0x00000002;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_SINK_BOOSTER_OFF = 0x00000004;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_SINK_ADR3_STANDBY= 0x00000008;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_SPECIAL_MUTE     = 0x00000010;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_CHECK_ACC        = 0x00000020;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_BOOSTER_ON       = 0x00000040;
//Adding new events to process mute response timeout
const tU32 FC_AUDIOMANAGER_AHL_EVENT_MUTE_TIMEOUT     = 0x00000080;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_ARKAMYS          = 0x00000200;

const tU32 FC_AUDIOMANAGER_AHL_EVENT_VEHICLEDOMAIN_CHECK_ALIVE = 0x00000400;
const tU32 FC_AUDIOMANAGER_AHL_EVENT_EXTAMPLIFIER_CONNECTION = 0x00000800; //Added to check the External Amplifier connection status
const tU32 FC_AUDIOMANAGER_AHL_EVENT_LOOPBACK_MSG_AVAILABLE = 0x00001000; //Added for the convenience of the loopback manager

/**
* EVENTS FOR WORKER THREAD
**/
const tU32 FC_AUDIOMANAGER_WORKER_THREAD_EV_READ_MIC_DIAG  = 0x00000001;
/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class aud_async_call_handler;
class ahl_tclBaseOneThreadApp;

class fc_audiomanager_tclService_Audio_Function;

class fc_audiomanager_tclAudio_Diagnosis; //Fofi changed: the declaration of the main diagnosis class

class fc_audiomanager_service_Client_Handler_Phone;
class fc_audiomanager_service_Client_Handler_Tel_Fi;
class aud_sinkmgr_main;

class fc_audiomanager_tclTraceChannel;

class Beep_Main;

class Booster;
class BoosterDiaglogHandler;

class fc_audiomanager_tclClientHandler_AudioManagerspm;

class fc_audiomanager_IClientHandler_Vehicle;
class fc_audiomanager_tclClientHandler_DiagLog;
class Audio_clipping;

class aud_gio_dbus_handler;
#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
class VehicleDomainHandlerMain;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
#include "fc_audiomanager_clienthandler_Diagnostics.h"
class fc_audiomanager_tclClientHandler_Diagnostics;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
class EngineSoundHandler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
#include "fc_audiomanager_csmSignal_Handler.h"
class fc_audiomanager_csmSignal_Handler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
#include "fc_audiomanager_clienthandler_profilemanager.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
#include "fc_audiomanager_tclClientHandler_VehicleData.h"
#endif
class fc_audiomanager_tclApp: public ahl_tclBaseOneThreadApp, public fc_audiomanager_tclTraceInput, public ahl_tclEventThread
{
   static fc_audiomanager_tclApp* m_poMainAppInstance;

public:
   fc_audiomanager_tclApp (tVoid);
   virtual ~fc_audiomanager_tclApp (tVoid);

   // method to create server object -- called by SPM
   static fc_audiomanager_tclApp* theServer();
   fc_audiomanager_tclService_Audio_Function* pGetAudioFunctionptr()
   { return m_poAudio_Function;}
   fc_audiomanager_tclAudio_Diagnosis* pGetAudioDiagFunctionptr()
   { return m_poAudio_Diagnosis;}
   aud_sinkmgr_main* pGetSinkMgrptr()
   {
	   return m_poSinkMgr;
   }
   /**************************************************************************
    * Assingment Operater, will not be implemented.
    * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class
    * 'fc_audiomanager_tclApp' which has no assignment operator.
    * NOTE: This is a technique to disable the assignment operator for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_audiomanager_tclApp& operator=(const fc_audiomanager_tclApp &ofc_audiomanager);

   /**************************************************************************
    * Copy Constructor, will not be implemented.
    * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class
    * 'fc_audiomanager_tclApp' which has no copy constructor.
    * NOTE: This is a technique to disable the copy constructor for this
    * class. So if an attempt for the assignment is made compiler complains.
    **************************************************************************/
   fc_audiomanager_tclApp(const fc_audiomanager_tclApp &ofc_audiomanager);

   /**************************************************************************
    * Overriding ahl_tclBaseOneThreadApp methods.
    **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnTimer(tU16 nTimerId);
   virtual tVoid vOnLoadSettings();
   virtual tVoid vOnSaveSettings();
   virtual tVoid vOnEvent(OSAL_tEventMask nEvent);

   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);
   //virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclBaseMessage* poMessage);
   virtual tVoid vOnLoopback(tU16 , amt_tclBaseMessage* )
   {
     // only dummy to avoid error messages from AHL framework. Don't add any code here !!!!
   };


   // register all trace channels
   tVoid vRegisterTraceInputs(tVoid);
   // to register trace channels from other subcomponents
   tVoid vRegisterTraceInputs(tU32 uInputNum, fc_audiomanager_tclTraceInput* pclInput)const;

   // inbox for TTFis
   virtual tVoid vTraceRx(tU32 size, tPCUChar pcu8Data);
   static tVoid  vRxFromOtherThreads_Callback(tPCUChar pcu8Data);
   static tVoid  vRxFromOtherThreads (tU32 size, tPCUChar pcu8Data);
   static tVoid vEventFromOtherThreads(tU16 uEvent);
   Beep_Main* m_poBeepMain;
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   fc_audiomanager_csmSignal_Handler* m_poCsmHandler;
#endif
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_RNAIVI
   Booster*    m_poBooster;
   BoosterDiaglogHandler*  m_poBoosterDiaglogHandler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_PSA_LINUX
   fc_audiomanager_tclClientHandler_Diagnostics* m_poClientHandlerDiagnostics;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_ENGINE_SOUND_PSA
   EngineSoundHandler* m_poEngineSoundHandler;
#endif
   /**
   * HELPER FUNCTIONS
   */
   aud_gio_dbus_handler*  poDBus() {return m_pGioDbusHandler;};
   aud_async_call_handler*  poAsyncCall(){return m_asynccall;};

   fc_audiomanager_tclClientHandler_DiagLog* m_poClientHandlerDiagLog;

private:
   tBool m_EnableLoopbackTrace;
   fc_audiomanager_tclService_Audio_Function* m_poAudio_Function;
   fc_audiomanager_service_Client_Handler_Phone* m_poCLientHandlerPhone;

   fc_audiomanager_service_Client_Handler_Tel_Fi* m_poClientHandlerTelFi;
   //Fofi changed: the service diagnosis FI of the audio subsystem (mascd_fi) is obsolete and can be removed.
   //Here will declared the main diagnosis class
   fc_audiomanager_tclAudio_Diagnosis* m_poAudio_Diagnosis;
   fc_audiomanager_tclClientHandler_AudioManagerspm* m_poAudioManagerspm;
   fc_audiomanager_IClientHandler_Vehicle* m_poClientHandlerVehicle;

   Audio_clipping* m_poAudioClipping;
   aud_sinkmgr_main* m_poSinkMgr;

   aud_gio_dbus_handler*  m_pGioDbusHandler;
   aud_tcl_loopback_mgr*  m_ploopback;
   aud_async_call_handler*  m_asynccall;

#ifdef VARIANT_S_FTR_ENABLE_VEHICLEDOMAIN_COMM
  VehicleDomainHandlerMain* m_pVehicleDomainHandler;
#endif

#ifdef VARIANT_S_FTR_ENABLE_AUD_USR_PROFILE
   fc_audiomanager_tclClientHandler_profilemanager* m_pProfileMgr;
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_PARTIAL_MUTE_INF4CV
  fc_audiomanager_tclClientHandler_VehicleData* m_pVehicleData;
#endif
   // trace input channel
   static fc_audiomanager_tclTraceChannel* _poTrace;

protected:
  virtual tBool bThreadFunction(OSAL_tEventMask u32EventMask);

};


#endif //_FC_AUDIOMANAGER_MAIN_H_

