/*******************************************************************************
 *
 * FILE:          fc_audiomanager_csmSignal_Handler.h
 *
 * SW-COMPONENT:  CSM Handler to receive CAN signals
 *
 * PROJECT:
 *
 * DESCRIPTION:  CSM Handler to receive CAN signals
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/
#ifndef _FC_AUDIOMANAGER_CSMSIGNAL_HANDLER_H_
#define _FC_AUDIOMANAGER_CSMSIGNAL_HANDLER_H_


#include <sys/types.h>
#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER
#include "csm_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_FEAT_AUDIO_CSM_RNAIVI
#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM   // CSM_C_PROJECT_RN_AIVI will be enabled to test this ADAS feature for IVI
#include "midw_common_if.h"
#endif

#include "fc_audiomanager_main.h"
#include "../fc_audiomanager_trace_input.h"


#include "LoopBack/aud_loopback_if.h"
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"



#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
class CSMInterface;
#endif

class fc_audiomanager_csmSignal_Handler
{

public:

  fc_audiomanager_csmSignal_Handler(fc_audiomanager_tclApp* poMainAppl);
  fc_audiomanager_csmSignal_Handler();
    virtual ~fc_audiomanager_csmSignal_Handler();

  tVoid vRegisterForCSMSignals();
    tVoid vForceCSMSignalRead();
  tVoid vTransmitCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType);
  tVoid vRxSignal_MuteRadioOrder(tU32 tu32SignalId);
  tVoid vRxSignal_TCU_MuteRadioOrder(tU32 tu32SignalId);
  tVoid vRxSignal_FAP_SoundLevelControl(tU32 tu32SignalId);
  tVoid vRxSignal_HFP_MapContentDisplay(tU32 tu32SignalId);
  tVoid vTriggerHFP_Display(tU8 HFPDisplay);
private:

  typedef std::map<tU32, tU8> _CSMSignalMap; //parameters are signal Id, Signal Value
  _CSMSignalMap m_CSMSignalMap;

  static tVoid vSignalIndCallback( tVoid* /*pHandle*/,tU32 tu32SignalId, tU32 u32SignalStatus);

  void bSignalIndASyncCall(tU32 u32SignalId,tU32 u32SignalStatus);

    static fc_audiomanager_csmSignal_Handler *_poThisInterface;

  fc_audiomanager_tclApp* poMainApplInstance;

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  CSMInterface* _poMyCSMInterface;
#endif
  aud_async_call_handler*  m_asynccall;
};

#endif
