/*******************************************************************************
 *
 * FILE:          fc_audiomanager_csmSignal_Handler.cpp
 *
 * SW-COMPONENT:  CSM Handler to receive CAN signals
 *
 * PROJECT:
 *
 * DESCRIPTION:  CSM Handler to receive CAN signals
 *
 * AUTHOR:       pmh7kor
 *
 * COPYRIGHT:    (c) 2016 RBEI, Bangalore
 *
 *******************************************************************************/


/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
#include "../fc_audiomanager_trace.h"
#include "fc_audiomanager_csmSignal_Handler.h"
#include "Beep_defines.h"
#include "../fc_audiomanager_main.h"
#include "InternalCommunicationAdapter.h"
#include "../fc_audiomanager_service_Audio_Function.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_AUDIOMANAGER_APPLICATION
#include "trcGenProj/Header/fc_audiomanager_csmSignal_Handler.cpp.trc.h"
#endif

#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_CANAttenuation.h"
#include "InternalComponentCommunication/Messages/mute/IDTCUMuteRadioOrder.h"
#include "InternalComponentCommunication/Messages/Volume/VolumeManager/ID_FAPAttenuation.h"

fc_audiomanager_csmSignal_Handler *fc_audiomanager_csmSignal_Handler::_poThisInterface = NULL;

/******************************************************************************/
/* FUNCTION     fc_audiomanager_csmSignal_Handler()                                     */
/******************************************************************************/
/**
*  \brief       default constructor - should not be used
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
fc_audiomanager_csmSignal_Handler::fc_audiomanager_csmSignal_Handler()
{

  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler() called"));
  poMainApplInstance = OSAL_NULL;
    // store pointer to myself for access in callbacks
    _poThisInterface = this;
     m_asynccall = NULL;    //You are not supposed to use default constructor

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
     _poMyCSMInterface = NULL;
#endif
  //m_ploopback = NULL;
    NORMAL_M_ASSERT_ALWAYS();

}

/******************************************************************************/
/* FUNCTION     fc_audiomanager_csmSignal_Handler()                                     */
/******************************************************************************/
/**
*  \brief       constructor
*
*  \param       Beep_Main* poBeepMainAppl: main - object of this application
*  \return      none
*/
/******************************************************************************/

fc_audiomanager_csmSignal_Handler::fc_audiomanager_csmSignal_Handler( fc_audiomanager_tclApp* poMainAppl )
{
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler(fc_audiomanager_tclApp* poMainAppl) called"));
  poMainApplInstance = poMainAppl;

    // store pointer to myself for access in callbacks
    _poThisInterface = this;
  m_asynccall = poMainApplInstance->poAsyncCall();

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  _poMyCSMInterface = new CSMInterface();

  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_MuteRadioOrder,0)); // included for task CMG3G-11301
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_TCU_MuteRadioOrder,0));
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_FAP_SoundLevelControl,0));
  if((poMainApplInstance->pGetAudioFunctionptr()->IsPremium2Connected()))
  {
  m_CSMSignalMap.insert(std::pair<tU32, tU8>(CSM_C_ASIG_RX_HFP_MapContentDisplay, 0));
  }
#endif
}

/******************************************************************************/
/* FUNCTION     ~fc_audiomanager_csmSignal_Handler()                                    */
/******************************************************************************/
/**
*  \brief       destructor
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
fc_audiomanager_csmSignal_Handler::~fc_audiomanager_csmSignal_Handler()
{
  ETG_TRACE_USR4(("~fc_audiomanager_csmSignal_Handler() called"));
  poMainApplInstance = NULL;
  m_asynccall = NULL;
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  if(_poMyCSMInterface != NULL)
  {
    delete _poMyCSMInterface;
    _poMyCSMInterface = NULL;
  }
#endif
}

/******************************************************************************/
/* FUNCTION     vRegisterCSMSignalsForAdas                                   */
/******************************************************************************/
/**
*  \brief       registers the necessary CAN signals for the Sonar functionality
*
*  \param       none
*  \return      none
*/
/******************************************************************************/
tVoid fc_audiomanager_csmSignal_Handler::vRegisterForCSMSignals()
{
#if !defined (LSIM)

#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM

  ETG_TRACE_USR4((" fc_audiomanager_csmSignal_Handler::vRegisterForCSMSignals(), Callback registration for CAN Signals"));
  tU32 u32CsmHandle;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  std::map<tU32, tU8>:: const_iterator it;

  for(it = m_CSMSignalMap.begin(); it != m_CSMSignalMap.end(); ++it )
  {
    //Register for the CAN signal call backs
      if(_poMyCSMInterface->CSM_lSignalCallbackInit((tVoid*)&u32CsmHandle,it->first, vSignalIndCallback) < CSM_C_NO_ERROR)
    {
      ETG_TRACE_FATAL(("!!!!! E R R O R in registering call back for signal"));
    }
  }
#endif
#endif

}
/******************************************************************************/
/* FUNCTION     vTransmitCsmBroadcastSignal                                   */
/******************************************************************************/
/**
*  \brief       writes data to VCAN
*
*  \param       tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType
*  \return      none
*/
/******************************************************************************/
tVoid fc_audiomanager_csmSignal_Handler::vTransmitCsmBroadcastSignal(tU8* pabData, tU8 u8Len, tU32 u32CsmSignal, tU8 u8TxType)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
    tU32 u32CsmHandle = 0;
    tS32 s32Ret = 0;
    tU8 paData = 1;
  ETG_TRACE_USR4((" vTransmitCsmBroadcastSignal......"));
   if(_poMyCSMInterface!= NULL)
    {
    s32Ret = _poMyCSMInterface->CSM_lSignalWrite((tVoid *)&u32CsmHandle,u32CsmSignal,
      pabData,
      u8Len,
      u8TxType);

    }

    if(s32Ret < CSM_C_NO_ERROR)
    {

        ETG_TRACE_USR4((" Signal Write error or Data Invalid......"));
    }
    else
    {
        ETG_TRACE_USR4((" Signal written Successfully......"));
    }
#endif
#endif
    (void)pabData;
    (void)u8Len;
    (void)u32CsmSignal;
    (void)u8TxType;
}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_csmSignal_Handler::vSignalIndCallback(tVoid*,tU32 u32SignalId, tU32 u32SignalStatus)
 *******************************************************************************/
tVoid fc_audiomanager_csmSignal_Handler::vSignalIndCallback(tVoid*/*pHandle*/,tU32 u32SignalId, tU32 u32SignalStatus)
{
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vSignalIndCallback() called"));
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poThisInterface);
  _poThisInterface->bSignalIndASyncCall(u32SignalId, u32SignalStatus);

}

/*******************************************************************************
 *
 * FUNCTION: fc_audiomanager_csmSignal_Handler::vSignalIndCallback(tU32 u32SignalId, tU32 u32SignalStatus)
 *******************************************************************************/

tVoid fc_audiomanager_csmSignal_Handler::bSignalIndASyncCall(tU32 u32SignalId, tU32 u32SignalStatus)
{
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::bSignalIndASyncCall() called"));
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(m_asynccall);

  switch(u32SignalId)
  {
    case CSM_C_ASIG_RX_MuteRadioOrder:
      ETG_TRACE_USR4(("CSM_C_ASIG_RX_MuteRadioOrder"));
      m_asynccall->vCall<fc_audiomanager_csmSignal_Handler,tU32>(_poThisInterface,&fc_audiomanager_csmSignal_Handler::vRxSignal_MuteRadioOrder,u32SignalId);
      break;
    case CSM_C_ASIG_RX_TCU_MuteRadioOrder:
      ETG_TRACE_USR4(("CSM_C_ASIG_RX_TCU_MuteRadioOrder"));
      m_asynccall->vCall<fc_audiomanager_csmSignal_Handler,tU32>(_poThisInterface,&fc_audiomanager_csmSignal_Handler::vRxSignal_TCU_MuteRadioOrder,u32SignalId);
      break;
    case CSM_C_ASIG_RX_FAP_SoundLevelControl:
      ETG_TRACE_USR4(("CSM_C_ASIG_RX_FAP_SoundLevelControl"));
      m_asynccall->vCall<fc_audiomanager_csmSignal_Handler,tU32>(_poThisInterface,&fc_audiomanager_csmSignal_Handler::vRxSignal_FAP_SoundLevelControl,u32SignalId);
    case CSM_C_ASIG_RX_HFP_MapContentDisplay:
      ETG_TRACE_USR4(("CSM_C_ASIG_RX_HFP_MapContentDisplay"));
      m_asynccall->vCall<fc_audiomanager_csmSignal_Handler,tU32>(_poThisInterface,&fc_audiomanager_csmSignal_Handler::vRxSignal_HFP_MapContentDisplay,u32SignalId);
    default:
      break;
  }
#else
  (tVoid)u32SignalId;
  (tVoid)u32SignalStatus;
#endif
}

tVoid fc_audiomanager_csmSignal_Handler::vRxSignal_MuteRadioOrder(tU32 tu32SignalId)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vRxSignal_MuteRadioOrder() called"));
  // to post PO message to volume manager to attenuate streams
  tBool  au8Data_ReadBuffer = FALSE;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;

    tBool bChanged = FALSE;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, tu32SignalId,&au8Data_ReadBuffer,1,&u32StatusRead))
    {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }

  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.find(tu32SignalId);

  if(u32StatusRead & CSM_C_SIGNAL_TIMEOUT)
  {

    //to do: need to reset the attenuation?
  }
  else if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
  {
    if (it != m_CSMSignalMap.end())
    {
      if(it->second != au8Data_ReadBuffer){
        it->second = au8Data_ReadBuffer;
        bChanged = TRUE;
      }
    }
    }
   ETG_TRACE_USR4(("Beep_CSMSignalInterface:: it->second : %x",it->second));

  if(bChanged)
  {
    ID_CANAttenuation oCanAttenuation(au8Data_ReadBuffer);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oCanAttenuation);
  }
#else
  (tVoid)tu32SignalId;
#endif
#endif
}

tVoid fc_audiomanager_csmSignal_Handler::vRxSignal_FAP_SoundLevelControl(tU32 tu32SignalId)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vRxSignal_FAP_SoundLevelControl() called"));
  // to post PO message to volume manager to attenuate streams
  tU8  au8Data_ReadBuffer = 0;
        tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
        tU32 u32CsmHandle;

        tBool bChanged = FALSE;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, tu32SignalId,&au8Data_ReadBuffer,1,&u32StatusRead))
        {
            u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
        }

  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.find(tu32SignalId);

  if(u32StatusRead & CSM_C_SIGNAL_TIMEOUT)
  {
      ID_FAPAttenuation oFAPAttenuation(0);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oFAPAttenuation);
  }
  else if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
  {
    if (it != m_CSMSignalMap.end())
    {
      if(it->second != au8Data_ReadBuffer)
      {
          it->second = au8Data_ReadBuffer;
          bChanged = TRUE;
      }
    }
         }

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: FAP_SoundLevelControl : %x",it->second));

  if(bChanged)
    {
      ETG_TRACE_USR4(("Beep_CSMSignalInterface:: Posting FAP_SoundLevelControl message"));
      ID_FAPAttenuation oFAPAttenuation(au8Data_ReadBuffer);
      InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oFAPAttenuation);
    }
#else
  (tVoid)tu32SignalId;
#endif
#endif
}
tVoid fc_audiomanager_csmSignal_Handler::vRxSignal_HFP_MapContentDisplay(tU32 tu32SignalId)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vRxSignal_HFP_MapContentDisplay() called"));
  tBool  au8Data_ReadBuffer = FALSE;
    tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
    tU32 u32CsmHandle;
    tBool bChanged = FALSE;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, tu32SignalId,&au8Data_ReadBuffer,1,&u32StatusRead))
    {
        u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
    }
  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.find(tu32SignalId);
  if(u32StatusRead & CSM_C_SIGNAL_TIMEOUT)
  {
  }
  else if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
  {
    if (it != m_CSMSignalMap.end())
    {
      if(it->second != au8Data_ReadBuffer){
        it->second = au8Data_ReadBuffer;
        bChanged = TRUE;
      }
    }
    }
   ETG_TRACE_USR4(("Beep_CSMSignalInterface:: it->second : %x",it->second));
  if(bChanged)
  {
    if((poMainApplInstance->pGetAudioFunctionptr())!= NULL)
    {
     vTriggerHFP_Display(au8Data_ReadBuffer);

    }
  }
#else
  (tVoid)tu32SignalId;
#endif
#endif
}
tVoid fc_audiomanager_csmSignal_Handler::vTriggerHFP_Display(tU8 HFPDisplay)
{
  ETG_TRACE_USR4(("ADAS_HFPSound::vTriggerHFP_Display() called with current value %d",HFPDisplay));
    if((HFPDisplay==1) || (HFPDisplay==2) || (HFPDisplay==3))

  {
      if(!(poMainApplInstance->pGetAudioFunctionptr()->bIsHFPActive()))
      {
    ETG_TRACE_USR4(("Received HFP value is: %d",HFPDisplay));
      poMainApplInstance->pGetAudioFunctionptr()->HFPDisplay_Active(true);
      }
  }
    else
  {
    ETG_TRACE_USR4(("Received HFP value is: %d",HFPDisplay));
      poMainApplInstance->pGetAudioFunctionptr()->HFPDisplay_Active(false);
  }

}

tVoid fc_audiomanager_csmSignal_Handler::vRxSignal_TCU_MuteRadioOrder(tU32 tu32SignalId)
{
#if !defined (LSIM)
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
  ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vRxSignal_TCU_MuteRadioOrder() called"));
  // to post PO message to volume manager to attenuate streams
  tBool  au8Data_ReadBuffer = FALSE;
        tU32 u32StatusRead      = CSM_C_SIGNAL_DATA_INVALID;
        tU32 u32CsmHandle;

        tBool bChanged = FALSE;
  AUD_POINTER_CHECK_CALL_NO_RET_VALUE(_poMyCSMInterface);
  if(CSM_C_NO_ERROR > _poMyCSMInterface->CSM_lSignalRead( (tVoid*)&u32CsmHandle, tu32SignalId,&au8Data_ReadBuffer,1,&u32StatusRead))
        {
            u32StatusRead = CSM_C_SIGNAL_DATA_INVALID;
        }

  std::map<tU32, tU8>:: iterator it = m_CSMSignalMap.find(tu32SignalId);

  if(u32StatusRead & CSM_C_SIGNAL_TIMEOUT)
  {
        ID_TCUMuteRadioOrder oTCUMute(false);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oTCUMute);
  }
  else if (0 == (u32StatusRead & (CSM_C_SIGNAL_DATA_INVALID | CSM_C_SIGNAL_TIMEOUT | CSM_C_SIGNAL_NOT_RECEIVED)))
  {
    if (it != m_CSMSignalMap.end())
    {
      if(it->second != au8Data_ReadBuffer)
      {
          it->second = au8Data_ReadBuffer;
          bChanged = TRUE;
      }
    }
         }

  ETG_TRACE_USR4(("Beep_CSMSignalInterface:: TCU_MuteRadioOrder : %x",it->second));

  if(bChanged)
  {
          ID_TCUMuteRadioOrder oTCUMute(au8Data_ReadBuffer);
    InternalCommunicationAdapter::getInstance()->POMessages->DeliverMsg(&oTCUMute);
  }
#else
  (tVoid)tu32SignalId;
#endif
#endif
}
 tVoid fc_audiomanager_csmSignal_Handler::vForceCSMSignalRead()
 {
#ifdef MIDW_COMMON_S_IMPORT_INTERFACE_CSM
   ETG_TRACE_USR4(("fc_audiomanager_csmSignal_Handler::vForceCSMSignalRead()"));
   vRxSignal_MuteRadioOrder(CSM_C_ASIG_RX_MuteRadioOrder);
   vRxSignal_TCU_MuteRadioOrder(CSM_C_ASIG_RX_TCU_MuteRadioOrder);
   vRxSignal_FAP_SoundLevelControl(CSM_C_ASIG_RX_FAP_SoundLevelControl);
   if((poMainApplInstance->pGetAudioFunctionptr()->IsPremium2Connected()))
   {
   vRxSignal_HFP_MapContentDisplay(CSM_C_ASIG_RX_HFP_MapContentDisplay);
   }
#endif
 }
