/*******************************************************************************
*
* FILE:          fc_audiomanager_componentfactory_if.h
*
* SW-COMPONENT:  FC_AudioManager application
*
* DESCRIPTION:   Common Interface for project-specific component loaders
*
*******************************************************************************/

#ifndef _FC_AUDIOMANAGER_COMPONENT_FACTORY_H_
#define _FC_AUDIOMANAGER_COMPONENT_FACTORY_H_

class fc_audiomanager_tclApp;
class fc_audiomanager_tclService_Audio_Function;

// *****************************************************************************
//
//      fc_audiomanager  I C l i e n t H a n d l e r - V e h i c l e
//
//      Common Interface for either cfc_vehicle or cmb_sensor client
//

class fc_audiomanager_IClientHandler_Vehicle : public ahl_tclBaseOneThreadClientHandler
{
public:
   // factory function (to be implemented with dedicated client - vd_sensor or vd_vehicle)
   static fc_audiomanager_IClientHandler_Vehicle*  poGetInstance(ahl_tclBaseOneThreadApp*  poMainApp);

   /* inline */ virtual /* destructor */ ~fc_audiomanager_IClientHandler_Vehicle()  { }

   // do not use - implementation intentionally missing
   /* default constructor */ fc_audiomanager_IClientHandler_Vehicle (tVoid);
   /* copy constructor */ fc_audiomanager_IClientHandler_Vehicle (const fc_audiomanager_IClientHandler_Vehicle& roRef);
   /* assignment operator */ fc_audiomanager_IClientHandler_Vehicle& operator= (const fc_audiomanager_IClientHandler_Vehicle& roRef);

protected:
   inline /* constructor */ fc_audiomanager_IClientHandler_Vehicle
      (   ahl_tclBaseOneThreadApp*  poMainApp
        , tU16            u16ServiceID
        , tU16            u16MajorVersion
        , tU16            u16MinorVersion
        , tU16            u16ServerAppID = AMT_C_U16_APPID_INVALID
        , tU16            u16OwnSubID = AMT_C_U16_SUBID_DEFAULT
      )
         : ahl_tclBaseOneThreadClientHandler (poMainApp, u16ServiceID, u16MajorVersion
            , u16MinorVersion, u16ServerAppID, u16OwnSubID )
      {      }
};

// *****************************************************************************
//
//      fc_audiomanager  I C l i e n t H a n d l e r - S o u n d t o o l
//
//      Common Interface for either Soundtool or Soundtool_MIB (for DSPStudio)
//
class fc_audiomanager_IClientHandler_Soundtool //not an own service, not an own client (part of service)
{
public:
   // factory function (to be implemented with dedicated client - Soundtool or Soundtool_MIB)
   static fc_audiomanager_IClientHandler_Soundtool* poGetInstance(fc_audiomanager_tclApp*  poMainApp, fc_audiomanager_tclService_Audio_Function* poService);

   virtual /* destructor */ ~fc_audiomanager_IClientHandler_Soundtool();

   // do not use - implementation intentionally missing
   /* default constructor */ fc_audiomanager_IClientHandler_Soundtool (tVoid);
   /* copy constructor */ fc_audiomanager_IClientHandler_Soundtool (const fc_audiomanager_IClientHandler_Soundtool& roRef);
   /* assignment operator */ fc_audiomanager_IClientHandler_Soundtool& operator= (const fc_audiomanager_IClientHandler_Soundtool& roRef);

protected:
   inline fc_audiomanager_IClientHandler_Soundtool(fc_audiomanager_tclApp* /* poMainApp */, fc_audiomanager_tclService_Audio_Function* /* poService */)
   {
     //empty
   }

private:
   static fc_audiomanager_IClientHandler_Soundtool* poInstance;

};
// -----------------------------------------------------------------------------
//
//    add other project-specific loaders ...
//

#endif // _FC_AUDIOMANAGER_COMPONENT_FACTORY_H_

